/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.spi.value;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.qi4j.api.Qi4j;
import org.qi4j.api.association.Association;
import org.qi4j.api.association.AssociationDescriptor;
import org.qi4j.api.association.AssociationStateHolder;
import org.qi4j.api.association.ManyAssociation;
import org.qi4j.api.association.NamedAssociation;
import org.qi4j.api.composite.CompositeInstance;
import org.qi4j.api.entity.EntityComposite;
import org.qi4j.api.entity.EntityReference;
import org.qi4j.api.property.Property;
import org.qi4j.api.property.PropertyDescriptor;
import org.qi4j.api.util.Base64Encoder;
import org.qi4j.api.util.Dates;
import org.qi4j.api.value.ValueComposite;
import org.qi4j.api.value.ValueDescriptor;
import org.qi4j.api.value.ValueSerializationException;
import org.qi4j.api.value.ValueSerializer;
import org.qi4j.functional.Function;
import org.qi4j.functional.Function2;
import org.qi4j.functional.Iterables;

public abstract class ValueSerializerAdapter<OutputType>
implements ValueSerializer {
    private static final String UTF_8 = "UTF-8";
    private final Map<Class<?>, Function2<ValueSerializer.Options, Object, Object>> serializers = new HashMap(16);
    private final Map<Class<?>, ComplexSerializer<Object, OutputType>> complexSerializers = new HashMap(2);

    private static <TO, FROM extends TO> Function2<ValueSerializer.Options, FROM, TO> identitySerializer() {
        return new Function2<ValueSerializer.Options, FROM, TO>(){

            public TO map(ValueSerializer.Options options, FROM from) {
                return from;
            }
        };
    }

    protected final <T> void registerSerializer(Class<T> type, Function2<ValueSerializer.Options, T, Object> serializer) {
        this.serializers.put(type, serializer);
    }

    protected final <T> void registerComplexSerializer(Class<T> type, ComplexSerializer<T, OutputType> serializer) {
        this.complexSerializers.put(type, serializer);
    }

    public ValueSerializerAdapter() {
        this.registerSerializer(String.class, ValueSerializerAdapter.identitySerializer());
        this.registerSerializer(Character.class, ValueSerializerAdapter.identitySerializer());
        this.registerSerializer(Boolean.class, ValueSerializerAdapter.identitySerializer());
        this.registerSerializer(Integer.class, ValueSerializerAdapter.identitySerializer());
        this.registerSerializer(Long.class, ValueSerializerAdapter.identitySerializer());
        this.registerSerializer(Short.class, ValueSerializerAdapter.identitySerializer());
        this.registerSerializer(Byte.class, ValueSerializerAdapter.identitySerializer());
        this.registerSerializer(Float.class, ValueSerializerAdapter.identitySerializer());
        this.registerSerializer(Double.class, ValueSerializerAdapter.identitySerializer());
        this.registerSerializer(BigDecimal.class, new Function2<ValueSerializer.Options, BigDecimal, Object>(){

            public Object map(ValueSerializer.Options options, BigDecimal bigDecimal) {
                return bigDecimal.toString();
            }
        });
        this.registerSerializer(BigInteger.class, new Function2<ValueSerializer.Options, BigInteger, Object>(){

            public Object map(ValueSerializer.Options options, BigInteger bigInteger) {
                return bigInteger.toString();
            }
        });
        this.registerSerializer(Date.class, new Function2<ValueSerializer.Options, Date, Object>(){

            public Object map(ValueSerializer.Options options, Date date) {
                return Dates.toUtcString((Date)date);
            }
        });
        this.registerSerializer(DateTime.class, new Function2<ValueSerializer.Options, DateTime, Object>(){

            public Object map(ValueSerializer.Options options, DateTime date) {
                return date.toString();
            }
        });
        this.registerSerializer(LocalDateTime.class, new Function2<ValueSerializer.Options, LocalDateTime, Object>(){

            public Object map(ValueSerializer.Options options, LocalDateTime date) {
                return date.toString();
            }
        });
        this.registerSerializer(LocalDate.class, new Function2<ValueSerializer.Options, LocalDate, Object>(){

            public Object map(ValueSerializer.Options options, LocalDate date) {
                return date.toString();
            }
        });
        this.registerSerializer(EntityReference.class, new Function2<ValueSerializer.Options, EntityReference, Object>(){

            public Object map(ValueSerializer.Options options, EntityReference ref) {
                return ref.toString();
            }
        });
    }

    public final <T> Function<T, String> serialize() {
        return new Function<T, String>(){

            public String map(T object) {
                return ValueSerializerAdapter.this.serialize(object);
            }
        };
    }

    public final <T> Function<T, String> serialize(final ValueSerializer.Options options) {
        return new Function<T, String>(){

            public String map(T object) {
                return ValueSerializerAdapter.this.serialize(options, object);
            }
        };
    }

    @Deprecated
    public final <T> Function<T, String> serialize(final boolean includeTypeInfo) {
        return new Function<T, String>(){

            public String map(T object) {
                return ValueSerializerAdapter.this.serialize(includeTypeInfo ? new ValueSerializer.Options().withTypeInfo() : new ValueSerializer.Options().withoutTypeInfo(), object);
            }
        };
    }

    public final String serialize(Object object) throws ValueSerializationException {
        return this.serialize(new ValueSerializer.Options(), object);
    }

    public final String serialize(ValueSerializer.Options options, Object object) throws ValueSerializationException {
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            this.serializeRoot(options, object, output);
            return output.toString(UTF_8);
        }
        catch (ValueSerializationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ValueSerializationException("Could not serialize value", (Throwable)ex);
        }
    }

    @Deprecated
    public final String serialize(Object object, boolean includeTypeInfo) throws ValueSerializationException {
        return this.serialize(includeTypeInfo ? new ValueSerializer.Options().withTypeInfo() : new ValueSerializer.Options().withoutTypeInfo(), object);
    }

    public final void serialize(Object object, OutputStream output) throws ValueSerializationException {
        this.serialize(new ValueSerializer.Options(), object, output);
    }

    public final void serialize(ValueSerializer.Options options, Object object, OutputStream output) throws ValueSerializationException {
        try {
            this.serializeRoot(options, object, output);
        }
        catch (ValueSerializationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ValueSerializationException("Could not serialize value", (Throwable)ex);
        }
    }

    @Deprecated
    public final void serialize(Object object, OutputStream output, boolean includeTypeInfo) throws ValueSerializationException {
        this.serialize(includeTypeInfo ? new ValueSerializer.Options().withTypeInfo() : new ValueSerializer.Options().withoutTypeInfo(), object, output);
    }

    private void serializeRoot(ValueSerializer.Options options, Object object, OutputStream output) throws Exception {
        if (object != null) {
            if (this.serializers.get(object.getClass()) != null) {
                Object serialized = this.serializers.get(object.getClass()).map((Object)options, object);
                output.write(serialized.toString().getBytes(UTF_8));
            } else if (object.getClass().isEnum()) {
                output.write(object.toString().getBytes(UTF_8));
            } else if (object.getClass().isArray()) {
                output.write(this.serializeBase64Serializable(object).getBytes(UTF_8));
            } else {
                OutputType adaptedOutput = this.adaptOutput(output);
                this.onSerializationStart(object, adaptedOutput);
                this.doSerialize(options, object, adaptedOutput, true);
                this.onSerializationEnd(object, adaptedOutput);
            }
        }
    }

    private void doSerialize(ValueSerializer.Options options, Object object, OutputType output, boolean rootPass) throws Exception {
        if (object == null) {
            this.onValue(output, null);
        } else if (this.serializers.get(object.getClass()) != null) {
            this.onValue(output, this.serializers.get(object.getClass()).map((Object)options, object));
        } else if (this.complexSerializers.get(object.getClass()) != null) {
            this.complexSerializers.get(object.getClass()).serialize(options, object, output);
        } else if (ValueComposite.class.isAssignableFrom(object.getClass())) {
            this.serializeValueComposite(options, object, output, rootPass);
        } else if (EntityComposite.class.isAssignableFrom(object.getClass())) {
            this.serializeEntityComposite(object, output);
        } else if (Iterable.class.isAssignableFrom(object.getClass())) {
            this.serializeIterable(options, object, output);
        } else if (object.getClass().isArray()) {
            this.serializeBase64Serializable(object, output);
        } else if (Map.class.isAssignableFrom(object.getClass())) {
            this.serializeMap(options, object, output);
        } else if (object.getClass().isEnum()) {
            this.onValue(output, object.toString());
        } else {
            this.serializeBase64Serializable(object, output);
        }
    }

    private void serializeValueComposite(ValueSerializer.Options options, Object object, OutputType output, boolean rootPass) throws Exception {
        CompositeInstance valueInstance = (CompositeInstance)Qi4j.FUNCTION_COMPOSITE_INSTANCE_OF.map((Object)((ValueComposite)object));
        ValueDescriptor descriptor = (ValueDescriptor)valueInstance.descriptor();
        AssociationStateHolder state = (AssociationStateHolder)valueInstance.state();
        this.onObjectStart(output);
        if (options.getBoolean("includeTypeInfo").booleanValue() && !rootPass) {
            this.onFieldStart(output, "_type");
            this.onValueStart(output);
            this.onValue(output, ((Class)Iterables.first((Iterable)descriptor.valueType().types())).getName());
            this.onValueEnd(output);
            this.onFieldEnd(output);
        }
        for (PropertyDescriptor persistentProperty : descriptor.valueType().properties()) {
            Property property = state.propertyFor(persistentProperty.accessor());
            this.onFieldStart(output, persistentProperty.qualifiedName().name());
            this.onValueStart(output);
            this.doSerialize(options, property.get(), output, false);
            this.onValueEnd(output);
            this.onFieldEnd(output);
        }
        for (AssociationDescriptor associationDescriptor : descriptor.valueType().associations()) {
            Association association = state.associationFor(associationDescriptor.accessor());
            this.onFieldStart(output, associationDescriptor.qualifiedName().name());
            this.onValueStart(output);
            EntityReference ref = association.reference();
            if (ref == null) {
                this.onValue(output, null);
            } else {
                this.onValue(output, ref.identity());
            }
            this.onValueEnd(output);
            this.onFieldEnd(output);
        }
        for (AssociationDescriptor associationDescriptor : descriptor.valueType().manyAssociations()) {
            ManyAssociation manyAssociation = state.manyAssociationFor(associationDescriptor.accessor());
            this.onFieldStart(output, associationDescriptor.qualifiedName().name());
            this.onValueStart(output);
            this.onArrayStart(output);
            for (EntityReference ref : manyAssociation.references()) {
                this.onValueStart(output);
                this.onValue(output, ref.identity());
                this.onValueEnd(output);
            }
            this.onArrayEnd(output);
            this.onValueEnd(output);
            this.onFieldEnd(output);
        }
        for (AssociationDescriptor associationDescriptor : descriptor.valueType().namedAssociations()) {
            NamedAssociation namedAssociation = state.namedAssociationFor(associationDescriptor.accessor());
            this.onFieldStart(output, associationDescriptor.qualifiedName().name());
            this.onValueStart(output);
            this.onObjectStart(output);
            for (String name : namedAssociation) {
                this.onFieldStart(output, name);
                this.onValueStart(output);
                EntityReference ref = namedAssociation.referenceOf(name);
                this.onValue(output, ref.identity());
                this.onValueEnd(output);
                this.onFieldEnd(output);
            }
            this.onObjectEnd(output);
            this.onValueEnd(output);
            this.onFieldEnd(output);
        }
        this.onObjectEnd(output);
    }

    private void serializeEntityComposite(Object object, OutputType output) throws Exception {
        this.onValue(output, EntityReference.entityReferenceFor((Object)object));
    }

    private void serializeIterable(ValueSerializer.Options options, Object object, OutputType output) throws Exception {
        Iterable collection = (Iterable)object;
        this.onArrayStart(output);
        for (Object item : collection) {
            this.onValueStart(output);
            this.doSerialize(options, item, output, false);
            this.onValueEnd(output);
        }
        this.onArrayEnd(output);
    }

    private void serializeMap(ValueSerializer.Options options, Object object, OutputType output) throws Exception {
        Map map = (Map)object;
        if (options.getBoolean("mapentriesasobjects").booleanValue()) {
            this.onObjectStart(output);
            for (Map.Entry entry : map.entrySet()) {
                this.onFieldStart(output, entry.getKey().toString());
                this.onValueStart(output);
                this.doSerialize(options, entry.getValue(), output, false);
                this.onValueEnd(output);
                this.onFieldEnd(output);
            }
            this.onObjectEnd(output);
        } else {
            this.onArrayStart(output);
            for (Map.Entry entry : map.entrySet()) {
                this.onObjectStart(output);
                this.onFieldStart(output, "key");
                this.onValueStart(output);
                this.onValue(output, entry.getKey().toString());
                this.onValueEnd(output);
                this.onFieldEnd(output);
                this.onFieldStart(output, "value");
                this.onValueStart(output);
                this.doSerialize(options, entry.getValue(), output, false);
                this.onValueEnd(output);
                this.onFieldEnd(output);
                this.onObjectEnd(output);
            }
            this.onArrayEnd(output);
        }
    }

    private void serializeBase64Serializable(Object object, OutputType output) throws Exception {
        this.onValue(output, this.serializeBase64Serializable(object));
    }

    private String serializeBase64Serializable(Object object) throws Exception {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try (ObjectOutputStream out = new ObjectOutputStream(bout);){
            out.writeUnshared(object);
        }
        byte[] bytes = Base64Encoder.encode((byte[])bout.toByteArray(), (boolean)true);
        return new String(bytes, UTF_8);
    }

    protected abstract OutputType adaptOutput(OutputStream var1) throws Exception;

    protected void onSerializationStart(Object object, OutputType output) throws Exception {
    }

    protected void onSerializationEnd(Object object, OutputType output) throws Exception {
    }

    protected abstract void onArrayStart(OutputType var1) throws Exception;

    protected abstract void onArrayEnd(OutputType var1) throws Exception;

    protected abstract void onObjectStart(OutputType var1) throws Exception;

    protected abstract void onObjectEnd(OutputType var1) throws Exception;

    protected abstract void onFieldStart(OutputType var1, String var2) throws Exception;

    protected void onFieldEnd(OutputType output) throws Exception {
    }

    protected void onValueStart(OutputType output) throws Exception {
    }

    protected abstract void onValue(OutputType var1, Object var2) throws Exception;

    protected void onValueEnd(OutputType output) throws Exception {
    }

    public static interface ComplexSerializer<T, OutputType> {
        public void serialize(ValueSerializer.Options var1, T var2, OutputType var3) throws Exception;
    }
}

