/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.runtime.activation;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import org.qi4j.api.activation.Activation;
import org.qi4j.api.activation.ActivationEvent;
import org.qi4j.api.activation.ActivationEventListener;
import org.qi4j.api.activation.ActivationException;
import org.qi4j.api.activation.PassivationException;
import org.qi4j.api.service.ServiceReference;
import org.qi4j.runtime.activation.ActivationEventListenerSupport;
import org.qi4j.runtime.activation.ActivatorsInstance;

public final class ActivationDelegate
extends ActivationEventListenerSupport {
    private final Object target;
    private final boolean fireEvents;
    private ActivatorsInstance targetActivators = null;
    private final LinkedList<Activation> activeChildren = new LinkedList();

    public ActivationDelegate(Object target) {
        this(target, true);
    }

    public ActivationDelegate(Object target, boolean fireEvents) {
        this.target = target;
        this.fireEvents = fireEvents;
    }

    public void activate(ActivatorsInstance targetActivators, Activation child) throws Exception {
        this.activate(targetActivators, Collections.singleton(child), null);
    }

    public void activate(ActivatorsInstance targetActivators, Activation child, Runnable callback) throws Exception {
        this.activate(targetActivators, Collections.singleton(child), callback);
    }

    public void activate(ActivatorsInstance targetActivators, Iterable<? extends Activation> children) throws ActivationException {
        this.activate(targetActivators, children, null);
    }

    public void activate(ActivatorsInstance targetActivators, Iterable<? extends Activation> children, Runnable callback) throws ActivationException {
        if (this.targetActivators != null) {
            throw new IllegalStateException("Activation.activate() called multiple times or without calling passivate() first!");
        }
        try {
            if (this.fireEvents) {
                this.fireEvent(new ActivationEvent(this.target, ActivationEvent.EventType.ACTIVATING));
            }
            targetActivators.beforeActivation(this.target instanceof ServiceReference ? new PassiveServiceReference((ServiceReference)this.target) : this.target);
            for (Activation activation : children) {
                if (!this.activeChildren.contains(activation)) {
                    activation.activate();
                }
                this.activeChildren.addFirst(activation);
            }
            if (callback != null) {
                callback.run();
            }
            targetActivators.afterActivation(this.target);
            if (this.fireEvents) {
                this.fireEvent(new ActivationEvent(this.target, ActivationEvent.EventType.ACTIVATED));
            }
            this.targetActivators = targetActivators;
        }
        catch (Exception e) {
            try {
                this.passivate();
            }
            catch (PassivationException passivationException) {
                ActivationException activationEx = new ActivationException("Unable to Activate application.", (Throwable)e);
                activationEx.addSuppressed((Throwable)passivationException);
                throw activationEx;
            }
            if (e instanceof ActivationException) {
                throw (ActivationException)e;
            }
            throw new ActivationException("Unable to Activate application.", (Throwable)e);
        }
    }

    public void passivate() throws PassivationException {
        this.passivate(null);
    }

    public void passivate(Runnable callback) throws PassivationException {
        ActivationEvent event;
        LinkedHashSet<Exception> exceptions = new LinkedHashSet<Exception>();
        if (this.fireEvents) {
            event = new ActivationEvent(this.target, ActivationEvent.EventType.PASSIVATING);
            for (ActivationEventListener listener : this.listeners) {
                try {
                    listener.onEvent(event);
                }
                catch (Exception ex) {
                    if (ex instanceof PassivationException) {
                        exceptions.addAll(((PassivationException)((Object)ex)).causes());
                        continue;
                    }
                    exceptions.add(ex);
                }
            }
        }
        if (this.targetActivators != null) {
            try {
                this.targetActivators.beforePassivation(this.target);
            }
            catch (PassivationException ex) {
                exceptions.addAll(ex.causes());
            }
            catch (Exception ex) {
                exceptions.add(ex);
            }
        }
        while (!this.activeChildren.isEmpty()) {
            this.passivateOneChild(exceptions);
        }
        if (callback != null) {
            try {
                callback.run();
            }
            catch (Exception ex) {
                if (ex instanceof PassivationException) {
                    exceptions.addAll(((PassivationException)((Object)ex)).causes());
                }
                exceptions.add(ex);
            }
        }
        if (this.targetActivators != null) {
            try {
                this.targetActivators.afterPassivation(this.target instanceof ServiceReference ? new PassiveServiceReference((ServiceReference)this.target) : this.target);
            }
            catch (PassivationException ex) {
                exceptions.addAll(ex.causes());
            }
            catch (Exception ex) {
                exceptions.add(ex);
            }
        }
        this.targetActivators = null;
        if (this.fireEvents) {
            event = new ActivationEvent(this.target, ActivationEvent.EventType.PASSIVATED);
            for (ActivationEventListener listener : this.listeners) {
                try {
                    listener.onEvent(event);
                }
                catch (Exception ex) {
                    if (ex instanceof PassivationException) {
                        exceptions.addAll(((PassivationException)((Object)ex)).causes());
                        continue;
                    }
                    exceptions.add(ex);
                }
            }
        }
        if (exceptions.isEmpty()) {
            return;
        }
        throw new PassivationException(exceptions);
    }

    private void passivateOneChild(Set<Exception> exceptions) {
        Activation activeChild = this.activeChildren.removeFirst();
        try {
            activeChild.passivate();
        }
        catch (PassivationException ex) {
            exceptions.addAll(ex.causes());
        }
        catch (Exception ex) {
            exceptions.add(ex);
        }
    }

    private static class PassiveServiceReference
    implements ServiceReference {
        private final ServiceReference reference;

        private PassiveServiceReference(ServiceReference reference) {
            this.reference = reference;
        }

        public String identity() {
            return this.reference.identity();
        }

        public Object get() {
            throw new IllegalStateException("Service is passive, either activating and cannot be used yet or passivating and cannot be used anymore.");
        }

        public boolean isActive() {
            return false;
        }

        public boolean isAvailable() {
            return false;
        }

        public Iterable<Class<?>> types() {
            return this.reference.types();
        }

        public <T> T metaInfo(Class<T> infoType) {
            return (T)this.reference.metaInfo(infoType);
        }

        public void registerActivationEventListener(ActivationEventListener listener) {
            this.reference.registerActivationEventListener(listener);
        }

        public void deregisterActivationEventListener(ActivationEventListener listener) {
            this.reference.deregisterActivationEventListener(listener);
        }

        public int hashCode() {
            return this.identity().hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ServiceReference other = (ServiceReference)obj;
            return this.identity().equals(other.identity());
        }

        public String toString() {
            return this.reference.toString();
        }
    }
}

