/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.runtime.activation;

import org.qi4j.api.activation.Activator;
import org.qi4j.api.activation.ActivatorDescriptor;
import org.qi4j.api.common.ConstructionException;
import org.qi4j.functional.HierarchicalVisitor;
import org.qi4j.functional.VisitableHierarchy;
import org.qi4j.runtime.composite.ConstructorsModel;
import org.qi4j.runtime.injection.InjectedFieldsModel;
import org.qi4j.runtime.injection.InjectedMethodsModel;
import org.qi4j.runtime.injection.InjectionContext;

public class ActivatorModel<ActivateeType>
implements ActivatorDescriptor,
VisitableHierarchy<Object, Object> {
    private final Class<? extends Activator<ActivateeType>> activatorType;
    private final ConstructorsModel constructorsModel;
    private final InjectedFieldsModel injectedFieldsModel;
    private final InjectedMethodsModel injectedMethodsModel;

    public ActivatorModel(Class<? extends Activator<ActivateeType>> activatorType) {
        this.activatorType = activatorType;
        this.constructorsModel = new ConstructorsModel(activatorType);
        this.injectedFieldsModel = new InjectedFieldsModel(activatorType);
        this.injectedMethodsModel = new InjectedMethodsModel(activatorType);
    }

    public <ThrowableType extends Throwable> boolean accept(HierarchicalVisitor<? super Object, ? super Object, ThrowableType> visitor) throws ThrowableType {
        if (visitor.visitEnter((Object)this) && this.constructorsModel.accept(visitor) && this.injectedFieldsModel.accept(visitor)) {
            this.injectedMethodsModel.accept(visitor);
        }
        return visitor.visitLeave((Object)this);
    }

    public Activator<ActivateeType> newInstance() {
        try {
            return this.activatorType.newInstance();
        }
        catch (IllegalAccessException | InstantiationException ex) {
            throw new ConstructionException("Could not instantiate " + this.activatorType.getName(), (Throwable)ex);
        }
    }

    public Activator<ActivateeType> newInstance(InjectionContext injectionContext) {
        try {
            Activator instance = (Activator)this.constructorsModel.newInstance(injectionContext);
            injectionContext = new InjectionContext(injectionContext.module(), injectionContext.uses(), instance);
            this.inject(injectionContext, instance);
            return instance;
        }
        catch (Exception ex) {
            throw new ConstructionException("Could not instantiate " + this.activatorType.getName(), (Throwable)ex);
        }
    }

    public void inject(InjectionContext injectionContext, Activator<ActivateeType> instance) {
        this.injectedFieldsModel.inject(injectionContext, instance);
        this.injectedMethodsModel.inject(injectionContext, instance);
    }

    public String toString() {
        return this.activatorType.getName();
    }
}

