/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.runtime.association;

import java.lang.reflect.Type;
import org.qi4j.api.association.Association;
import org.qi4j.api.association.AssociationDescriptor;
import org.qi4j.api.association.AssociationWrapper;
import org.qi4j.api.entity.EntityReference;
import org.qi4j.api.entity.Identity;
import org.qi4j.api.property.Property;
import org.qi4j.functional.Function2;
import org.qi4j.runtime.association.AbstractAssociationInstance;
import org.qi4j.runtime.association.AssociationInfo;

public final class AssociationInstance<T>
extends AbstractAssociationInstance<T>
implements Association<T> {
    private Property<EntityReference> associationState;

    public AssociationInstance(AssociationInfo associationInfo, Function2<EntityReference, Type, Object> entityFunction, Property<EntityReference> associationState) {
        super(associationInfo, entityFunction);
        this.associationState = associationState;
    }

    public T get() {
        return this.getEntity((EntityReference)this.associationState.get());
    }

    public void set(T newValue) throws IllegalArgumentException {
        this.checkImmutable();
        this.checkType(newValue);
        this.associationInfo.checkConstraints(newValue);
        this.associationState.set((Object)EntityReference.create((Identity)((Identity)newValue)));
    }

    public EntityReference reference() {
        return (EntityReference)this.associationState.get();
    }

    public Property<EntityReference> getAssociationState() {
        return this.associationState;
    }

    public String toString() {
        if (this.associationState.get() == null) {
            return "";
        }
        return ((EntityReference)this.associationState.get()).toString();
    }

    public int hashCode() {
        int hash = this.associationInfo.hashCode() * 39;
        if (this.associationState.get() != null) {
            hash = hash * 997 + ((EntityReference)this.associationState.get()).hashCode();
        }
        return hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Association that = (Association)o;
        while (that instanceof AssociationWrapper) {
            that = ((AssociationWrapper)that).next();
        }
        AssociationInstance thatInstance = (AssociationInstance)that;
        AssociationDescriptor thatDescriptor = (AssociationDescriptor)thatInstance.associationInfo();
        if (!this.associationInfo.equals(thatDescriptor)) {
            return false;
        }
        return !(this.associationState.get() != null ? !((EntityReference)this.associationState.get()).equals(thatInstance.associationState.get()) : thatInstance.associationState.get() != null);
    }
}

