/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.runtime.association;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.List;
import org.qi4j.api.association.Association;
import org.qi4j.api.association.AssociationDescriptor;
import org.qi4j.api.association.GenericAssociationInfo;
import org.qi4j.api.common.MetaInfo;
import org.qi4j.api.common.QualifiedName;
import org.qi4j.api.composite.Composite;
import org.qi4j.api.constraint.ConstraintViolation;
import org.qi4j.api.constraint.ConstraintViolationException;
import org.qi4j.api.entity.Aggregated;
import org.qi4j.api.entity.Queryable;
import org.qi4j.api.property.Immutable;
import org.qi4j.api.util.Classes;
import org.qi4j.bootstrap.BindingException;
import org.qi4j.functional.Iterables;
import org.qi4j.functional.Visitable;
import org.qi4j.functional.Visitor;
import org.qi4j.runtime.association.AssociationInfo;
import org.qi4j.runtime.composite.ValueConstraintsInstance;
import org.qi4j.runtime.model.Binder;
import org.qi4j.runtime.model.Resolution;

public final class AssociationModel
implements AssociationDescriptor,
AssociationInfo,
Binder,
Visitable<AssociationModel> {
    private MetaInfo metaInfo;
    private Type type;
    private AccessibleObject accessor;
    private QualifiedName qualifiedName;
    private ValueConstraintsInstance constraints;
    private ValueConstraintsInstance associationConstraints;
    private boolean queryable;
    private boolean immutable;
    private boolean aggregated;
    private AssociationInfo builderInfo;

    public AssociationModel(AccessibleObject accessor, ValueConstraintsInstance valueConstraintsInstance, ValueConstraintsInstance associationConstraintsInstance, MetaInfo metaInfo) {
        this.metaInfo = metaInfo;
        this.constraints = valueConstraintsInstance;
        this.associationConstraints = associationConstraintsInstance;
        this.accessor = accessor;
        this.initialize();
    }

    private void initialize() {
        this.type = GenericAssociationInfo.associationTypeOf((AccessibleObject)this.accessor);
        this.qualifiedName = QualifiedName.fromAccessor((AccessibleObject)this.accessor);
        this.immutable = this.metaInfo.get(Immutable.class) != null;
        this.aggregated = this.metaInfo.get(Aggregated.class) != null;
        Queryable queryable = this.accessor.getAnnotation(Queryable.class);
        this.queryable = queryable == null || queryable.value();
    }

    public <T> T metaInfo(Class<T> infoType) {
        return (T)this.metaInfo.get(infoType);
    }

    @Override
    public QualifiedName qualifiedName() {
        return this.qualifiedName;
    }

    @Override
    public Type type() {
        return this.type;
    }

    @Override
    public boolean isImmutable() {
        return this.immutable;
    }

    public boolean isAggregated() {
        return this.aggregated;
    }

    public AccessibleObject accessor() {
        return this.accessor;
    }

    public boolean queryable() {
        return this.queryable;
    }

    public AssociationInfo getBuilderInfo() {
        return this.builderInfo;
    }

    public <ThrowableType extends Throwable> boolean accept(Visitor<? super AssociationModel, ThrowableType> visitor) throws ThrowableType {
        return visitor.visit((Object)this);
    }

    @Override
    public void checkConstraints(Object value) throws ConstraintViolationException {
        List<ConstraintViolation> violations;
        if (this.constraints != null && !(violations = this.constraints.checkConstraints(value)).isEmpty()) {
            Iterable empty = Iterables.empty();
            throw new ConstraintViolationException("", empty, (Member)((Object)this.accessor), violations);
        }
    }

    public void checkAssociationConstraints(Association<?> association) throws ConstraintViolationException {
        List<ConstraintViolation> violations;
        if (this.associationConstraints != null && !(violations = this.associationConstraints.checkConstraints(association)).isEmpty()) {
            throw new ConstraintViolationException((Composite)association.get(), (Member)((Object)this.accessor), violations);
        }
    }

    @Override
    public void bind(Resolution resolution) throws BindingException {
        this.builderInfo = new AssociationInfo(){

            @Override
            public boolean isImmutable() {
                return false;
            }

            @Override
            public QualifiedName qualifiedName() {
                return AssociationModel.this.qualifiedName;
            }

            @Override
            public Type type() {
                return AssociationModel.this.type;
            }

            @Override
            public void checkConstraints(Object value) throws ConstraintViolationException {
                AssociationModel.this.checkConstraints(value);
            }
        };
        if (this.type instanceof TypeVariable) {
            Class mainType = (Class)Iterables.first((Iterable)resolution.model().types());
            this.type = Classes.resolveTypeVariable((TypeVariable)((TypeVariable)this.type), ((Member)((Object)this.accessor)).getDeclaringClass(), (Class)mainType);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssociationModel that = (AssociationModel)o;
        return this.accessor.equals(that.accessor);
    }

    public int hashCode() {
        return this.accessor.hashCode();
    }

    public String toString() {
        if (this.accessor instanceof Field) {
            return ((Field)this.accessor).toGenericString();
        }
        return ((Method)this.accessor).toGenericString();
    }
}

