/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.runtime.association;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Member;
import java.util.LinkedHashMap;
import java.util.Map;
import org.qi4j.api.association.Association;
import org.qi4j.api.association.AssociationDescriptor;
import org.qi4j.api.association.AssociationStateHolder;
import org.qi4j.api.common.QualifiedName;
import org.qi4j.functional.HierarchicalVisitor;
import org.qi4j.functional.VisitableHierarchy;
import org.qi4j.runtime.association.AssociationModel;

public final class AssociationsModel
implements VisitableHierarchy<AssociationsModel, AssociationModel> {
    private final Map<AccessibleObject, AssociationModel> mapAccessorAssociationModel = new LinkedHashMap<AccessibleObject, AssociationModel>();

    public Iterable<AssociationModel> associations() {
        return this.mapAccessorAssociationModel.values();
    }

    public void addAssociation(AssociationModel associationModel) {
        this.mapAccessorAssociationModel.put(associationModel.accessor(), associationModel);
    }

    public <ThrowableType extends Throwable> boolean accept(HierarchicalVisitor<? super AssociationsModel, ? super AssociationModel, ThrowableType> visitor) throws ThrowableType {
        block1: {
            if (!visitor.visitEnter((Object)this)) break block1;
            for (AssociationModel associationModel : this.mapAccessorAssociationModel.values()) {
                if (!associationModel.accept(visitor)) break;
            }
        }
        return visitor.visitLeave((Object)this);
    }

    public AssociationModel getAssociation(AccessibleObject accessor) throws IllegalArgumentException {
        AssociationModel associationModel = this.mapAccessorAssociationModel.get(accessor);
        if (associationModel == null) {
            throw new IllegalArgumentException("No association found with name:" + ((Member)((Object)accessor)).getName());
        }
        return associationModel;
    }

    public AssociationDescriptor getAssociationByName(String name) throws IllegalArgumentException {
        for (AssociationModel associationModel : this.mapAccessorAssociationModel.values()) {
            if (!associationModel.qualifiedName().name().equals(name)) continue;
            return associationModel;
        }
        throw new IllegalArgumentException("No association found with name:" + name);
    }

    public AssociationDescriptor getAssociationByQualifiedName(QualifiedName name) throws IllegalArgumentException {
        for (AssociationModel associationModel : this.mapAccessorAssociationModel.values()) {
            if (!associationModel.qualifiedName().equals((Object)name)) continue;
            return associationModel;
        }
        throw new IllegalArgumentException("No association found with qualified name:" + name);
    }

    public void checkConstraints(AssociationStateHolder state) {
        for (AssociationModel associationModel : this.mapAccessorAssociationModel.values()) {
            Association association = state.associationFor(associationModel.accessor());
            associationModel.checkAssociationConstraints(association);
            associationModel.checkConstraints(association.get());
        }
    }
}

