/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.runtime.association;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.qi4j.api.association.AssociationDescriptor;
import org.qi4j.api.association.ManyAssociation;
import org.qi4j.api.association.ManyAssociationWrapper;
import org.qi4j.api.entity.EntityReference;
import org.qi4j.api.entity.Identity;
import org.qi4j.api.util.NullArgumentException;
import org.qi4j.functional.Function2;
import org.qi4j.functional.Iterables;
import org.qi4j.runtime.association.AbstractAssociationInstance;
import org.qi4j.runtime.association.AssociationInfo;
import org.qi4j.spi.entity.ManyAssociationState;

public class ManyAssociationInstance<T>
extends AbstractAssociationInstance<T>
implements ManyAssociation<T> {
    private ManyAssociationState manyAssociationState;

    public ManyAssociationInstance(AssociationInfo associationInfo, Function2<EntityReference, Type, Object> associationFunction, ManyAssociationState manyAssociationState) {
        super(associationInfo, associationFunction);
        this.manyAssociationState = manyAssociationState;
    }

    public int count() {
        return this.manyAssociationState.count();
    }

    public boolean contains(T entity) {
        return this.manyAssociationState.contains(this.getEntityReference(entity));
    }

    public boolean add(int i, T entity) {
        NullArgumentException.validateNotNull((String)"entity", entity);
        this.checkImmutable();
        this.checkType(entity);
        this.associationInfo.checkConstraints(entity);
        return this.manyAssociationState.add(i, new EntityReference((String)((Identity)entity).identity().get()));
    }

    public boolean add(T entity) {
        return this.add(this.manyAssociationState.count(), entity);
    }

    public boolean remove(T entity) {
        NullArgumentException.validateNotNull((String)"entity", entity);
        this.checkImmutable();
        this.checkType(entity);
        return this.manyAssociationState.remove(new EntityReference((String)((Identity)entity).identity().get()));
    }

    public T get(int i) {
        return this.getEntity(this.manyAssociationState.get(i));
    }

    public List<T> toList() {
        ArrayList list = new ArrayList();
        for (EntityReference entityReference : this.manyAssociationState) {
            list.add(this.getEntity(entityReference));
        }
        return list;
    }

    public Set<T> toSet() {
        HashSet set = new HashSet();
        for (EntityReference entityReference : this.manyAssociationState) {
            set.add(this.getEntity(entityReference));
        }
        return set;
    }

    public Iterable<EntityReference> references() {
        return Iterables.toList((Iterable)this.manyAssociationState);
    }

    public String toString() {
        return this.manyAssociationState.toString();
    }

    public Iterator<T> iterator() {
        return new ManyAssociationIterator(this.manyAssociationState.iterator());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ManyAssociation that = (ManyAssociation)o;
        while (that instanceof ManyAssociationWrapper) {
            that = ((ManyAssociationWrapper)that).next();
        }
        ManyAssociationInstance thatInstance = (ManyAssociationInstance)that;
        AssociationDescriptor thatDescriptor = (AssociationDescriptor)thatInstance.associationInfo();
        if (!this.associationInfo.equals(thatDescriptor)) {
            return false;
        }
        if (this.manyAssociationState.count() != thatInstance.manyAssociationState.count()) {
            return false;
        }
        for (EntityReference ref : this.manyAssociationState) {
            if (thatInstance.manyAssociationState.contains(ref)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = this.associationInfo.hashCode() * 31;
        for (EntityReference ref : this.manyAssociationState) {
            hash += ref.hashCode() * 7;
        }
        return hash;
    }

    public ManyAssociationState getManyAssociationState() {
        return this.manyAssociationState;
    }

    protected class ManyAssociationIterator
    implements Iterator<T> {
        private final Iterator<EntityReference> idIterator;

        public ManyAssociationIterator(Iterator<EntityReference> idIterator) {
            this.idIterator = idIterator;
        }

        @Override
        public boolean hasNext() {
            return this.idIterator.hasNext();
        }

        @Override
        public T next() {
            return ManyAssociationInstance.this.getEntity(this.idIterator.next());
        }

        @Override
        public void remove() {
            ManyAssociationInstance.this.checkImmutable();
            this.idIterator.remove();
        }
    }
}

