/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.runtime.association;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.List;
import org.qi4j.api.association.AssociationDescriptor;
import org.qi4j.api.association.GenericAssociationInfo;
import org.qi4j.api.association.ManyAssociation;
import org.qi4j.api.common.MetaInfo;
import org.qi4j.api.common.QualifiedName;
import org.qi4j.api.constraint.ConstraintViolation;
import org.qi4j.api.constraint.ConstraintViolationException;
import org.qi4j.api.entity.Aggregated;
import org.qi4j.api.entity.EntityReference;
import org.qi4j.api.entity.Queryable;
import org.qi4j.api.property.Immutable;
import org.qi4j.api.util.Classes;
import org.qi4j.bootstrap.BindingException;
import org.qi4j.functional.Function2;
import org.qi4j.functional.Iterables;
import org.qi4j.functional.Visitable;
import org.qi4j.functional.Visitor;
import org.qi4j.runtime.association.AssociationInfo;
import org.qi4j.runtime.association.ManyAssociationInstance;
import org.qi4j.runtime.composite.ValueConstraintsInstance;
import org.qi4j.runtime.model.Binder;
import org.qi4j.runtime.model.Resolution;
import org.qi4j.runtime.structure.ModuleUnitOfWork;
import org.qi4j.runtime.unitofwork.BuilderEntityState;
import org.qi4j.spi.entity.EntityState;

public final class ManyAssociationModel
implements AssociationDescriptor,
AssociationInfo,
Binder,
Visitable<ManyAssociationModel> {
    private final ValueConstraintsInstance associationConstraints;
    private final MetaInfo metaInfo;
    private Type type;
    private final AccessibleObject accessor;
    private QualifiedName qualifiedName;
    private final ValueConstraintsInstance constraints;
    private boolean queryable;
    private boolean immutable;
    private boolean aggregated;
    private AssociationInfo builderInfo;

    public ManyAssociationModel(AccessibleObject accessor, ValueConstraintsInstance valueConstraintsInstance, ValueConstraintsInstance associationConstraintsInstance, MetaInfo metaInfo) {
        this.metaInfo = metaInfo;
        this.constraints = valueConstraintsInstance;
        this.associationConstraints = associationConstraintsInstance;
        this.accessor = accessor;
        this.initialize();
    }

    private void initialize() {
        this.type = GenericAssociationInfo.associationTypeOf((AccessibleObject)this.accessor);
        this.qualifiedName = QualifiedName.fromAccessor((AccessibleObject)this.accessor);
        this.immutable = this.metaInfo.get(Immutable.class) != null;
        this.aggregated = this.metaInfo.get(Aggregated.class) != null;
        Queryable queryable = this.accessor.getAnnotation(Queryable.class);
        this.queryable = queryable == null || queryable.value();
    }

    public <T> T metaInfo(Class<T> infoType) {
        return (T)this.metaInfo.get(infoType);
    }

    @Override
    public QualifiedName qualifiedName() {
        return this.qualifiedName;
    }

    @Override
    public Type type() {
        return this.type;
    }

    @Override
    public boolean isImmutable() {
        return this.immutable;
    }

    public boolean isAggregated() {
        return this.aggregated;
    }

    public AccessibleObject accessor() {
        return this.accessor;
    }

    public boolean queryable() {
        return this.queryable;
    }

    public AssociationInfo getBuilderInfo() {
        return this.builderInfo;
    }

    public <T> ManyAssociation<T> newInstance(final ModuleUnitOfWork uow, EntityState state) {
        return new ManyAssociationInstance(state instanceof BuilderEntityState ? this.builderInfo : this, new Function2<EntityReference, Type, Object>(){

            public Object map(EntityReference entityReference, Type type) {
                return uow.get((Class)Classes.RAW_CLASS.map((Object)type), entityReference.identity());
            }
        }, state.manyAssociationValueOf(this.qualifiedName));
    }

    @Override
    public void checkConstraints(Object composite) throws ConstraintViolationException {
        List<ConstraintViolation> violations;
        if (this.constraints != null && !(violations = this.constraints.checkConstraints(composite)).isEmpty()) {
            Iterable empty = Iterables.empty();
            throw new ConstraintViolationException("", empty, (Member)((Object)this.accessor), violations);
        }
    }

    public void checkAssociationConstraints(ManyAssociation manyAssociation) throws ConstraintViolationException {
        List<ConstraintViolation> violations;
        if (this.associationConstraints != null && !(violations = this.associationConstraints.checkConstraints(manyAssociation)).isEmpty()) {
            Iterable empty = Iterables.empty();
            throw new ConstraintViolationException("", empty, (Member)((Object)this.accessor), violations);
        }
    }

    public <ThrowableType extends Throwable> boolean accept(Visitor<? super ManyAssociationModel, ThrowableType> visitor) throws ThrowableType {
        return visitor.visit((Object)this);
    }

    @Override
    public void bind(Resolution resolution) throws BindingException {
        this.builderInfo = new AssociationInfo(){

            @Override
            public boolean isImmutable() {
                return false;
            }

            @Override
            public QualifiedName qualifiedName() {
                return ManyAssociationModel.this.qualifiedName;
            }

            @Override
            public Type type() {
                return ManyAssociationModel.this.type;
            }

            @Override
            public void checkConstraints(Object value) throws ConstraintViolationException {
                ManyAssociationModel.this.checkConstraints(value);
            }
        };
        if (this.type instanceof TypeVariable) {
            Class mainType = (Class)Iterables.first((Iterable)resolution.model().types());
            this.type = Classes.resolveTypeVariable((TypeVariable)((TypeVariable)this.type), ((Member)((Object)this.accessor)).getDeclaringClass(), (Class)mainType);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ManyAssociationModel that = (ManyAssociationModel)o;
        return this.accessor.equals(that.accessor);
    }

    public int hashCode() {
        return this.accessor.hashCode();
    }

    public String toString() {
        if (this.accessor instanceof Field) {
            return ((Field)this.accessor).toGenericString();
        }
        return ((Method)this.accessor).toGenericString();
    }
}

