/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.runtime.association;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.qi4j.api.association.AssociationDescriptor;
import org.qi4j.api.association.NamedAssociation;
import org.qi4j.api.association.NamedAssociationWrapper;
import org.qi4j.api.entity.EntityReference;
import org.qi4j.api.entity.Identity;
import org.qi4j.api.util.NullArgumentException;
import org.qi4j.functional.Function;
import org.qi4j.functional.Function2;
import org.qi4j.functional.Iterables;
import org.qi4j.runtime.association.AbstractAssociationInstance;
import org.qi4j.runtime.association.AssociationInfo;
import org.qi4j.spi.entity.NamedAssociationState;

public class NamedAssociationInstance<T>
extends AbstractAssociationInstance<T>
implements NamedAssociation<T> {
    private final NamedAssociationState namedAssociationState;

    public NamedAssociationInstance(AssociationInfo associationInfo, Function2<EntityReference, Type, Object> associationFunction, NamedAssociationState namedAssociationState) {
        super(associationInfo, associationFunction);
        this.namedAssociationState = namedAssociationState;
    }

    public Iterator<String> iterator() {
        return this.namedAssociationState.iterator();
    }

    public int count() {
        return this.namedAssociationState.count();
    }

    public boolean containsName(String name) {
        return this.namedAssociationState.containsName(name);
    }

    public boolean put(String name, T entity) {
        NullArgumentException.validateNotNull((String)"entity", entity);
        this.checkImmutable();
        this.checkType(entity);
        this.associationInfo.checkConstraints(entity);
        return this.namedAssociationState.put(name, new EntityReference((String)((Identity)entity).identity().get()));
    }

    public boolean remove(String name) {
        this.checkImmutable();
        return this.namedAssociationState.remove(name);
    }

    public T get(String name) {
        return this.getEntity(this.namedAssociationState.get(name));
    }

    public String nameOf(T entity) {
        return this.namedAssociationState.nameOf(this.getEntityReference(entity));
    }

    public Map<String, T> toMap() {
        HashMap map = new HashMap();
        for (String name : this.namedAssociationState) {
            map.put(name, this.getEntity(this.namedAssociationState.get(name)));
        }
        return map;
    }

    public Iterable<EntityReference> references() {
        return Iterables.map((Function)new Function<String, EntityReference>(){

            public EntityReference map(String name) {
                return NamedAssociationInstance.this.namedAssociationState.get(name);
            }
        }, (Iterable)this.namedAssociationState);
    }

    public EntityReference referenceOf(String name) {
        return this.namedAssociationState.get(name);
    }

    public Iterable<Map.Entry<String, EntityReference>> getEntityReferences() {
        return Iterables.map((Function)new Function<String, Map.Entry<String, EntityReference>>(){

            public Map.Entry<String, EntityReference> map(final String key) {
                final EntityReference value = NamedAssociationInstance.this.namedAssociationState.get(key);
                return new Map.Entry<String, EntityReference>(){

                    @Override
                    public String getKey() {
                        return key;
                    }

                    @Override
                    public EntityReference getValue() {
                        return value;
                    }

                    @Override
                    public EntityReference setValue(EntityReference value2) {
                        throw new UnsupportedOperationException("Immutable Map");
                    }

                    @Override
                    public boolean equals(Object o) {
                        if (o instanceof Map.Entry) {
                            Map.Entry other = (Map.Entry)o;
                            return key.equals(other.getKey());
                        }
                        return false;
                    }

                    @Override
                    public int hashCode() {
                        return 997 * key.hashCode() + 981813497;
                    }
                };
            }
        }, (Iterable)this.namedAssociationState);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NamedAssociation that = (NamedAssociation)o;
        while (that instanceof NamedAssociationWrapper) {
            that = ((NamedAssociationWrapper)that).next();
        }
        NamedAssociationInstance thatInstance = (NamedAssociationInstance)that;
        AssociationDescriptor thatDescriptor = (AssociationDescriptor)thatInstance.associationInfo();
        if (!this.associationInfo.equals(thatDescriptor)) {
            return false;
        }
        if (this.namedAssociationState.count() != thatInstance.namedAssociationState.count()) {
            return false;
        }
        for (String name : this.namedAssociationState) {
            EntityReference thatReference;
            if (!thatInstance.namedAssociationState.containsName(name)) {
                return false;
            }
            EntityReference thisReference = this.namedAssociationState.get(name);
            if (thisReference.equals((Object)(thatReference = thatInstance.namedAssociationState.get(name)))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = this.associationInfo.hashCode() * 31;
        for (String name : this.namedAssociationState) {
            hash += name.hashCode();
            hash += this.namedAssociationState.get(name).hashCode() * 7;
        }
        return hash;
    }
}

