/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.runtime.association;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Member;
import java.util.LinkedHashMap;
import java.util.Map;
import org.qi4j.api.association.AssociationDescriptor;
import org.qi4j.api.association.NamedAssociation;
import org.qi4j.api.common.QualifiedName;
import org.qi4j.functional.HierarchicalVisitor;
import org.qi4j.functional.VisitableHierarchy;
import org.qi4j.runtime.association.NamedAssociationModel;
import org.qi4j.runtime.structure.ModuleUnitOfWork;
import org.qi4j.runtime.value.ValueStateInstance;
import org.qi4j.spi.entity.EntityState;

public final class NamedAssociationsModel
implements VisitableHierarchy<NamedAssociationsModel, NamedAssociationModel> {
    private final Map<AccessibleObject, NamedAssociationModel> mapAccessorAssociationModel = new LinkedHashMap<AccessibleObject, NamedAssociationModel>();

    public Iterable<NamedAssociationModel> namedAssociations() {
        return this.mapAccessorAssociationModel.values();
    }

    public void addNamedAssociation(NamedAssociationModel model) {
        this.mapAccessorAssociationModel.put(model.accessor(), model);
    }

    public <ThrowableType extends Throwable> boolean accept(HierarchicalVisitor<? super NamedAssociationsModel, ? super NamedAssociationModel, ThrowableType> visitor) throws ThrowableType {
        block1: {
            if (!visitor.visitEnter((Object)this)) break block1;
            for (NamedAssociationModel associationModel : this.mapAccessorAssociationModel.values()) {
                if (!associationModel.accept(visitor)) break;
            }
        }
        return visitor.visitLeave((Object)this);
    }

    public <T> NamedAssociation<T> newInstance(AccessibleObject accessor, EntityState entityState, ModuleUnitOfWork uow) {
        return this.mapAccessorAssociationModel.get(accessor).newInstance(uow, entityState);
    }

    public NamedAssociationModel getNamedAssociation(AccessibleObject accessor) throws IllegalArgumentException {
        NamedAssociationModel namedAssociationModel = this.mapAccessorAssociationModel.get(accessor);
        if (namedAssociationModel == null) {
            throw new IllegalArgumentException("No named-association found with name:" + ((Member)((Object)accessor)).getName());
        }
        return namedAssociationModel;
    }

    public AssociationDescriptor getNamedAssociationByName(String name) throws IllegalArgumentException {
        for (NamedAssociationModel associationModel : this.mapAccessorAssociationModel.values()) {
            if (!associationModel.qualifiedName().name().equals(name)) continue;
            return associationModel;
        }
        throw new IllegalArgumentException("No named-association found with name:" + name);
    }

    public AssociationDescriptor getNamedAssociationByQualifiedName(QualifiedName name) throws IllegalArgumentException {
        for (NamedAssociationModel associationModel : this.mapAccessorAssociationModel.values()) {
            if (!associationModel.qualifiedName().equals((Object)name)) continue;
            return associationModel;
        }
        throw new IllegalArgumentException("No named-association found with qualified name:" + name);
    }

    public void checkConstraints(ValueStateInstance state) {
        for (NamedAssociationModel associationModel : this.mapAccessorAssociationModel.values()) {
            associationModel.checkAssociationConstraints(state.namedAssociationFor(associationModel.accessor()));
        }
    }
}

