/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.runtime.bootstrap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.qi4j.api.activation.Activator;
import org.qi4j.api.common.MetaInfo;
import org.qi4j.api.common.Visibility;
import org.qi4j.api.composite.TransientComposite;
import org.qi4j.api.entity.EntityComposite;
import org.qi4j.api.entity.Identity;
import org.qi4j.api.service.DuplicateServiceIdentityException;
import org.qi4j.api.service.ServiceImporter;
import org.qi4j.api.structure.Module;
import org.qi4j.api.type.HasTypes;
import org.qi4j.api.type.MatchTypeSpecification;
import org.qi4j.api.value.ValueComposite;
import org.qi4j.bootstrap.AssemblyException;
import org.qi4j.bootstrap.AssemblySpecifications;
import org.qi4j.bootstrap.AssemblyVisitor;
import org.qi4j.bootstrap.AssociationDeclarations;
import org.qi4j.bootstrap.ConfigurationDeclaration;
import org.qi4j.bootstrap.EntityAssembly;
import org.qi4j.bootstrap.EntityDeclaration;
import org.qi4j.bootstrap.ImportedServiceAssembly;
import org.qi4j.bootstrap.ImportedServiceDeclaration;
import org.qi4j.bootstrap.LayerAssembly;
import org.qi4j.bootstrap.ManyAssociationDeclarations;
import org.qi4j.bootstrap.MetaInfoDeclaration;
import org.qi4j.bootstrap.MixinDeclaration;
import org.qi4j.bootstrap.ModuleAssembly;
import org.qi4j.bootstrap.NamedAssociationDeclarations;
import org.qi4j.bootstrap.ObjectAssembly;
import org.qi4j.bootstrap.ObjectDeclaration;
import org.qi4j.bootstrap.ServiceAssembly;
import org.qi4j.bootstrap.ServiceDeclaration;
import org.qi4j.bootstrap.StateDeclarations;
import org.qi4j.bootstrap.TransientAssembly;
import org.qi4j.bootstrap.TransientDeclaration;
import org.qi4j.bootstrap.ValueAssembly;
import org.qi4j.bootstrap.ValueDeclaration;
import org.qi4j.functional.Iterables;
import org.qi4j.functional.Specification;
import org.qi4j.functional.Specifications;
import org.qi4j.runtime.activation.ActivatorsModel;
import org.qi4j.runtime.bootstrap.AssemblyHelper;
import org.qi4j.runtime.bootstrap.ConfigurationDeclarationImpl;
import org.qi4j.runtime.bootstrap.EntityAssemblyImpl;
import org.qi4j.runtime.bootstrap.EntityDeclarationImpl;
import org.qi4j.runtime.bootstrap.ImportedServiceAssemblyImpl;
import org.qi4j.runtime.bootstrap.ImportedServiceDeclarationImpl;
import org.qi4j.runtime.bootstrap.ObjectAssemblyImpl;
import org.qi4j.runtime.bootstrap.ObjectDeclarationImpl;
import org.qi4j.runtime.bootstrap.ServiceAssemblyImpl;
import org.qi4j.runtime.bootstrap.ServiceDeclarationImpl;
import org.qi4j.runtime.bootstrap.TransientAssemblyImpl;
import org.qi4j.runtime.bootstrap.TransientDeclarationImpl;
import org.qi4j.runtime.bootstrap.ValueAssemblyImpl;
import org.qi4j.runtime.bootstrap.ValueDeclarationImpl;
import org.qi4j.runtime.composite.TransientModel;
import org.qi4j.runtime.composite.TransientsModel;
import org.qi4j.runtime.entity.EntitiesModel;
import org.qi4j.runtime.entity.EntityModel;
import org.qi4j.runtime.object.ObjectModel;
import org.qi4j.runtime.object.ObjectsModel;
import org.qi4j.runtime.service.ImportedServiceModel;
import org.qi4j.runtime.service.ImportedServicesModel;
import org.qi4j.runtime.service.ServiceModel;
import org.qi4j.runtime.service.ServicesModel;
import org.qi4j.runtime.structure.ModuleModel;
import org.qi4j.runtime.value.ValueModel;
import org.qi4j.runtime.value.ValuesModel;

public final class ModuleAssemblyImpl
implements ModuleAssembly {
    private final LayerAssembly layerAssembly;
    private String name;
    private final MetaInfo metaInfo = new MetaInfo();
    private final List<Class<? extends Activator<Module>>> activators = new ArrayList<Class<? extends Activator<Module>>>();
    private final List<ServiceAssemblyImpl> serviceAssemblies = new ArrayList<ServiceAssemblyImpl>();
    private final Map<Class<?>, ImportedServiceAssemblyImpl> importedServiceAssemblies = new LinkedHashMap();
    private final Map<Class<? extends EntityComposite>, EntityAssemblyImpl> entityAssemblies = new LinkedHashMap<Class<? extends EntityComposite>, EntityAssemblyImpl>();
    private final Map<Class<? extends ValueComposite>, ValueAssemblyImpl> valueAssemblies = new LinkedHashMap<Class<? extends ValueComposite>, ValueAssemblyImpl>();
    private final Map<Class<? extends TransientComposite>, TransientAssemblyImpl> transientAssemblies = new LinkedHashMap<Class<? extends TransientComposite>, TransientAssemblyImpl>();
    private final Map<Class<?>, ObjectAssemblyImpl> objectAssemblies = new LinkedHashMap();
    private final MetaInfoDeclaration metaInfoDeclaration = new MetaInfoDeclaration();

    public ModuleAssemblyImpl(LayerAssembly layerAssembly, String name) {
        this.layerAssembly = layerAssembly;
        this.name = name;
    }

    public LayerAssembly layer() {
        return this.layerAssembly;
    }

    public ModuleAssembly module(String layerName, String moduleName) {
        return this.layerAssembly.application().module(layerName, moduleName);
    }

    public ModuleAssembly setName(String name) {
        this.name = name;
        return this;
    }

    public String name() {
        return this.name;
    }

    public ModuleAssembly setMetaInfo(Object info) {
        this.metaInfo.set(info);
        return this;
    }

    @SafeVarargs
    public final ModuleAssembly withActivators(Class<? extends Activator<Module>> ... activators) {
        this.activators.addAll(Arrays.asList(activators));
        return this;
    }

    public ValueDeclaration values(Class<?> ... valueTypes) {
        ArrayList<ValueAssemblyImpl> assemblies = new ArrayList<ValueAssemblyImpl>();
        for (Class<?> valueType : valueTypes) {
            if (this.valueAssemblies.containsKey(valueType)) {
                assemblies.add(this.valueAssemblies.get(valueType));
                continue;
            }
            ValueAssemblyImpl valueAssembly = new ValueAssemblyImpl(valueType);
            this.valueAssemblies.put(valueType, valueAssembly);
            assemblies.add(valueAssembly);
        }
        return new ValueDeclarationImpl(assemblies);
    }

    public ValueDeclaration values(Specification<? super ValueAssembly> specification) {
        ArrayList<ValueAssemblyImpl> assemblies = new ArrayList<ValueAssemblyImpl>();
        for (ValueAssemblyImpl transientAssembly : this.valueAssemblies.values()) {
            if (!specification.satisfiedBy((Object)transientAssembly)) continue;
            assemblies.add(transientAssembly);
        }
        return new ValueDeclarationImpl(assemblies);
    }

    public TransientDeclaration transients(Class<?> ... transientTypes) {
        ArrayList<TransientAssemblyImpl> assemblies = new ArrayList<TransientAssemblyImpl>();
        for (Class<?> valueType : transientTypes) {
            if (this.transientAssemblies.containsKey(valueType)) {
                assemblies.add(this.transientAssemblies.get(valueType));
                continue;
            }
            TransientAssemblyImpl transientAssembly = new TransientAssemblyImpl(valueType);
            this.transientAssemblies.put(valueType, transientAssembly);
            assemblies.add(transientAssembly);
        }
        return new TransientDeclarationImpl(assemblies);
    }

    public TransientDeclaration transients(Specification<? super TransientAssembly> specification) {
        ArrayList<TransientAssemblyImpl> assemblies = new ArrayList<TransientAssemblyImpl>();
        for (TransientAssemblyImpl transientAssembly : this.transientAssemblies.values()) {
            if (!specification.satisfiedBy((Object)transientAssembly)) continue;
            assemblies.add(transientAssembly);
        }
        return new TransientDeclarationImpl(assemblies);
    }

    public EntityDeclaration entities(Class<?> ... entityTypes) {
        ArrayList<EntityAssemblyImpl> assemblies = new ArrayList<EntityAssemblyImpl>();
        for (Class<?> entityType : entityTypes) {
            if (this.entityAssemblies.containsKey(entityType)) {
                assemblies.add(this.entityAssemblies.get(entityType));
                continue;
            }
            EntityAssemblyImpl entityAssembly = new EntityAssemblyImpl(entityType);
            this.entityAssemblies.put(entityType, entityAssembly);
            assemblies.add(entityAssembly);
        }
        return new EntityDeclarationImpl(assemblies);
    }

    public EntityDeclaration entities(Specification<? super EntityAssembly> specification) {
        ArrayList<EntityAssemblyImpl> assemblies = new ArrayList<EntityAssemblyImpl>();
        for (EntityAssemblyImpl entityAssembly : this.entityAssemblies.values()) {
            if (!specification.satisfiedBy((Object)entityAssembly)) continue;
            assemblies.add(entityAssembly);
        }
        return new EntityDeclarationImpl(assemblies);
    }

    public ConfigurationDeclaration configurations(Class<?> ... configurationTypes) {
        ArrayList<EntityAssemblyImpl> entityAssemblyList = new ArrayList<EntityAssemblyImpl>();
        for (Class<?> entityType : configurationTypes) {
            if (this.entityAssemblies.containsKey(entityType)) {
                entityAssemblyList.add(this.entityAssemblies.get(entityType));
                continue;
            }
            EntityAssemblyImpl entityAssembly = new EntityAssemblyImpl(entityType);
            this.entityAssemblies.put(entityType, entityAssembly);
            entityAssemblyList.add(entityAssembly);
        }
        ArrayList<ValueAssemblyImpl> valueAssemblyList = new ArrayList<ValueAssemblyImpl>();
        for (Class<?> valueType : configurationTypes) {
            if (this.valueAssemblies.containsKey(valueType)) {
                valueAssemblyList.add(this.valueAssemblies.get(valueType));
                continue;
            }
            ValueAssemblyImpl valueAssembly = new ValueAssemblyImpl(valueType);
            this.valueAssemblies.put(valueType, valueAssembly);
            valueAssemblyList.add(valueAssembly);
            valueAssembly.types.add(Identity.class);
        }
        return new ConfigurationDeclarationImpl(entityAssemblyList, valueAssemblyList);
    }

    public ConfigurationDeclaration configurations(Specification<HasTypes> specification) {
        MatchTypeSpecification isConfigurationComposite = new MatchTypeSpecification(Identity.class);
        specification = Specifications.and((Specification[])new Specification[]{specification, isConfigurationComposite});
        ArrayList<EntityAssemblyImpl> entityAssmblyList = new ArrayList<EntityAssemblyImpl>();
        for (EntityAssemblyImpl entityAssembly : this.entityAssemblies.values()) {
            if (!specification.satisfiedBy((Object)entityAssembly)) continue;
            entityAssmblyList.add(entityAssembly);
        }
        ArrayList<ValueAssemblyImpl> valueAssemblyList = new ArrayList<ValueAssemblyImpl>();
        for (ValueAssemblyImpl transientAssembly : this.valueAssemblies.values()) {
            if (!specification.satisfiedBy((Object)transientAssembly)) continue;
            valueAssemblyList.add(transientAssembly);
        }
        return new ConfigurationDeclarationImpl(entityAssmblyList, valueAssemblyList);
    }

    public ObjectDeclaration objects(Class<?> ... objectTypes) throws AssemblyException {
        ArrayList<ObjectAssemblyImpl> assemblies = new ArrayList<ObjectAssemblyImpl>();
        for (Class<?> objectType : objectTypes) {
            if (objectType.isInterface()) {
                throw new AssemblyException("Interfaces can not be Zest Objects.");
            }
            if (this.objectAssemblies.containsKey(objectType)) {
                assemblies.add(this.objectAssemblies.get(objectType));
                continue;
            }
            ObjectAssemblyImpl objectAssembly = new ObjectAssemblyImpl(objectType);
            this.objectAssemblies.put(objectType, objectAssembly);
            assemblies.add(objectAssembly);
        }
        return new ObjectDeclarationImpl(assemblies);
    }

    public ObjectDeclaration objects(Specification<? super ObjectAssembly> specification) {
        ArrayList<ObjectAssemblyImpl> assemblies = new ArrayList<ObjectAssemblyImpl>();
        for (ObjectAssemblyImpl objectAssembly : this.objectAssemblies.values()) {
            if (!specification.satisfiedBy((Object)objectAssembly)) continue;
            assemblies.add(objectAssembly);
        }
        return new ObjectDeclarationImpl(assemblies);
    }

    public ServiceDeclaration addServices(Class<?> ... serviceTypes) {
        ArrayList<ServiceAssemblyImpl> assemblies = new ArrayList<ServiceAssemblyImpl>();
        for (Class<?> serviceType : serviceTypes) {
            ServiceAssemblyImpl serviceAssembly = new ServiceAssemblyImpl(serviceType);
            this.serviceAssemblies.add(serviceAssembly);
            assemblies.add(serviceAssembly);
        }
        return new ServiceDeclarationImpl(assemblies);
    }

    public ServiceDeclaration services(Class<?> ... serviceTypes) {
        ArrayList<ServiceAssemblyImpl> assemblies = new ArrayList<ServiceAssemblyImpl>();
        for (Class<?> serviceType : serviceTypes) {
            if (Iterables.matchesAny((Specification)AssemblySpecifications.types((Class[])new Class[]{serviceType}), this.serviceAssemblies)) {
                Iterables.addAll(assemblies, (Iterable)Iterables.filter((Specification)AssemblySpecifications.types((Class[])new Class[]{serviceType}), this.serviceAssemblies));
                continue;
            }
            ServiceAssemblyImpl serviceAssembly = new ServiceAssemblyImpl(serviceType);
            this.serviceAssemblies.add(serviceAssembly);
            assemblies.add(serviceAssembly);
        }
        return new ServiceDeclarationImpl(assemblies);
    }

    public ServiceDeclaration services(Specification<? super ServiceAssembly> specification) {
        ArrayList<ServiceAssemblyImpl> assemblies = new ArrayList<ServiceAssemblyImpl>();
        for (ServiceAssemblyImpl serviceAssembly : this.serviceAssemblies) {
            if (!specification.satisfiedBy((Object)serviceAssembly)) continue;
            assemblies.add(serviceAssembly);
        }
        return new ServiceDeclarationImpl(assemblies);
    }

    public ImportedServiceDeclaration importedServices(Class<?> ... serviceTypes) {
        ArrayList<ImportedServiceAssemblyImpl> assemblies = new ArrayList<ImportedServiceAssemblyImpl>();
        for (Class<?> serviceType : serviceTypes) {
            if (this.importedServiceAssemblies.containsKey(serviceType)) {
                assemblies.add(this.importedServiceAssemblies.get(serviceType));
                continue;
            }
            ImportedServiceAssemblyImpl serviceAssembly = new ImportedServiceAssemblyImpl(serviceType, this);
            this.importedServiceAssemblies.put(serviceType, serviceAssembly);
            assemblies.add(serviceAssembly);
        }
        return new ImportedServiceDeclarationImpl(assemblies);
    }

    public ImportedServiceDeclaration importedServices(Specification<? super ImportedServiceAssembly> specification) {
        ArrayList<ImportedServiceAssemblyImpl> assemblies = new ArrayList<ImportedServiceAssemblyImpl>();
        for (ImportedServiceAssemblyImpl objectAssembly : this.importedServiceAssemblies.values()) {
            if (!specification.satisfiedBy((Object)objectAssembly)) continue;
            assemblies.add(objectAssembly);
        }
        return new ImportedServiceDeclarationImpl(assemblies);
    }

    public <T> MixinDeclaration<T> forMixin(Class<T> mixinType) {
        return this.metaInfoDeclaration.on(mixinType);
    }

    public <ThrowableType extends Throwable> void visit(AssemblyVisitor<ThrowableType> visitor) throws ThrowableType {
        visitor.visitModule((ModuleAssembly)this);
        for (TransientAssemblyImpl compositeDeclaration : this.transientAssemblies.values()) {
            visitor.visitComposite((TransientDeclaration)new TransientDeclarationImpl(Iterables.iterable((Object[])new TransientAssemblyImpl[]{compositeDeclaration})));
        }
        for (EntityAssemblyImpl entityDeclaration : this.entityAssemblies.values()) {
            visitor.visitEntity((EntityDeclaration)new EntityDeclarationImpl(Iterables.iterable((Object[])new EntityAssemblyImpl[]{entityDeclaration})));
        }
        for (ObjectAssemblyImpl objectDeclaration : this.objectAssemblies.values()) {
            visitor.visitObject((ObjectDeclaration)new ObjectDeclarationImpl(Iterables.iterable((Object[])new ObjectAssemblyImpl[]{objectDeclaration})));
        }
        for (ServiceAssemblyImpl serviceDeclaration : this.serviceAssemblies) {
            visitor.visitService((ServiceDeclaration)new ServiceDeclarationImpl(Iterables.iterable((Object[])new ServiceAssemblyImpl[]{serviceDeclaration})));
        }
        for (ImportedServiceAssemblyImpl importedServiceDeclaration : this.importedServiceAssemblies.values()) {
            visitor.visitImportedService((ImportedServiceDeclaration)new ImportedServiceDeclarationImpl(Iterables.iterable((Object[])new ImportedServiceAssemblyImpl[]{importedServiceDeclaration})));
        }
        for (ValueAssemblyImpl valueDeclaration : this.valueAssemblies.values()) {
            visitor.visitValue((ValueDeclaration)new ValueDeclarationImpl(Iterables.iterable((Object[])new ValueAssemblyImpl[]{valueDeclaration})));
        }
    }

    ModuleModel assembleModule(AssemblyHelper helper) throws AssemblyException {
        String identity;
        ArrayList<TransientModel> transientModels = new ArrayList<TransientModel>();
        ArrayList<ObjectModel> objectModels = new ArrayList<ObjectModel>();
        ArrayList<ValueModel> valueModels = new ArrayList<ValueModel>();
        ArrayList<ServiceModel> serviceModels = new ArrayList<ServiceModel>();
        ArrayList<ImportedServiceModel> importedServiceModels = new ArrayList<ImportedServiceModel>();
        if (this.name == null) {
            throw new AssemblyException("Module must have name set");
        }
        for (TransientAssemblyImpl compositeDeclaration : this.transientAssemblies.values()) {
            transientModels.add(compositeDeclaration.newTransientModel((StateDeclarations)this.metaInfoDeclaration, helper));
        }
        for (ValueAssemblyImpl valueDeclaration : this.valueAssemblies.values()) {
            valueModels.add(valueDeclaration.newValueModel((StateDeclarations)this.metaInfoDeclaration, helper));
        }
        ArrayList<EntityModel> entityModels = new ArrayList<EntityModel>();
        for (EntityAssemblyImpl entityDeclaration : this.entityAssemblies.values()) {
            entityModels.add(entityDeclaration.newEntityModel((StateDeclarations)this.metaInfoDeclaration, (AssociationDeclarations)this.metaInfoDeclaration, (ManyAssociationDeclarations)this.metaInfoDeclaration, (NamedAssociationDeclarations)this.metaInfoDeclaration, helper));
        }
        for (ObjectAssemblyImpl objectDeclaration : this.objectAssemblies.values()) {
            objectDeclaration.addObjectModel(objectModels);
        }
        for (ServiceAssemblyImpl serviceDeclaration : this.serviceAssemblies) {
            if (serviceDeclaration.identity == null) {
                serviceDeclaration.identity = this.generateId(serviceDeclaration.types());
            }
            serviceModels.add(serviceDeclaration.newServiceModel((StateDeclarations)this.metaInfoDeclaration, helper));
        }
        for (ImportedServiceAssemblyImpl importedServiceDeclaration : this.importedServiceAssemblies.values()) {
            importedServiceDeclaration.addImportedServiceModel(importedServiceModels);
        }
        ModuleModel moduleModel = new ModuleModel(this.name, this.metaInfo, new ActivatorsModel<Module>(this.activators), new TransientsModel(transientModels), new EntitiesModel(entityModels), new ObjectsModel(objectModels), new ValuesModel(valueModels), new ServicesModel(serviceModels), new ImportedServicesModel(importedServiceModels));
        HashSet<String> identities = new HashSet<String>();
        for (ServiceModel serviceModel : serviceModels) {
            identity = serviceModel.identity();
            if (identities.contains(identity)) {
                throw new DuplicateServiceIdentityException("Duplicated service identity: " + identity + " in module " + moduleModel.name());
            }
            identities.add(identity);
        }
        for (ImportedServiceModel importedServiceModel : importedServiceModels) {
            identity = importedServiceModel.identity();
            if (identities.contains(identity)) {
                throw new DuplicateServiceIdentityException("Duplicated service identity: " + identity + " in module " + moduleModel.name());
            }
            identities.add(identity);
        }
        for (ImportedServiceModel importedServiceModel : importedServiceModels) {
            boolean found = false;
            for (ObjectModel objectModel2 : objectModels) {
                if (!((Class)Iterables.first(objectModel2.types())).equals(importedServiceModel.serviceImporter())) continue;
                found = true;
                break;
            }
            if (found) continue;
            Class<? extends ServiceImporter> serviceFactoryType = importedServiceModel.serviceImporter();
            ObjectModel objectModel = new ObjectModel(serviceFactoryType, Visibility.module, new MetaInfo());
            objectModels.add(objectModel);
        }
        return moduleModel;
    }

    private String generateId(Iterable<Class<?>> serviceTypes) {
        boolean invalid;
        Class<?> serviceType = serviceTypes.iterator().next();
        int idx = 0;
        String id = serviceType.getSimpleName();
        block0: do {
            invalid = false;
            for (ServiceAssemblyImpl serviceAssembly : this.serviceAssemblies) {
                if (serviceAssembly.identity() == null || !serviceAssembly.identity().equals(id)) continue;
                id = serviceType.getSimpleName() + "_" + ++idx;
                invalid = true;
                continue block0;
            }
        } while (invalid);
        return id;
    }
}

