/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.runtime.bootstrap;

import java.util.ArrayList;
import java.util.Arrays;
import org.qi4j.api.activation.Activator;
import org.qi4j.api.common.Visibility;
import org.qi4j.api.service.qualifier.ServiceTags;
import org.qi4j.bootstrap.ServiceDeclaration;
import org.qi4j.runtime.bootstrap.ServiceAssemblyImpl;

public final class ServiceDeclarationImpl
implements ServiceDeclaration {
    private final Iterable<ServiceAssemblyImpl> serviceAssemblies;

    public ServiceDeclarationImpl(Iterable<ServiceAssemblyImpl> serviceAssemblies) {
        this.serviceAssemblies = serviceAssemblies;
    }

    public ServiceDeclaration visibleIn(Visibility visibility) {
        for (ServiceAssemblyImpl serviceAssembly : this.serviceAssemblies) {
            serviceAssembly.visibility = visibility;
        }
        return this;
    }

    public ServiceDeclaration identifiedBy(String identity) {
        for (ServiceAssemblyImpl serviceAssembly : this.serviceAssemblies) {
            serviceAssembly.identity = identity;
        }
        return this;
    }

    public ServiceDeclaration taggedWith(String ... tags) {
        for (ServiceAssemblyImpl serviceAssembly : this.serviceAssemblies) {
            ServiceTags previousTags = (ServiceTags)serviceAssembly.metaInfo.get(ServiceTags.class);
            if (previousTags != null) {
                ArrayList<String> tagList = new ArrayList<String>();
                tagList.addAll(Arrays.asList(previousTags.tags()));
                tagList.addAll(Arrays.asList(tags));
                serviceAssembly.metaInfo.set((Object)new ServiceTags(tagList.toArray(new String[tagList.size()])));
                continue;
            }
            serviceAssembly.metaInfo.set((Object)new ServiceTags(tags));
        }
        return this;
    }

    public ServiceDeclaration instantiateOnStartup() {
        for (ServiceAssemblyImpl serviceAssembly : this.serviceAssemblies) {
            serviceAssembly.instantiateOnStartup = true;
        }
        return this;
    }

    public ServiceDeclaration setMetaInfo(Object serviceAttribute) {
        for (ServiceAssemblyImpl serviceAssembly : this.serviceAssemblies) {
            serviceAssembly.metaInfo.set(serviceAttribute);
        }
        return this;
    }

    public ServiceDeclaration withConcerns(Class<?> ... concerns) {
        for (ServiceAssemblyImpl serviceAssembly : this.serviceAssemblies) {
            serviceAssembly.concerns.addAll(Arrays.asList(concerns));
        }
        return this;
    }

    public ServiceDeclaration withSideEffects(Class<?> ... sideEffects) {
        for (ServiceAssemblyImpl serviceAssembly : this.serviceAssemblies) {
            serviceAssembly.sideEffects.addAll(Arrays.asList(sideEffects));
        }
        return this;
    }

    public ServiceDeclaration withMixins(Class<?> ... mixins) {
        for (ServiceAssemblyImpl serviceAssembly : this.serviceAssemblies) {
            serviceAssembly.mixins.addAll(Arrays.asList(mixins));
        }
        return this;
    }

    public ServiceDeclaration withTypes(Class<?> ... types) {
        for (ServiceAssemblyImpl serviceAssembly : this.serviceAssemblies) {
            serviceAssembly.types.addAll(Arrays.asList(types));
        }
        return this;
    }

    @SafeVarargs
    public final ServiceDeclaration withActivators(Class<? extends Activator<?>> ... activators) {
        for (ServiceAssemblyImpl serviceAssembly : this.serviceAssemblies) {
            serviceAssembly.activators.addAll(Arrays.asList(activators));
        }
        return this;
    }
}

