/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.runtime.composite;

import java.lang.annotation.Annotation;
import org.qi4j.api.common.ConstructionException;
import org.qi4j.api.constraint.Constraint;
import org.qi4j.runtime.composite.AbstractConstraintModel;
import org.qi4j.runtime.composite.ConstraintInstance;
import org.qi4j.runtime.composite.ValueConstraintsInstance;
import org.qi4j.runtime.composite.ValueConstraintsModel;

public final class CompositeConstraintModel
extends AbstractConstraintModel {
    private final ValueConstraintsModel constraintsModel;

    public CompositeConstraintModel(Annotation annotation, ValueConstraintsModel constraintsModel) {
        super(annotation);
        this.constraintsModel = constraintsModel;
    }

    @Override
    public ConstraintInstance<?, ?> newInstance() {
        try {
            ValueConstraintsInstance compositeConstraintsInstance = this.constraintsModel.newInstance();
            CompositeConstraintInstance constraint = new CompositeConstraintInstance(compositeConstraintsInstance);
            return new ConstraintInstance<Annotation, Object>(constraint, this.annotation);
        }
        catch (Exception e) {
            throw new ConstructionException("Could not instantiate constraint implementation", (Throwable)e);
        }
    }

    private static class CompositeConstraintInstance
    implements Constraint<Annotation, Object> {
        private final ValueConstraintsInstance valueConstraintsInstance;

        private CompositeConstraintInstance(ValueConstraintsInstance valueConstraintsInstance) {
            this.valueConstraintsInstance = valueConstraintsInstance;
        }

        public boolean isValid(Annotation annotation, Object value) throws NullPointerException {
            return this.valueConstraintsInstance.checkConstraints(value).isEmpty();
        }
    }
}

