/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.runtime.composite;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import org.qi4j.api.common.ConstructionException;
import org.qi4j.api.composite.MethodDescriptor;
import org.qi4j.api.util.NullArgumentException;
import org.qi4j.functional.HierarchicalVisitor;
import org.qi4j.functional.Iterables;
import org.qi4j.functional.Specification;
import org.qi4j.functional.Specifications;
import org.qi4j.functional.VisitableHierarchy;
import org.qi4j.runtime.composite.AtomicInstancePool;
import org.qi4j.runtime.composite.CompositeMethodInstance;
import org.qi4j.runtime.composite.ConcernsInstance;
import org.qi4j.runtime.composite.ConcernsModel;
import org.qi4j.runtime.composite.ConstraintsInstance;
import org.qi4j.runtime.composite.ConstraintsModel;
import org.qi4j.runtime.composite.FragmentInvocationHandler;
import org.qi4j.runtime.composite.GenericSpecification;
import org.qi4j.runtime.composite.MixinModel;
import org.qi4j.runtime.composite.MixinsInstance;
import org.qi4j.runtime.composite.MixinsModel;
import org.qi4j.runtime.composite.SideEffectsInstance;
import org.qi4j.runtime.composite.SideEffectsModel;
import org.qi4j.runtime.injection.Dependencies;
import org.qi4j.runtime.injection.DependencyModel;
import org.qi4j.spi.module.ModuleSpi;

public final class CompositeMethodModel
implements MethodDescriptor,
Dependencies,
VisitableHierarchy<Object, Object> {
    private final Method method;
    private Method invocationMethod;
    private final ConstraintsModel constraints;
    private final ConcernsModel concerns;
    private final SideEffectsModel sideEffects;
    private final MixinsModel mixins;
    private AnnotatedElement annotations;
    private final AtomicInstancePool instancePool = new AtomicInstancePool();
    private final ConstraintsInstance constraintsInstance;

    public CompositeMethodModel(Method method, ConstraintsModel constraintsModel, ConcernsModel concernsModel, SideEffectsModel sideEffectsModel, MixinsModel mixinsModel) {
        this.method = method;
        this.mixins = mixinsModel;
        this.concerns = concernsModel;
        this.sideEffects = sideEffectsModel;
        this.constraints = constraintsModel;
        this.constraintsInstance = this.constraints.newInstance();
        this.initialize();
    }

    private void initialize() {
        this.annotations = new CompositeMethodAnnotatedElement();
        this.method.setAccessible(true);
    }

    public Method method() {
        return this.method;
    }

    public MixinModel mixin() {
        return this.mixins.mixinFor(this.method);
    }

    @Override
    public Iterable<DependencyModel> dependencies() {
        return Iterables.flattenIterables((Iterable)Iterables.filter((Specification)Specifications.notNull(), (Iterable)Iterables.iterable((Object[])new Iterable[]{this.concerns != null ? this.concerns.dependencies() : null, this.sideEffects != null ? this.sideEffects.dependencies() : null})));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object composite, Object[] params, MixinsInstance mixins, ModuleSpi moduleInstance) throws Throwable {
        this.constraintsInstance.checkValid(composite, this.method, params);
        CompositeMethodInstance methodInstance = this.getInstance(moduleInstance);
        try {
            Object object = mixins.invoke(composite, params, methodInstance);
            return object;
        }
        finally {
            this.instancePool.releaseInstance(methodInstance);
        }
    }

    private CompositeMethodInstance getInstance(ModuleSpi moduleInstance) {
        CompositeMethodInstance methodInstance = this.instancePool.obtainInstance();
        if (methodInstance == null) {
            methodInstance = this.newCompositeMethodInstance(moduleInstance);
        }
        return methodInstance;
    }

    private CompositeMethodInstance newCompositeMethodInstance(ModuleSpi moduleInstance) throws ConstructionException {
        FragmentInvocationHandler mixinInvocationHandler;
        InvocationHandler invoker = mixinInvocationHandler = this.mixins.newInvocationHandler(this.method);
        if (this.concerns != ConcernsModel.EMPTY_CONCERNS) {
            ConcernsInstance concernsInstance = this.concerns.newInstance(this.method, moduleInstance, mixinInvocationHandler);
            invoker = concernsInstance;
        }
        if (this.sideEffects != SideEffectsModel.EMPTY_SIDEEFFECTS) {
            SideEffectsInstance sideEffectsInstance = this.sideEffects.newInstance(this.method, moduleInstance, invoker);
            invoker = sideEffectsInstance;
        }
        if (this.invocationMethod == null) {
            MixinModel model = this.mixins.mixinFor(this.method);
            if (!InvocationHandler.class.isAssignableFrom(model.mixinClass())) {
                try {
                    this.invocationMethod = model.instantiationClass().getMethod("_" + this.method.getName(), this.method.getParameterTypes());
                }
                catch (NoSuchMethodException e) {
                    this.invocationMethod = this.method;
                }
            } else {
                this.invocationMethod = this.method;
            }
        }
        mixinInvocationHandler.setMethod(this.invocationMethod);
        return new CompositeMethodInstance(invoker, mixinInvocationHandler, this.method, this.mixins.methodIndex.get(this.method));
    }

    public AnnotatedElement annotatedElement() {
        return this.annotations;
    }

    public <ThrowableType extends Throwable> boolean accept(HierarchicalVisitor<? super Object, ? super Object, ThrowableType> modelVisitor) throws ThrowableType {
        if (modelVisitor.visitEnter((Object)this)) {
            this.constraints.accept(modelVisitor);
            this.concerns.accept(modelVisitor);
            this.sideEffects.accept(modelVisitor);
        }
        return modelVisitor.visitLeave((Object)this);
    }

    public String toString() {
        return this.method.toGenericString();
    }

    public Iterable<Method> invocationsFor(Class<?> mixinClass) {
        return this.mixins.invocationsFor(mixinClass);
    }

    public class CompositeMethodAnnotatedElement
    implements AnnotatedElement {
        @Override
        public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
            if (CompositeMethodModel.this.method.isAnnotationPresent(annotationClass)) {
                return true;
            }
            try {
                MixinModel model = CompositeMethodModel.this.mixins.mixinFor(CompositeMethodModel.this.method);
                if (GenericSpecification.INSTANCE.satisfiedBy(model.mixinClass())) {
                    return false;
                }
                return model.mixinClass().getMethod(CompositeMethodModel.this.method.getName(), CompositeMethodModel.this.method.getParameterTypes()).isAnnotationPresent(annotationClass);
            }
            catch (NoSuchMethodException e) {
                return false;
            }
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
            try {
                Annotation annotation;
                MixinModel model = CompositeMethodModel.this.mixins.mixinFor(CompositeMethodModel.this.method);
                if (!GenericSpecification.INSTANCE.satisfiedBy(model.mixinClass()) && (annotation = (Annotation)annotationClass.cast(model.mixinClass().getMethod(CompositeMethodModel.this.method.getName(), CompositeMethodModel.this.method.getParameterTypes()).getAnnotation(annotationClass))) != null) {
                    return (T)annotation;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            return CompositeMethodModel.this.method.getAnnotation(annotationClass);
        }

        @Override
        public Annotation[] getAnnotations() {
            Annotation[] methodAnnotations;
            ArrayList<Annotation> annotations = new ArrayList<Annotation>();
            MixinModel model = CompositeMethodModel.this.mixins.mixinFor(CompositeMethodModel.this.method);
            Annotation[] mixinAnnotations = new Annotation[]{};
            if (!GenericSpecification.INSTANCE.satisfiedBy(model.mixinClass())) {
                mixinAnnotations = model.mixinClass().getAnnotations();
                annotations.addAll(Arrays.asList(mixinAnnotations));
            }
            block0: for (Annotation methodAnnotation : methodAnnotations = CompositeMethodModel.this.method.getAnnotations()) {
                for (int i = 0; i < mixinAnnotations.length; ++i) {
                    if (((Annotation)annotations.get(i)).annotationType().equals(methodAnnotation.annotationType())) continue block0;
                }
                annotations.add(methodAnnotation);
            }
            return annotations.toArray(new Annotation[annotations.size()]);
        }

        @Override
        public Annotation[] getDeclaredAnnotations() {
            return new Annotation[0];
        }

        @Override
        public <T extends Annotation> T[] getAnnotationsByType(Class<T> annotationClass) {
            NullArgumentException.validateNotNull((String)"annotationClass", annotationClass);
            return (Annotation[])Array.newInstance(annotationClass, 0);
        }

        @Override
        public <T extends Annotation> T getDeclaredAnnotation(Class<T> annotationClass) {
            NullArgumentException.validateNotNull((String)"annotationClass", annotationClass);
            return null;
        }

        @Override
        public <T extends Annotation> T[] getDeclaredAnnotationsByType(Class<T> annotationClass) {
            NullArgumentException.validateNotNull((String)"annotationClass", annotationClass);
            return (Annotation[])Array.newInstance(annotationClass, 0);
        }
    }
}

