/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.runtime.composite;

import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import org.qi4j.api.composite.MissingMethodException;
import org.qi4j.functional.HierarchicalVisitor;
import org.qi4j.functional.Iterables;
import org.qi4j.functional.VisitableHierarchy;
import org.qi4j.runtime.composite.CompositeMethodModel;
import org.qi4j.runtime.composite.MixinsInstance;
import org.qi4j.runtime.composite.MixinsModel;
import org.qi4j.runtime.injection.Dependencies;
import org.qi4j.runtime.injection.DependencyModel;
import org.qi4j.spi.module.ModuleSpi;

public final class CompositeMethodsModel
implements VisitableHierarchy<Object, Object> {
    private final LinkedHashMap<Method, CompositeMethodModel> methods = new LinkedHashMap();
    private final MixinsModel mixinsModel;

    public CompositeMethodsModel(MixinsModel mixinsModel) {
        this.mixinsModel = mixinsModel;
    }

    public Iterable<DependencyModel> dependencies() {
        return Iterables.flattenIterables((Iterable)Iterables.map(Dependencies.DEPENDENCIES_FUNCTION, this.methods.values()));
    }

    public Object invoke(MixinsInstance mixins, Object proxy, Method method, Object[] args, ModuleSpi moduleInstance) throws Throwable {
        CompositeMethodModel compositeMethod = this.methods.get(method);
        if (compositeMethod == null) {
            if (method.getDeclaringClass().equals(Object.class)) {
                return mixins.invokeObject(proxy, args, method);
            }
            if (!method.getDeclaringClass().isInterface()) {
                Iterable<Class<?>> types = this.mixinsModel.mixinTypes();
                for (Class<?> aClass : types) {
                    try {
                        Method realMethod = aClass.getMethod(method.getName(), method.getParameterTypes());
                        compositeMethod = this.methods.get(realMethod);
                        break;
                    }
                    catch (NoSuchMethodException e) {
                    }
                    catch (SecurityException e) {
                    }
                }
            }
            throw new MissingMethodException("Method '" + method + "' is not implemented");
        }
        return compositeMethod.invoke(proxy, args, mixins, moduleInstance);
    }

    public void addMethod(CompositeMethodModel methodModel) {
        this.methods.put(methodModel.method(), methodModel);
    }

    public boolean isImplemented(Method method) {
        return this.methods.containsKey(method);
    }

    public Iterable<Method> methods() {
        return this.methods.keySet();
    }

    public <ThrowableType extends Throwable> boolean accept(HierarchicalVisitor<? super Object, ? super Object, ThrowableType> modelVisitor) throws ThrowableType {
        block1: {
            if (!modelVisitor.visitEnter((Object)this)) break block1;
            for (CompositeMethodModel compositeMethodModel : this.methods.values()) {
                if (!compositeMethodModel.accept(modelVisitor)) break;
            }
        }
        return modelVisitor.visitLeave((Object)this);
    }

    public String toString() {
        return this.methods().toString();
    }
}

