/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.runtime.composite;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.qi4j.api.common.ConstructionException;
import org.qi4j.api.composite.CompositeDescriptor;
import org.qi4j.api.composite.InvalidCompositeException;
import org.qi4j.api.injection.InjectionScope;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.util.Annotations;
import org.qi4j.api.util.Classes;
import org.qi4j.bootstrap.BindingException;
import org.qi4j.functional.Function;
import org.qi4j.functional.HierarchicalVisitor;
import org.qi4j.functional.HierarchicalVisitorAdapter;
import org.qi4j.functional.Iterables;
import org.qi4j.functional.Specification;
import org.qi4j.functional.Specifications;
import org.qi4j.functional.VisitableHierarchy;
import org.qi4j.runtime.composite.ConstructorModel;
import org.qi4j.runtime.composite.FragmentClassLoader;
import org.qi4j.runtime.injection.Dependencies;
import org.qi4j.runtime.injection.DependencyModel;
import org.qi4j.runtime.injection.InjectedParametersModel;
import org.qi4j.runtime.injection.InjectionContext;
import org.qi4j.runtime.injection.ParameterizedTypeInstance;
import org.qi4j.runtime.model.Binder;
import org.qi4j.runtime.model.Resolution;

public final class ConstructorsModel
implements Binder,
Dependencies,
VisitableHierarchy<Object, Object> {
    private final Class fragmentClass;
    private final List<ConstructorModel> constructorModels;
    private List<ConstructorModel> boundConstructors;

    public ConstructorsModel(Class fragmentClass) {
        this.fragmentClass = fragmentClass;
        this.validate(fragmentClass);
        this.constructorModels = new ArrayList<ConstructorModel>();
        Constructor<?>[] realConstructors = this.fragmentClass.getDeclaredConstructors();
        Class injectionClass = FragmentClassLoader.getSourceClass(fragmentClass);
        for (Constructor<?> constructor : realConstructors) {
            constructor.setAccessible(true);
            try {
                Constructor injectionConstructor = injectionClass.getDeclaredConstructor(constructor.getParameterTypes());
                injectionConstructor.setAccessible(true);
                ConstructorModel constructorModel = this.newConstructorModel(this.fragmentClass, constructor, injectionConstructor);
                if (constructorModel == null) continue;
                this.constructorModels.add(constructorModel);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
    }

    private void validate(Class fragmentClass) {
        if (fragmentClass.getDeclaringClass() == null) {
            return;
        }
        if (Modifier.isStatic(fragmentClass.getModifiers())) {
            return;
        }
        throw new InvalidCompositeException("Inner classes can not be used. Use static nested classes instead: " + fragmentClass);
    }

    @Override
    public Iterable<DependencyModel> dependencies() {
        Function<ConstructorModel, Iterable<DependencyModel>> constructorDependencies = new Function<ConstructorModel, Iterable<DependencyModel>>(){

            public Iterable<DependencyModel> map(ConstructorModel constructorModel) {
                return constructorModel.dependencies();
            }
        };
        return Iterables.flattenIterables((Iterable)Iterables.map((Function)constructorDependencies, this.boundConstructors == null ? this.constructorModels : this.boundConstructors));
    }

    private ConstructorModel newConstructorModel(Class fragmentClass, Constructor realConstructor, Constructor injectedConstructor) {
        int idx = 0;
        InjectedParametersModel parameters = new InjectedParametersModel();
        Annotation[][] parameterAnnotations = injectedConstructor.getParameterAnnotations();
        for (Type type : injectedConstructor.getGenericParameterTypes()) {
            Object injectionAnnotation = (Annotation)Iterables.first((Iterable)Iterables.filter((Specification)Specifications.translate((Function)Annotations.type(), (Specification)Annotations.hasAnnotation(InjectionScope.class)), (Iterable)Iterables.iterable((Object[])parameterAnnotations[idx])));
            if (injectionAnnotation == null) {
                if (fragmentClass.getSuperclass().isMemberClass()) {
                    injectionAnnotation = new Uses(){

                        public Class<? extends Annotation> annotationType() {
                            return Uses.class;
                        }
                    };
                } else {
                    return null;
                }
            }
            boolean optional = DependencyModel.isOptional((Annotation)injectionAnnotation, parameterAnnotations[idx]);
            Type genericType = type;
            if (genericType instanceof ParameterizedType) {
                genericType = new ParameterizedTypeInstance(((ParameterizedType)genericType).getActualTypeArguments(), ((ParameterizedType)genericType).getRawType(), ((ParameterizedType)genericType).getOwnerType());
                for (int i = 0; i < ((ParameterizedType)genericType).getActualTypeArguments().length; ++i) {
                    Type typeArg = ((ParameterizedType)genericType).getActualTypeArguments()[i];
                    if (!(typeArg instanceof TypeVariable)) continue;
                    ((ParameterizedType)genericType).getActualTypeArguments()[i] = typeArg = Classes.resolveTypeVariable((TypeVariable)((TypeVariable)typeArg), realConstructor.getDeclaringClass(), (Class)fragmentClass);
                }
            }
            DependencyModel dependencyModel = new DependencyModel((Annotation)injectionAnnotation, genericType, fragmentClass, optional, parameterAnnotations[idx]);
            parameters.addDependency(dependencyModel);
            ++idx;
        }
        return new ConstructorModel(realConstructor, parameters);
    }

    public <ThrowableType extends Throwable> boolean accept(HierarchicalVisitor<? super Object, ? super Object, ThrowableType> visitor) throws ThrowableType {
        block4: {
            if (!visitor.visitEnter((Object)this)) break block4;
            if (this.boundConstructors != null) {
                for (ConstructorModel constructorModel : this.boundConstructors) {
                    if (!constructorModel.accept(visitor)) break;
                }
            } else {
                for (ConstructorModel constructorModel : this.constructorModels) {
                    if (!constructorModel.accept(visitor)) break;
                }
            }
        }
        return visitor.visitLeave((Object)this);
    }

    @Override
    public void bind(final Resolution resolution) throws BindingException {
        this.boundConstructors = new ArrayList<ConstructorModel>();
        for (ConstructorModel constructorModel : this.constructorModels) {
            try {
                constructorModel.accept(new HierarchicalVisitorAdapter<Object, Object, BindingException>(){

                    public boolean visit(Object visitor) throws BindingException {
                        if (visitor instanceof Binder) {
                            ((Binder)visitor).bind(resolution);
                        }
                        return true;
                    }
                });
                this.boundConstructors.add(constructorModel);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.boundConstructors.isEmpty()) {
            StringBuilder messageBuilder = new StringBuilder("Found no constructor that could be bound: ");
            if (resolution.model() instanceof CompositeDescriptor) {
                messageBuilder.append(this.fragmentClass.getName()).append(" in ").append(resolution.model().toString());
            } else {
                messageBuilder.append(resolution.model().toString());
            }
            if (messageBuilder.indexOf("$") >= 0) {
                return;
            }
            String message = messageBuilder.toString();
            throw new BindingException(message);
        }
        Collections.sort(this.boundConstructors, new Comparator<ConstructorModel>(){

            @Override
            public int compare(ConstructorModel o1, ConstructorModel o2) {
                Integer model2ParametersCount = o2.constructor().getParameterTypes().length;
                int model1ParametersCount = o1.constructor().getParameterTypes().length;
                return model2ParametersCount.compareTo(model1ParametersCount);
            }
        });
    }

    public Object newInstance(InjectionContext injectionContext) {
        ConstructionException exception = null;
        for (ConstructorModel constructorModel : this.boundConstructors) {
            try {
                return constructorModel.newInstance(injectionContext);
            }
            catch (ConstructionException e) {
                exception = e;
            }
        }
        throw exception;
    }
}

