/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.runtime.composite;

import java.util.List;
import java.util.Map;
import org.qi4j.api.association.AssociationDescriptor;
import org.qi4j.api.entity.EntityReference;
import org.qi4j.api.property.PropertyDescriptor;
import org.qi4j.functional.Function;
import org.qi4j.functional.Iterables;
import org.qi4j.runtime.association.ManyAssociationModel;
import org.qi4j.runtime.association.NamedAssociationModel;
import org.qi4j.runtime.composite.StateResolver;
import org.qi4j.runtime.entity.EntityModel;
import org.qi4j.spi.entity.EntityState;
import org.qi4j.spi.entity.ManyAssociationState;

public class FunctionStateResolver
implements StateResolver {
    final Function<PropertyDescriptor, Object> propertyFunction;
    final Function<AssociationDescriptor, EntityReference> associationFunction;
    final Function<AssociationDescriptor, Iterable<EntityReference>> manyAssociationFunction;
    final Function<AssociationDescriptor, Map<String, EntityReference>> namedAssociationFunction;

    public FunctionStateResolver(Function<PropertyDescriptor, Object> propertyFunction, Function<AssociationDescriptor, EntityReference> associationFunction, Function<AssociationDescriptor, Iterable<EntityReference>> manyAssociationFunction, Function<AssociationDescriptor, Map<String, EntityReference>> namedAssociationFunction) {
        this.propertyFunction = propertyFunction;
        this.associationFunction = associationFunction;
        this.manyAssociationFunction = manyAssociationFunction;
        this.namedAssociationFunction = namedAssociationFunction;
    }

    @Override
    public Object getPropertyState(PropertyDescriptor propertyDescriptor) {
        return this.propertyFunction.map((Object)propertyDescriptor);
    }

    @Override
    public EntityReference getAssociationState(AssociationDescriptor associationDescriptor) {
        return (EntityReference)this.associationFunction.map((Object)associationDescriptor);
    }

    @Override
    public List<EntityReference> getManyAssociationState(AssociationDescriptor associationDescriptor) {
        return Iterables.toList((Iterable)((Iterable)this.manyAssociationFunction.map((Object)associationDescriptor)));
    }

    @Override
    public Map<String, EntityReference> getNamedAssociationState(AssociationDescriptor associationDescriptor) {
        return (Map)this.namedAssociationFunction.map((Object)associationDescriptor);
    }

    public void populateState(EntityModel model, EntityState state) {
        ManyAssociationState associationState;
        for (PropertyDescriptor propertyDescriptor : model.state().properties()) {
            Object value = this.getPropertyState(propertyDescriptor);
            state.setPropertyValue(propertyDescriptor.qualifiedName(), value);
        }
        for (AssociationDescriptor associationDescriptor : model.state().associations()) {
            EntityReference ref = this.getAssociationState(associationDescriptor);
            state.setAssociationValue(associationDescriptor.qualifiedName(), ref);
        }
        for (ManyAssociationModel manyAssociationModel : model.state().manyAssociations()) {
            associationState = state.manyAssociationValueOf(manyAssociationModel.qualifiedName());
            for (EntityReference ref : associationState) {
                associationState.remove(ref);
            }
            for (EntityReference ref : this.getManyAssociationState(manyAssociationModel)) {
                associationState.add(0, ref);
            }
        }
        for (NamedAssociationModel namedAssociationModel : model.state().namedAssociations()) {
            associationState = state.namedAssociationValueOf(namedAssociationModel.qualifiedName());
            for (String name : associationState) {
                associationState.remove(name);
            }
            for (Map.Entry<String, EntityReference> entry : this.getNamedAssociationState(namedAssociationModel).entrySet()) {
                associationState.put(entry.getKey(), entry.getValue());
            }
        }
    }
}

