/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.runtime.composite;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.List;
import org.qi4j.api.common.ConstructionException;
import org.qi4j.api.composite.CompositeInstance;
import org.qi4j.api.injection.scope.This;
import org.qi4j.api.mixin.Initializable;
import org.qi4j.api.mixin.InitializationException;
import org.qi4j.api.mixin.MixinDescriptor;
import org.qi4j.api.property.StateHolder;
import org.qi4j.functional.Function;
import org.qi4j.functional.HierarchicalVisitor;
import org.qi4j.functional.Iterables;
import org.qi4j.functional.Specification;
import org.qi4j.functional.VisitableHierarchy;
import org.qi4j.runtime.composite.ConstructorsModel;
import org.qi4j.runtime.composite.FragmentClassLoader;
import org.qi4j.runtime.composite.FragmentInvocationHandler;
import org.qi4j.runtime.composite.GenericFragmentInvocationHandler;
import org.qi4j.runtime.composite.TypedModifierInvocationHandler;
import org.qi4j.runtime.composite.UsesInstance;
import org.qi4j.runtime.injection.DependencyModel;
import org.qi4j.runtime.injection.InjectedFieldsModel;
import org.qi4j.runtime.injection.InjectedMethodsModel;
import org.qi4j.runtime.injection.InjectionContext;

public final class MixinModel
implements MixinDescriptor,
VisitableHierarchy<Object, Object> {
    private final Class<?> mixinClass;
    private final Class<?> instantiationClass;
    private final ConstructorsModel constructorsModel;
    private final InjectedFieldsModel injectedFieldsModel;
    private final InjectedMethodsModel injectedMethodsModel;
    private final Iterable<Class<?>> thisMixinTypes;

    public MixinModel(Class<?> declaredMixinClass, Class<?> instantiationClass) {
        this.injectedFieldsModel = new InjectedFieldsModel(declaredMixinClass);
        this.injectedMethodsModel = new InjectedMethodsModel(declaredMixinClass);
        this.mixinClass = declaredMixinClass;
        this.instantiationClass = instantiationClass;
        this.constructorsModel = new ConstructorsModel(instantiationClass);
        this.thisMixinTypes = this.buildThisMixinTypes();
    }

    public Class<?> mixinClass() {
        return this.mixinClass;
    }

    public Class<?> instantiationClass() {
        return this.instantiationClass;
    }

    public boolean isGeneric() {
        return InvocationHandler.class.isAssignableFrom(this.mixinClass);
    }

    public Iterable<DependencyModel> dependencies() {
        return Iterables.flatten((Iterable[])new Iterable[]{this.constructorsModel.dependencies(), this.injectedFieldsModel.dependencies(), this.injectedMethodsModel.dependencies()});
    }

    public <ThrowableType extends Throwable> boolean accept(HierarchicalVisitor<? super Object, ? super Object, ThrowableType> visitor) throws ThrowableType {
        if (visitor.visitEnter((Object)this) && this.constructorsModel.accept(visitor) && this.injectedFieldsModel.accept(visitor)) {
            this.injectedMethodsModel.accept(visitor);
        }
        return visitor.visitLeave((Object)this);
    }

    public Object newInstance(CompositeInstance compositeInstance, StateHolder state, UsesInstance uses) {
        InjectionContext injectionContext = new InjectionContext(compositeInstance, uses, state);
        return this.newInstance(injectionContext);
    }

    public Object newInstance(InjectionContext injectionContext) {
        CompositeInstance compositeInstance = injectionContext.compositeInstance();
        Object mixin = this.constructorsModel.newInstance(injectionContext);
        if (FragmentClassLoader.isGenerated(this.instantiationClass)) {
            try {
                this.instantiationClass.getDeclaredField("_instance").set(mixin, injectionContext.compositeInstance());
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        this.injectedFieldsModel.inject(injectionContext, mixin);
        this.injectedMethodsModel.inject(injectionContext, mixin);
        if (mixin instanceof Initializable) {
            try {
                ((Initializable)mixin).initialize();
            }
            catch (InitializationException e) {
                List compositeType = Iterables.toList((Iterable)compositeInstance.types());
                String message = "Unable to initialize " + this.mixinClass + " in composite " + compositeType;
                throw new ConstructionException(message, (Throwable)e);
            }
        }
        return mixin;
    }

    public Iterable<Class<?>> thisMixinTypes() {
        return this.thisMixinTypes;
    }

    private Iterable<Class<?>> buildThisMixinTypes() {
        return Iterables.map((Function)new DependencyModel.InjectionTypeFunction(), (Iterable)Iterables.unique((Iterable)Iterables.filter((Specification)new DependencyModel.ScopeSpecification(This.class), this.dependencies())));
    }

    protected FragmentInvocationHandler newInvocationHandler(Method method) {
        if (InvocationHandler.class.isAssignableFrom(this.mixinClass) && !method.getDeclaringClass().isAssignableFrom(this.mixinClass)) {
            return new GenericFragmentInvocationHandler();
        }
        return new TypedModifierInvocationHandler();
    }

    public String toString() {
        return this.mixinClass.getName();
    }
}

