/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.runtime.composite;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.qi4j.api.util.Classes;
import org.qi4j.bootstrap.BindingException;
import org.qi4j.functional.Function;
import org.qi4j.functional.HierarchicalVisitor;
import org.qi4j.functional.HierarchicalVisitorAdapter;
import org.qi4j.functional.Iterables;
import org.qi4j.functional.Specification;
import org.qi4j.functional.VisitableHierarchy;
import org.qi4j.runtime.composite.FragmentInvocationHandler;
import org.qi4j.runtime.composite.MixinModel;
import org.qi4j.runtime.composite.UsageGraph;
import org.qi4j.runtime.injection.DependencyModel;
import org.qi4j.runtime.injection.InjectedFieldModel;
import org.qi4j.runtime.model.Binder;
import org.qi4j.runtime.model.Resolution;

public class MixinsModel
implements Binder,
VisitableHierarchy<Object, Object> {
    protected final Map<Method, MixinModel> methodImplementation = new HashMap<Method, MixinModel>();
    protected final Map<Method, Integer> methodIndex = new HashMap<Method, Integer>();
    protected List<MixinModel> mixinModels = new ArrayList<MixinModel>();
    private final Map<Class, Integer> mixinIndex = new HashMap<Class, Integer>();
    private final Set<Class<?>> mixinTypes = new LinkedHashSet();

    public Iterable<Class<?>> mixinTypes() {
        return this.mixinTypes;
    }

    public <T> boolean isImplemented(Class<T> mixinType) {
        return this.mixinTypes.contains(mixinType);
    }

    public List<MixinModel> mixinModels() {
        return this.mixinModels;
    }

    public MixinModel mixinFor(Method method) {
        return this.methodImplementation.get(method);
    }

    public MixinModel getMixinModel(Class mixinClass) {
        for (MixinModel mixinModel : this.mixinModels) {
            if (!mixinModel.mixinClass().equals(mixinClass)) continue;
            return mixinModel;
        }
        return null;
    }

    public void addMixinType(Class mixinType) {
        for (Type type : Classes.interfacesOf((Type)mixinType)) {
            this.mixinTypes.add((Class<?>)Classes.RAW_CLASS.map((Object)type));
        }
    }

    public void addMixinModel(MixinModel mixinModel) {
        this.mixinModels.add(mixinModel);
    }

    public void addMethodMixin(Method method, MixinModel mixinModel) {
        this.methodImplementation.put(method, mixinModel);
    }

    public <ThrowableType extends Throwable> boolean accept(HierarchicalVisitor<? super Object, ? super Object, ThrowableType> visitor) throws ThrowableType {
        if (visitor.visitEnter((Object)this)) {
            for (MixinModel mixinModel : this.mixinModels) {
                mixinModel.accept(visitor);
            }
        }
        return visitor.visitLeave((Object)this);
    }

    @Override
    public void bind(final Resolution resolution) throws BindingException {
        UsageGraph<MixinModel> deps = new UsageGraph<MixinModel>(this.mixinModels, new Uses(), true);
        this.mixinModels = deps.resolveOrder();
        for (int i = 0; i < this.mixinModels.size(); ++i) {
            MixinModel mixinModel = this.mixinModels.get(i);
            this.mixinIndex.put(mixinModel.mixinClass(), i);
        }
        for (Map.Entry<Method, MixinModel> methodClassEntry : this.methodImplementation.entrySet()) {
            this.methodIndex.put(methodClassEntry.getKey(), this.mixinIndex.get(methodClassEntry.getValue().mixinClass()));
        }
        for (MixinModel mixinModel : this.mixinModels) {
            mixinModel.accept(new HierarchicalVisitorAdapter<Object, Object, BindingException>(){

                public boolean visitEnter(Object visited) throws BindingException {
                    if (visited instanceof InjectedFieldModel) {
                        InjectedFieldModel fieldModel = (InjectedFieldModel)visited;
                        fieldModel.bind(resolution.forField(fieldModel.field()));
                        return false;
                    }
                    if (visited instanceof Binder) {
                        Binder constructorsModel = (Binder)visited;
                        constructorsModel.bind(resolution);
                        return false;
                    }
                    return true;
                }

                public boolean visit(Object visited) throws BindingException {
                    if (visited instanceof Binder) {
                        ((Binder)visited).bind(resolution);
                    }
                    return true;
                }
            });
        }
    }

    public Object[] newMixinHolder() {
        return new Object[this.mixinIndex.size()];
    }

    public FragmentInvocationHandler newInvocationHandler(Method method) {
        return this.mixinFor(method).newInvocationHandler(method);
    }

    public Iterable<DependencyModel> dependencies() {
        return Iterables.flattenIterables((Iterable)Iterables.map((Function)new Function<MixinModel, Iterable<DependencyModel>>(){

            public Iterable<DependencyModel> map(MixinModel mixinModel) {
                return mixinModel.dependencies();
            }
        }, this.mixinModels));
    }

    public Iterable<Method> invocationsFor(final Class<?> mixinClass) {
        return Iterables.map((Function)new Function<Map.Entry<Method, MixinModel>, Method>(){

            public Method map(Map.Entry<Method, MixinModel> entry) {
                return entry.getKey();
            }
        }, (Iterable)Iterables.filter((Specification)new Specification<Map.Entry<Method, MixinModel>>(){

            public boolean satisfiedBy(Map.Entry<Method, MixinModel> item) {
                MixinModel model = item.getValue();
                return model.mixinClass().equals(mixinClass);
            }
        }, this.methodImplementation.entrySet()));
    }

    private class Uses
    implements UsageGraph.Use<MixinModel> {
        private Uses() {
        }

        @Override
        public Collection<MixinModel> uses(MixinModel source) {
            Iterable<Class<?>> thisMixinTypes = source.thisMixinTypes();
            ArrayList<MixinModel> usedMixinClasses = new ArrayList<MixinModel>();
            for (Class<?> thisMixinType : thisMixinTypes) {
                for (Method method : thisMixinType.getMethods()) {
                    usedMixinClasses.add(MixinsModel.this.methodImplementation.get(method));
                }
            }
            return usedMixinClasses;
        }
    }
}

