/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.runtime.composite;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.List;
import org.qi4j.runtime.composite.ProxyReferenceInvocationHandler;
import org.qi4j.runtime.composite.SideEffectInvocationHandlerResult;

public final class SideEffectsInstance
implements InvocationHandler {
    private final List<InvocationHandler> sideEffects;
    private final SideEffectInvocationHandlerResult resultInvocationHandler;
    private final ProxyReferenceInvocationHandler proxyHandler;
    private InvocationHandler invoker;

    public SideEffectsInstance(List<InvocationHandler> sideEffects, SideEffectInvocationHandlerResult resultInvocationHandler, ProxyReferenceInvocationHandler proxyHandler, InvocationHandler invoker) {
        this.sideEffects = sideEffects;
        this.resultInvocationHandler = resultInvocationHandler;
        this.proxyHandler = proxyHandler;
        this.invoker = invoker;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            Object result = this.invoker.invoke(proxy, method, args);
            this.invokeSideEffects(proxy, method, args, result, null);
            return result;
        }
        catch (Throwable throwable) {
            this.invokeSideEffects(proxy, method, args, null, throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeSideEffects(Object proxy, Method method, Object[] params, Object result, Throwable originalThrowable) throws Throwable {
        this.proxyHandler.setProxy(proxy);
        this.resultInvocationHandler.setResult(result, originalThrowable);
        try {
            for (InvocationHandler sideEffect : this.sideEffects) {
                try {
                    sideEffect.invoke(proxy, method, params);
                }
                catch (Throwable throwable) {
                    if (throwable == originalThrowable) continue;
                    throwable.printStackTrace();
                }
            }
        }
        finally {
            this.proxyHandler.clearProxy();
            this.resultInvocationHandler.setResult(null, null);
        }
    }
}

