/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.runtime.composite;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.Method;
import org.qi4j.api.entity.Lifecycle;
import org.qi4j.api.mixin.Initializable;
import org.qi4j.api.util.Classes;
import org.qi4j.api.util.Methods;
import org.qi4j.functional.Function;
import org.qi4j.functional.Iterables;
import org.qi4j.functional.Specification;

final class TransientClassLoader
extends ClassLoader {
    private static final int JDK_VERSION;
    public static final String GENERATED_POSTFIX = "_Proxy";

    TransientClassLoader(ClassLoader parent) {
        super(parent);
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        if (name.endsWith(GENERATED_POSTFIX)) {
            Class<?> baseClass;
            String baseName = name.substring(0, name.length() - 6);
            try {
                baseClass = this.loadClass(baseName);
            }
            catch (ClassNotFoundException e) {
                int idx;
                while ((idx = baseName.lastIndexOf("_")) != -1) {
                    baseName = baseName.substring(0, idx) + "$" + baseName.substring(idx + 1);
                    try {
                        baseClass = this.loadClass(baseName);
                    }
                    catch (ClassNotFoundException e1) {
                    }
                }
                throw e;
            }
            byte[] b = TransientClassLoader.generateClass(name, baseClass);
            return this.defineClass(name, b, 0, b.length, baseClass.getProtectionDomain());
        }
        return this.getClass().getClassLoader().loadClass(name);
    }

    public static byte[] generateClass(String name, Class baseClass) throws ClassNotFoundException {
        MethodVisitor mv;
        String classSlash = name.replace('.', '/');
        String baseClassSlash = org.objectweb.asm.Type.getInternalName((Class)baseClass);
        ClassWriter cw = new ClassWriter(1);
        cw.visit(JDK_VERSION, 33, classSlash, null, baseClassSlash, null);
        FieldVisitor fv = cw.visitField(1, "_instance", "Lorg/qi4j/api/composite/CompositeInvoker;", null, null);
        fv.visitEnd();
        int idx = 1;
        for (java.lang.reflect.Method method : baseClass.getMethods()) {
            if (!TransientClassLoader.isOverloaded(method, baseClass)) continue;
            fv = cw.visitField(10, "m" + idx++, "Ljava/lang/reflect/Method;", null, null);
            fv.visitEnd();
        }
        for (Constructor<?> constructor : baseClass.getDeclaredConstructors()) {
            if (!Modifier.isPublic(constructor.getModifiers()) && !Modifier.isProtected(constructor.getModifiers())) continue;
            String desc = Method.getMethod(constructor).getDescriptor();
            mv = cw.visitMethod(1, "<init>", desc, null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            int idx2 = 1;
            for (Class<?> aClass : constructor.getParameterTypes()) {
                mv.visitVarInsn(25, idx2++);
            }
            mv.visitMethodInsn(183, baseClassSlash, "<init>", desc, false);
            mv.visitInsn(177);
            mv.visitMaxs(idx2, idx2);
            mv.visitEnd();
        }
        java.lang.reflect.Method[] methods = baseClass.getMethods();
        int idx3 = 0;
        ArrayList<Label> exceptionLabels = new ArrayList<Label>();
        for (java.lang.reflect.Method method : methods) {
            if (!TransientClassLoader.isOverloaded(method, baseClass)) continue;
            ++idx3;
            String methodName = method.getName();
            String desc = Method.getMethod((java.lang.reflect.Method)method).getDescriptor();
            String[] exceptions = null;
            mv = cw.visitMethod(1, methodName, desc, null, exceptions);
            if (TransientClassLoader.isInternalQi4jMethod(method, baseClass)) {
                mv.visitInsn(177);
            } else {
                Label endLabel = null;
                if (method.getExceptionTypes().length > 0) {
                    exceptions = new String[method.getExceptionTypes().length];
                    for (int i = 0; i < method.getExceptionTypes().length; ++i) {
                        Class<?> aClass = method.getExceptionTypes()[i];
                        exceptions[i] = org.objectweb.asm.Type.getInternalName(aClass);
                    }
                }
                mv.visitCode();
                Label l0 = new Label();
                Label l1 = new Label();
                exceptionLabels.clear();
                Class<?>[] arr$ = method.getExceptionTypes();
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    Class<?> declaredException = arr$[i$];
                    Label ld = new Label();
                    mv.visitTryCatchBlock(l0, l1, ld, org.objectweb.asm.Type.getInternalName(declaredException));
                    exceptionLabels.add(ld);
                }
                Label lruntime = new Label();
                mv.visitTryCatchBlock(l0, l1, lruntime, "java/lang/RuntimeException");
                Label lerror = new Label();
                mv.visitTryCatchBlock(l0, l1, lerror, "java/lang/Throwable");
                mv.visitLabel(l0);
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, classSlash, "_instance", "Lorg/qi4j/api/composite/CompositeInvoker;");
                mv.visitFieldInsn(178, classSlash, "m" + idx3, "Ljava/lang/reflect/Method;");
                int paramCount = method.getParameterTypes().length;
                int stackIdx = 0;
                if (paramCount == 0) {
                    mv.visitInsn(1);
                } else {
                    TransientClassLoader.insn(mv, paramCount);
                    mv.visitTypeInsn(189, "java/lang/Object");
                    int pidx = 0;
                    for (Class<?> aClass : method.getParameterTypes()) {
                        mv.visitInsn(89);
                        TransientClassLoader.insn(mv, pidx++);
                        stackIdx = TransientClassLoader.wrapParameter(mv, aClass, stackIdx + 1);
                        mv.visitInsn(83);
                    }
                }
                mv.visitMethodInsn(185, "org/qi4j/api/composite/CompositeInvoker", "invokeComposite", "(Ljava/lang/reflect/Method;[Ljava/lang/Object;)Ljava/lang/Object;", true);
                if (!method.getReturnType().equals(Void.TYPE)) {
                    TransientClassLoader.unwrapResult(mv, method.getReturnType(), l1);
                } else {
                    mv.visitInsn(87);
                    mv.visitLabel(l1);
                    endLabel = new Label();
                    mv.visitJumpInsn(167, endLabel);
                }
                ++stackIdx;
                int exceptionIdx = 0;
                for (Class<?> aClass : method.getExceptionTypes()) {
                    mv.visitLabel((Label)exceptionLabels.get(exceptionIdx++));
                    mv.visitFrame(4, 0, null, 1, new Object[]{org.objectweb.asm.Type.getInternalName(aClass)});
                    mv.visitVarInsn(58, stackIdx);
                    mv.visitVarInsn(25, stackIdx);
                    mv.visitInsn(191);
                }
                mv.visitLabel(lruntime);
                mv.visitFrame(4, 0, null, 1, new Object[]{"java/lang/RuntimeException"});
                mv.visitVarInsn(58, stackIdx);
                mv.visitVarInsn(25, stackIdx);
                mv.visitInsn(191);
                mv.visitLabel(lerror);
                mv.visitFrame(4, 0, null, 1, new Object[]{"java/lang/Throwable"});
                mv.visitVarInsn(58, stackIdx);
                mv.visitVarInsn(25, stackIdx);
                mv.visitTypeInsn(192, "java/lang/Error");
                mv.visitInsn(191);
                if (endLabel != null) {
                    mv.visitLabel(endLabel);
                    mv.visitFrame(3, 0, null, 0, null);
                    mv.visitInsn(177);
                }
                mv.visitMaxs(0, 0);
                mv.visitEnd();
            }
            if (Modifier.isAbstract(method.getModifiers())) continue;
            mv = cw.visitMethod(1, "_" + method.getName(), desc, null, exceptions);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            int stackIdx = 1;
            for (Class<?> aClass : method.getParameterTypes()) {
                stackIdx = TransientClassLoader.loadParameter(mv, aClass, stackIdx) + 1;
            }
            mv.visitMethodInsn(183, baseClassSlash, method.getName(), desc, false);
            if (!method.getReturnType().equals(Void.TYPE)) {
                TransientClassLoader.returnResult(mv, method.getReturnType());
            } else {
                mv.visitInsn(177);
            }
            mv.visitMaxs(1, 1);
            mv.visitEnd();
        }
        mv = cw.visitMethod(8, "<clinit>", "()V", null, null);
        mv.visitCode();
        Label l0 = new Label();
        Label l1 = new Label();
        Label l2 = new Label();
        mv.visitTryCatchBlock(l0, l1, l2, "java/lang/NoSuchMethodException");
        mv.visitLabel(l0);
        int midx = 0;
        for (java.lang.reflect.Method method : methods) {
            if (!TransientClassLoader.isOverloaded(method, baseClass)) continue;
            method.setAccessible(true);
            Class<?> methodClass = method.getDeclaringClass();
            ++midx;
            mv.visitLdcInsn((Object)org.objectweb.asm.Type.getType(methodClass));
            mv.visitLdcInsn((Object)method.getName());
            TransientClassLoader.insn(mv, method.getParameterTypes().length);
            mv.visitTypeInsn(189, "java/lang/Class");
            int pidx = 0;
            for (Class<?> aClass : method.getParameterTypes()) {
                mv.visitInsn(89);
                TransientClassLoader.insn(mv, pidx++);
                TransientClassLoader.type(mv, aClass);
                mv.visitInsn(83);
            }
            mv.visitMethodInsn(182, "java/lang/Class", "getMethod", "(Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;", false);
            mv.visitFieldInsn(179, classSlash, "m" + midx, "Ljava/lang/reflect/Method;");
        }
        mv.visitLabel(l1);
        Label l3 = new Label();
        mv.visitJumpInsn(167, l3);
        mv.visitLabel(l2);
        mv.visitFrame(4, 0, null, 1, new Object[]{"java/lang/NoSuchMethodException"});
        mv.visitVarInsn(58, 0);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, "java/lang/NoSuchMethodException", "printStackTrace", "()V", false);
        mv.visitLabel(l3);
        mv.visitFrame(3, 0, null, 0, null);
        mv.visitInsn(177);
        mv.visitMaxs(6, 1);
        mv.visitEnd();
        cw.visitEnd();
        return cw.toByteArray();
    }

    private static boolean isOverloaded(java.lang.reflect.Method method, Class baseClass) {
        return !Modifier.isFinal(method.getModifiers());
    }

    private static boolean isInternalQi4jMethod(java.lang.reflect.Method method, Class baseClass) {
        return TransientClassLoader.isDeclaredIn(method, Initializable.class, baseClass) || TransientClassLoader.isDeclaredIn(method, Lifecycle.class, baseClass);
    }

    private static boolean isDeclaredIn(java.lang.reflect.Method method, Class<?> clazz, Class<?> baseClass) {
        if (!clazz.isAssignableFrom(baseClass)) {
            return false;
        }
        try {
            clazz.getMethod(method.getName(), method.getParameterTypes());
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    private static Class getInterfaceMethodDeclaration(java.lang.reflect.Method method, Class clazz) throws NoSuchMethodException {
        Iterable interfaces = Iterables.map((Function)Classes.RAW_CLASS, (Iterable)Classes.interfacesOf((Type)clazz));
        for (Class anInterface : interfaces) {
            try {
                anInterface.getMethod(method.getName(), method.getParameterTypes());
                return anInterface;
            }
            catch (NoSuchMethodException e) {
            }
        }
        throw new NoSuchMethodException(method.getName());
    }

    private static boolean isInterfaceMethod(java.lang.reflect.Method method, Class<?> baseClass) {
        for (Class aClass : Iterables.filter((Specification)Methods.HAS_METHODS, (Iterable)Iterables.map((Function)Classes.RAW_CLASS, (Iterable)Classes.interfacesOf(baseClass)))) {
            try {
                java.lang.reflect.Method m = aClass.getMethod(method.getName(), method.getParameterTypes());
                m.setAccessible(true);
                return true;
            }
            catch (NoSuchMethodException e) {
            }
        }
        return false;
    }

    private static void type(MethodVisitor mv, Class<?> aClass) {
        if (aClass.equals(Integer.TYPE)) {
            mv.visitFieldInsn(178, "java/lang/Integer", "TYPE", "Ljava/lang/Class;");
        } else if (aClass.equals(Long.TYPE)) {
            mv.visitFieldInsn(178, "java/lang/Long", "TYPE", "Ljava/lang/Class;");
        } else if (aClass.equals(Short.TYPE)) {
            mv.visitFieldInsn(178, "java/lang/Short", "TYPE", "Ljava/lang/Class;");
        } else if (aClass.equals(Byte.TYPE)) {
            mv.visitFieldInsn(178, "java/lang/Byte", "TYPE", "Ljava/lang/Class;");
        } else if (aClass.equals(Double.TYPE)) {
            mv.visitFieldInsn(178, "java/lang/Double", "TYPE", "Ljava/lang/Class;");
        } else if (aClass.equals(Float.TYPE)) {
            mv.visitFieldInsn(178, "java/lang/Float", "TYPE", "Ljava/lang/Class;");
        } else if (aClass.equals(Boolean.TYPE)) {
            mv.visitFieldInsn(178, "java/lang/Boolean", "TYPE", "Ljava/lang/Class;");
        } else if (aClass.equals(Character.TYPE)) {
            mv.visitFieldInsn(178, "java/lang/Character", "TYPE", "Ljava/lang/Class;");
        } else {
            mv.visitLdcInsn((Object)org.objectweb.asm.Type.getType(aClass));
        }
    }

    private static int wrapParameter(MethodVisitor mv, Class<?> aClass, int idx) {
        if (aClass.equals(Integer.TYPE)) {
            mv.visitVarInsn(21, idx);
            mv.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;", false);
        } else if (aClass.equals(Long.TYPE)) {
            mv.visitVarInsn(22, idx);
            mv.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;", false);
            ++idx;
        } else if (aClass.equals(Short.TYPE)) {
            mv.visitVarInsn(21, idx);
            mv.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;", false);
        } else if (aClass.equals(Byte.TYPE)) {
            mv.visitVarInsn(21, idx);
            mv.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;", false);
        } else if (aClass.equals(Double.TYPE)) {
            mv.visitVarInsn(24, idx);
            ++idx;
            mv.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;", false);
        } else if (aClass.equals(Float.TYPE)) {
            mv.visitVarInsn(23, idx);
            mv.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;", false);
        } else if (aClass.equals(Boolean.TYPE)) {
            mv.visitVarInsn(21, idx);
            mv.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;", false);
        } else if (aClass.equals(Character.TYPE)) {
            mv.visitVarInsn(21, idx);
            mv.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;", false);
        } else {
            mv.visitVarInsn(25, idx);
        }
        return idx;
    }

    private static void unwrapResult(MethodVisitor mv, Class<?> aClass, Label label) {
        if (aClass.equals(Integer.TYPE)) {
            mv.visitTypeInsn(192, "java/lang/Integer");
            mv.visitMethodInsn(182, "java/lang/Integer", "intValue", "()I", false);
            mv.visitLabel(label);
            mv.visitInsn(172);
        } else if (aClass.equals(Long.TYPE)) {
            mv.visitTypeInsn(192, "java/lang/Long");
            mv.visitMethodInsn(182, "java/lang/Long", "longValue", "()J", false);
            mv.visitLabel(label);
            mv.visitInsn(173);
        } else if (aClass.equals(Short.TYPE)) {
            mv.visitTypeInsn(192, "java/lang/Short");
            mv.visitMethodInsn(182, "java/lang/Short", "shortValue", "()S", false);
            mv.visitLabel(label);
            mv.visitInsn(172);
        } else if (aClass.equals(Byte.TYPE)) {
            mv.visitTypeInsn(192, "java/lang/Byte");
            mv.visitMethodInsn(182, "java/lang/Byte", "byteValue", "()B", false);
            mv.visitLabel(label);
            mv.visitInsn(172);
        } else if (aClass.equals(Double.TYPE)) {
            mv.visitTypeInsn(192, "java/lang/Double");
            mv.visitMethodInsn(182, "java/lang/Double", "doubleValue", "()D", false);
            mv.visitLabel(label);
            mv.visitInsn(175);
        } else if (aClass.equals(Float.TYPE)) {
            mv.visitTypeInsn(192, "java/lang/Float");
            mv.visitMethodInsn(182, "java/lang/Float", "floatValue", "()F", false);
            mv.visitLabel(label);
            mv.visitInsn(174);
        } else if (aClass.equals(Boolean.TYPE)) {
            mv.visitTypeInsn(192, "java/lang/Boolean");
            mv.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z", false);
            mv.visitLabel(label);
            mv.visitInsn(172);
        } else if (aClass.equals(Character.TYPE)) {
            mv.visitTypeInsn(192, "java/lang/Character");
            mv.visitMethodInsn(182, "java/lang/Character", "charValue", "()C", false);
            mv.visitLabel(label);
            mv.visitInsn(172);
        } else {
            mv.visitTypeInsn(192, org.objectweb.asm.Type.getInternalName(aClass));
            mv.visitLabel(label);
            mv.visitInsn(176);
        }
    }

    private static int loadParameter(MethodVisitor mv, Class<?> aClass, int idx) {
        if (aClass.equals(Integer.TYPE)) {
            mv.visitVarInsn(21, idx);
        } else if (aClass.equals(Long.TYPE)) {
            mv.visitVarInsn(22, idx);
            ++idx;
        } else if (aClass.equals(Short.TYPE)) {
            mv.visitVarInsn(21, idx);
        } else if (aClass.equals(Byte.TYPE)) {
            mv.visitVarInsn(21, idx);
        } else if (aClass.equals(Double.TYPE)) {
            mv.visitVarInsn(24, idx);
            ++idx;
        } else if (aClass.equals(Float.TYPE)) {
            mv.visitVarInsn(23, idx);
        } else if (aClass.equals(Boolean.TYPE)) {
            mv.visitVarInsn(21, idx);
        } else if (aClass.equals(Character.TYPE)) {
            mv.visitVarInsn(21, idx);
        } else {
            mv.visitVarInsn(25, idx);
        }
        return idx;
    }

    private static void returnResult(MethodVisitor mv, Class<?> aClass) {
        if (aClass.equals(Integer.TYPE)) {
            mv.visitInsn(172);
        } else if (aClass.equals(Long.TYPE)) {
            mv.visitInsn(173);
        } else if (aClass.equals(Short.TYPE)) {
            mv.visitInsn(172);
        } else if (aClass.equals(Byte.TYPE)) {
            mv.visitInsn(172);
        } else if (aClass.equals(Double.TYPE)) {
            mv.visitInsn(175);
        } else if (aClass.equals(Float.TYPE)) {
            mv.visitInsn(174);
        } else if (aClass.equals(Boolean.TYPE)) {
            mv.visitInsn(172);
        } else if (aClass.equals(Character.TYPE)) {
            mv.visitInsn(172);
        } else {
            mv.visitTypeInsn(192, org.objectweb.asm.Type.getInternalName(aClass));
            mv.visitInsn(176);
        }
    }

    private static void insn(MethodVisitor mv, int length) {
        switch (length) {
            case 0: {
                mv.visitInsn(3);
                return;
            }
            case 1: {
                mv.visitInsn(4);
                return;
            }
            case 2: {
                mv.visitInsn(5);
                return;
            }
            case 3: {
                mv.visitInsn(6);
                return;
            }
            case 4: {
                mv.visitInsn(7);
                return;
            }
            case 5: {
                mv.visitInsn(8);
                return;
            }
        }
        mv.visitIntInsn(16, length);
    }

    public static boolean isGenerated(Class clazz) {
        return clazz.getName().endsWith(GENERATED_POSTFIX);
    }

    public static boolean isGenerated(Object object) {
        return object.getClass().getName().endsWith(GENERATED_POSTFIX);
    }

    public Class loadFragmentClass(Class fragmentClass) throws ClassNotFoundException {
        return this.loadClass(fragmentClass.getName().replace('$', '_') + GENERATED_POSTFIX);
    }

    public static Class getSourceClass(Class fragmentClass) {
        return fragmentClass.getName().endsWith(GENERATED_POSTFIX) ? fragmentClass.getSuperclass() : fragmentClass;
    }

    static {
        String jdkString;
        switch (jdkString = System.getProperty("java.specification.version")) {
            case "1.8": {
                JDK_VERSION = 52;
                break;
            }
            default: {
                JDK_VERSION = 51;
            }
        }
    }
}

