/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.runtime.composite;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.qi4j.bootstrap.BindingException;

public final class UsageGraph<K> {
    private final Collection<K> data;
    private final Use<K> use;
    private final boolean allowCyclic;
    private List<K> resolved;
    private HashMap<K, List<K>> transitive;

    public UsageGraph(Collection<K> data, Use<K> use, boolean allowCyclic) {
        this.data = data;
        this.use = use;
        this.allowCyclic = allowCyclic;
    }

    public boolean transitiveUse(K source, K other) throws BindingException {
        if (this.transitive == null) {
            this.buildUsageGraph();
        }
        return this.transitive.containsKey(source) && this.transitive.get(source).contains(other);
    }

    private void checkCyclic(List<K> visited, K sourceItem, K used) throws BindingException {
        Collection<K> nextLevel = this.use.uses(used);
        for (K next : nextLevel) {
            if (next == sourceItem && !this.allowCyclic) {
                visited.add(next);
                throw new BindingException("Cyclic usage detected: " + sourceItem + " -> " + visited);
            }
            if (visited.contains(next)) continue;
            visited.add(next);
            this.checkCyclic(visited, sourceItem, next);
        }
    }

    public void invalidate() {
        this.resolved = null;
        this.transitive = null;
    }

    public List<K> resolveOrder() throws BindingException {
        if (this.resolved == null) {
            this.buildUsageGraph();
            this.resolved = new LinkedList<K>();
            for (K item : this.data) {
                int pos = this.resolved.size();
                for (K entry : this.resolved) {
                    if (!this.transitiveUse(entry, item)) continue;
                    pos = this.resolved.indexOf(entry);
                    break;
                }
                this.resolved.add(pos, item);
            }
        }
        return this.resolved;
    }

    private void buildUsageGraph() throws BindingException {
        this.transitive = new HashMap();
        for (K sourceItem : this.data) {
            LinkedList visited = new LinkedList();
            this.checkCyclic(visited, sourceItem, sourceItem);
            this.transitive.put(sourceItem, visited);
        }
    }

    public static interface Use<K> {
        public Collection<K> uses(K var1);
    }
}

