/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.runtime.composite;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.qi4j.functional.Iterables;

public final class UsesInstance {
    public static final UsesInstance EMPTY_USES = new UsesInstance(new HashSet<Object>());
    private final Set<Object> uses;

    private UsesInstance(HashSet<Object> uses) {
        this.uses = Collections.unmodifiableSet(uses);
    }

    public UsesInstance use(Object ... objects) {
        HashSet<Object> useObjects = new HashSet<Object>();
        if (!this.uses.isEmpty()) {
            useObjects.addAll(this.uses);
            for (Object object : objects) {
                Object oldUseForType = this.useForType(object.getClass());
                if (oldUseForType == null) continue;
                useObjects.remove(oldUseForType);
            }
        }
        useObjects.addAll(Arrays.asList(objects));
        return new UsesInstance(useObjects);
    }

    public Object useForType(Class<?> type) {
        for (Object use : this.uses) {
            if (!type.isInstance(use)) continue;
            return use;
        }
        return null;
    }

    public Object[] toArray() {
        return Iterables.toArray(this.uses);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UsesInstance that = (UsesInstance)o;
        return this.uses.equals(that.uses);
    }

    public int hashCode() {
        return this.uses.hashCode();
    }

    public String toString() {
        return "UsesInstance{uses=" + this.uses + '}';
    }
}

