/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.runtime.entity;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashSet;
import org.qi4j.api.association.Association;
import org.qi4j.api.association.AssociationDescriptor;
import org.qi4j.api.association.ManyAssociation;
import org.qi4j.api.association.NamedAssociation;
import org.qi4j.api.composite.CompositeDescriptor;
import org.qi4j.api.composite.CompositeInstance;
import org.qi4j.api.constraint.ConstraintViolationException;
import org.qi4j.api.entity.EntityComposite;
import org.qi4j.api.entity.EntityReference;
import org.qi4j.api.entity.Identity;
import org.qi4j.api.entity.LifecycleException;
import org.qi4j.api.property.StateHolder;
import org.qi4j.api.unitofwork.NoSuchEntityException;
import org.qi4j.api.unitofwork.UnitOfWork;
import org.qi4j.api.unitofwork.UnitOfWorkException;
import org.qi4j.runtime.composite.CompositeMethodInstance;
import org.qi4j.runtime.composite.MixinsInstance;
import org.qi4j.runtime.entity.EntityModel;
import org.qi4j.runtime.entity.EntityStateInstance;
import org.qi4j.runtime.entity.EntityStateModel;
import org.qi4j.runtime.structure.ModuleUnitOfWork;
import org.qi4j.spi.entity.EntityState;
import org.qi4j.spi.entity.EntityStatus;
import org.qi4j.spi.module.ModuleSpi;

public final class EntityInstance
implements CompositeInstance,
MixinsInstance {
    private final EntityComposite proxy;
    private final ModuleUnitOfWork uow;
    private final ModuleSpi moduleInstance;
    private final EntityModel entityModel;
    private final EntityReference identity;
    private final EntityState entityState;
    private Object[] mixins;
    private EntityStateInstance state;

    public static EntityInstance entityInstanceOf(EntityComposite composite) {
        return (EntityInstance)((Object)Proxy.getInvocationHandler(composite));
    }

    public EntityInstance(ModuleUnitOfWork uow, ModuleSpi moduleInstance, EntityModel entityModel, EntityState entityState) {
        this.uow = uow;
        this.moduleInstance = moduleInstance;
        this.entityModel = entityModel;
        this.identity = entityState.identity();
        this.entityState = entityState;
        this.proxy = (EntityComposite)entityModel.newProxy((InvocationHandler)((Object)this));
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        return this.entityModel.invoke(this, this.proxy, method, args, this.moduleInstance);
    }

    public EntityReference identity() {
        return this.identity;
    }

    public <T> T proxy() {
        return (T)this.proxy;
    }

    public CompositeDescriptor descriptor() {
        return this.entityModel;
    }

    public <T> T newProxy(Class<T> mixinType) throws IllegalArgumentException {
        return this.entityModel.newProxy((InvocationHandler)((Object)this), mixinType);
    }

    public Object invokeComposite(Method method, Object[] args) throws Throwable {
        return this.entityModel.invoke(this, this.proxy, method, args, this.moduleInstance);
    }

    public <T> T metaInfo(Class<T> infoType) {
        return this.entityModel.metaInfo(infoType);
    }

    public EntityModel entityModel() {
        return this.entityModel;
    }

    public Iterable<Class<?>> types() {
        return this.entityModel.types();
    }

    public ModuleSpi module() {
        return this.moduleInstance;
    }

    public UnitOfWork unitOfWork() {
        return this.uow;
    }

    public EntityState entityState() {
        return this.entityState;
    }

    public EntityStateInstance state() {
        if (this.state == null) {
            this.initState();
        }
        return this.state;
    }

    public EntityStatus status() {
        return this.entityState.status();
    }

    @Override
    public Object invoke(Object composite, Object[] params, CompositeMethodInstance methodInstance) throws Throwable {
        Object mixin;
        if (this.mixins == null) {
            this.initState();
        }
        if ((mixin = methodInstance.getMixinFrom(this.mixins)) == null) {
            mixin = this.entityModel.newMixin(this.mixins, this.state, this, methodInstance.method());
        }
        return methodInstance.invoke(this.proxy, params, mixin);
    }

    @Override
    public Object invokeObject(Object proxy, Object[] args, Method method) throws Throwable {
        return method.invoke((Object)this, args);
    }

    private void initState() {
        if (!this.uow.isOpen()) {
            throw new UnitOfWorkException("Unit of work has been closed");
        }
        if (this.status() == EntityStatus.REMOVED) {
            throw new NoSuchEntityException(this.identity, this.entityModel.types(), this.unitOfWork().usecase());
        }
        this.mixins = this.entityModel.newMixinHolder();
        this.state = new EntityStateInstance(this.entityModel.state(), this.uow, this.entityState);
    }

    public int hashCode() {
        return this.identity.hashCode();
    }

    public boolean equals(Object o) {
        try {
            Identity other = (Identity)o;
            return other != null && ((String)other.identity().get()).equals(this.identity.identity());
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public String toString() {
        return this.identity.toString();
    }

    public void remove(UnitOfWork unitOfWork) throws LifecycleException {
        this.invokeRemove();
        this.removeAggregatedEntities(unitOfWork);
        this.entityState.remove();
        this.mixins = null;
    }

    public void invokeCreate() {
        this.lifecyleInvoke(true);
    }

    private void invokeRemove() {
        this.lifecyleInvoke(false);
    }

    private void lifecyleInvoke(boolean create) {
        if (this.mixins == null) {
            this.initState();
        }
        this.entityModel.invokeLifecycle(create, this.mixins, this, (StateHolder)this.state);
    }

    private void removeAggregatedEntities(UnitOfWork unitOfWork) {
        EntityStateModel stateDescriptor = this.entityModel.state();
        HashSet<Object> aggregatedEntities = new HashSet<Object>();
        Iterable associations = stateDescriptor.associations();
        for (AssociationDescriptor association : associations) {
            Association assoc;
            Object aggregatedEntity;
            if (!association.isAggregated() || (aggregatedEntity = (assoc = this.state.associationFor(association.accessor())).get()) == null) continue;
            aggregatedEntities.add(aggregatedEntity);
        }
        Iterable manyAssociations = stateDescriptor.manyAssociations();
        for (AssociationDescriptor association : manyAssociations) {
            if (!association.isAggregated()) continue;
            ManyAssociation manyAssoc = this.state.manyAssociationFor(association.accessor());
            for (Object entity : manyAssoc) {
                aggregatedEntities.add(entity);
            }
        }
        Iterable namedAssociations = stateDescriptor.namedAssociations();
        for (AssociationDescriptor association : namedAssociations) {
            if (!association.isAggregated()) continue;
            NamedAssociation namedAssoc = this.state.namedAssociationFor(association.accessor());
            for (String name : namedAssoc) {
                aggregatedEntities.add(namedAssoc.get(name));
            }
        }
        for (Object aggregatedEntity : aggregatedEntities) {
            unitOfWork.remove(aggregatedEntity);
        }
    }

    public void checkConstraints() {
        try {
            this.state.checkConstraints();
        }
        catch (ConstraintViolationException e) {
            throw new ConstraintViolationException(this.identity.identity(), this.entityModel.types(), e.mixinTypeName(), e.methodName(), e.constraintViolations());
        }
    }
}

