/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.runtime.injection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.List;
import org.qi4j.api.injection.InjectionScope;
import org.qi4j.api.util.Annotations;
import org.qi4j.api.util.Classes;
import org.qi4j.api.util.Fields;
import org.qi4j.functional.Function;
import org.qi4j.functional.HierarchicalVisitor;
import org.qi4j.functional.Iterables;
import org.qi4j.functional.Specification;
import org.qi4j.functional.Specifications;
import org.qi4j.functional.VisitableHierarchy;
import org.qi4j.runtime.injection.Dependencies;
import org.qi4j.runtime.injection.DependencyModel;
import org.qi4j.runtime.injection.InjectedFieldModel;
import org.qi4j.runtime.injection.InjectionContext;
import org.qi4j.runtime.injection.ParameterizedTypeInstance;

public final class InjectedFieldsModel
implements Dependencies,
VisitableHierarchy<Object, Object> {
    private final List<InjectedFieldModel> fields = new ArrayList<InjectedFieldModel>();

    public InjectedFieldsModel(Class fragmentClass) {
        Iterable mappedFields = (Iterable)Fields.FIELDS_OF.map((Object)fragmentClass);
        for (Field field : mappedFields) {
            Annotation injectionAnnotation = (Annotation)Iterables.first((Iterable)Iterables.filter((Specification)Specifications.translate((Function)Annotations.type(), (Specification)Annotations.hasAnnotation(InjectionScope.class)), (Iterable)Iterables.iterable((Object[])field.getAnnotations())));
            if (injectionAnnotation == null) continue;
            this.addModel(fragmentClass, field, injectionAnnotation);
        }
    }

    private void addModel(Class fragmentClass, Field field, Annotation injectionAnnotation) {
        Type genericType = field.getGenericType();
        if (genericType instanceof ParameterizedType) {
            genericType = new ParameterizedTypeInstance(((ParameterizedType)genericType).getActualTypeArguments(), ((ParameterizedType)genericType).getRawType(), ((ParameterizedType)genericType).getOwnerType());
            for (int i = 0; i < ((ParameterizedType)genericType).getActualTypeArguments().length; ++i) {
                Type type = ((ParameterizedType)genericType).getActualTypeArguments()[i];
                if (!(type instanceof TypeVariable)) continue;
                ((ParameterizedType)genericType).getActualTypeArguments()[i] = type = Classes.resolveTypeVariable((TypeVariable)((TypeVariable)type), field.getDeclaringClass(), (Class)fragmentClass);
            }
        }
        boolean optional = DependencyModel.isOptional(injectionAnnotation, field.getAnnotations());
        DependencyModel dependencyModel = new DependencyModel(injectionAnnotation, genericType, fragmentClass, optional, field.getAnnotations());
        InjectedFieldModel injectedFieldModel = new InjectedFieldModel(field, dependencyModel);
        this.fields.add(injectedFieldModel);
    }

    @Override
    public Iterable<DependencyModel> dependencies() {
        return Iterables.map((Function)new Function<InjectedFieldModel, DependencyModel>(){

            public DependencyModel map(InjectedFieldModel injectedFieldModel) {
                return injectedFieldModel.dependency();
            }
        }, this.fields);
    }

    public <ThrowableType extends Throwable> boolean accept(HierarchicalVisitor<? super Object, ? super Object, ThrowableType> modelVisitor) throws ThrowableType {
        block1: {
            if (!modelVisitor.visitEnter((Object)this)) break block1;
            for (InjectedFieldModel field : this.fields) {
                if (!field.accept(modelVisitor)) break;
            }
        }
        return modelVisitor.visitLeave((Object)this);
    }

    public void inject(InjectionContext context, Object instance) {
        for (InjectedFieldModel field : this.fields) {
            field.inject(context, instance);
        }
    }
}

