/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.runtime.injection;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.qi4j.api.composite.InjectedMethodDescriptor;
import org.qi4j.bootstrap.InjectionException;
import org.qi4j.functional.HierarchicalVisitor;
import org.qi4j.functional.VisitableHierarchy;
import org.qi4j.runtime.injection.Dependencies;
import org.qi4j.runtime.injection.DependencyModel;
import org.qi4j.runtime.injection.InjectedParametersModel;
import org.qi4j.runtime.injection.InjectionContext;

public final class InjectedMethodModel
implements InjectedMethodDescriptor,
Dependencies,
VisitableHierarchy<Object, Object> {
    private Method method;
    private InjectedParametersModel parameters;

    public InjectedMethodModel(Method method, InjectedParametersModel parameters) {
        this.method = method;
        this.method.setAccessible(true);
        this.parameters = parameters;
    }

    public Method method() {
        return this.method;
    }

    @Override
    public Iterable<DependencyModel> dependencies() {
        return this.parameters.dependencies();
    }

    public void inject(InjectionContext context, Object instance) throws InjectionException {
        Object[] params = this.parameters.newParametersInstance(context);
        try {
            if (!this.method.isAccessible()) {
                this.method.setAccessible(true);
            }
            this.method.invoke(instance, params);
        }
        catch (IllegalAccessException e) {
            throw new InjectionException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new InjectionException(e.getTargetException());
        }
    }

    public <ThrowableType extends Throwable> boolean accept(HierarchicalVisitor<? super Object, ? super Object, ThrowableType> visitor) throws ThrowableType {
        if (visitor.visitEnter((Object)this)) {
            this.parameters.accept(visitor);
        }
        return visitor.visitLeave((Object)this);
    }
}

