/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.runtime.injection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.List;
import org.qi4j.api.injection.InjectionScope;
import org.qi4j.api.util.Annotations;
import org.qi4j.api.util.Classes;
import org.qi4j.api.util.Methods;
import org.qi4j.functional.Function;
import org.qi4j.functional.HierarchicalVisitor;
import org.qi4j.functional.Iterables;
import org.qi4j.functional.Specification;
import org.qi4j.functional.Specifications;
import org.qi4j.functional.VisitableHierarchy;
import org.qi4j.runtime.injection.Dependencies;
import org.qi4j.runtime.injection.DependencyModel;
import org.qi4j.runtime.injection.InjectedMethodModel;
import org.qi4j.runtime.injection.InjectedParametersModel;
import org.qi4j.runtime.injection.InjectionContext;
import org.qi4j.runtime.injection.ParameterizedTypeInstance;

public final class InjectedMethodsModel
implements Dependencies,
VisitableHierarchy<Object, Object> {
    private final List<InjectedMethodModel> methodModels = new ArrayList<InjectedMethodModel>();

    public InjectedMethodsModel(Class fragmentClass) {
        block0: for (Method method : (Iterable)Methods.METHODS_OF.map((Object)fragmentClass)) {
            Annotation[][] parameterAnnotations = method.getParameterAnnotations();
            if (parameterAnnotations.length <= 0) continue;
            InjectedParametersModel parametersModel = new InjectedParametersModel();
            Type[] genericParameterTypes = method.getGenericParameterTypes();
            for (int i = 0; i < parameterAnnotations.length; ++i) {
                Annotation injectionAnnotation = (Annotation)Iterables.first((Iterable)Iterables.filter((Specification)Specifications.translate((Function)Annotations.type(), (Specification)Annotations.hasAnnotation(InjectionScope.class)), (Iterable)Iterables.iterable((Object[])parameterAnnotations[i])));
                if (injectionAnnotation == null) continue block0;
                Type genericType = genericParameterTypes[i];
                if (genericType instanceof ParameterizedType) {
                    genericType = new ParameterizedTypeInstance(((ParameterizedType)genericType).getActualTypeArguments(), ((ParameterizedType)genericType).getRawType(), ((ParameterizedType)genericType).getOwnerType());
                    for (int j = 0; j < ((ParameterizedType)genericType).getActualTypeArguments().length; ++j) {
                        Type type = ((ParameterizedType)genericType).getActualTypeArguments()[j];
                        if (!(type instanceof TypeVariable)) continue;
                        ((ParameterizedType)genericType).getActualTypeArguments()[j] = type = Classes.resolveTypeVariable((TypeVariable)((TypeVariable)type), method.getDeclaringClass(), (Class)fragmentClass);
                    }
                }
                boolean optional = DependencyModel.isOptional(injectionAnnotation, parameterAnnotations[i]);
                DependencyModel dependencyModel = new DependencyModel(injectionAnnotation, genericType, fragmentClass, optional, parameterAnnotations[i]);
                parametersModel.addDependency(dependencyModel);
            }
            InjectedMethodModel methodModel = new InjectedMethodModel(method, parametersModel);
            this.methodModels.add(methodModel);
        }
    }

    @Override
    public Iterable<DependencyModel> dependencies() {
        return Iterables.flattenIterables((Iterable)Iterables.map(Dependencies.DEPENDENCIES_FUNCTION, this.methodModels));
    }

    public void inject(InjectionContext context, Object instance) {
        for (InjectedMethodModel methodModel : this.methodModels) {
            methodModel.inject(context, instance);
        }
    }

    public <ThrowableType extends Throwable> boolean accept(HierarchicalVisitor<? super Object, ? super Object, ThrowableType> visitor) throws ThrowableType {
        block1: {
            if (!visitor.visitEnter((Object)this)) break block1;
            for (InjectedMethodModel methodModel : this.methodModels) {
                if (!methodModel.accept(visitor)) break;
            }
        }
        return visitor.visitLeave((Object)this);
    }
}

