/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.runtime.injection.provider;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.qi4j.api.service.NoSuchServiceException;
import org.qi4j.api.service.ServiceReference;
import org.qi4j.api.service.qualifier.AnnotationQualifier;
import org.qi4j.api.service.qualifier.Qualifier;
import org.qi4j.api.util.Annotations;
import org.qi4j.api.util.Classes;
import org.qi4j.bootstrap.InvalidInjectionException;
import org.qi4j.functional.Function;
import org.qi4j.functional.Iterables;
import org.qi4j.functional.Specification;
import org.qi4j.functional.Specifications;
import org.qi4j.runtime.injection.DependencyModel;
import org.qi4j.runtime.injection.InjectionContext;
import org.qi4j.runtime.injection.InjectionProvider;
import org.qi4j.runtime.injection.InjectionProviderFactory;
import org.qi4j.runtime.injection.provider.InjectionProviderException;
import org.qi4j.runtime.model.Resolution;

public final class ServiceInjectionProviderFactory
implements InjectionProviderFactory {
    @Override
    public InjectionProvider newInjectionProvider(Resolution resolution, DependencyModel dependencyModel) throws InvalidInjectionException {
        Annotation qualifierAnnotation = (Annotation)Iterables.first((Iterable)Iterables.filter((Specification)Specifications.translate((Function)Annotations.type(), (Specification)Annotations.hasAnnotation(Qualifier.class)), (Iterable)Iterables.iterable((Object[])dependencyModel.annotations())));
        Specification serviceQualifier = null;
        if (qualifierAnnotation != null) {
            Qualifier qualifier = qualifierAnnotation.annotationType().getAnnotation(Qualifier.class);
            try {
                serviceQualifier = ((AnnotationQualifier)qualifier.value().newInstance()).qualifier(qualifierAnnotation);
            }
            catch (Exception e) {
                throw new InvalidInjectionException("Could not instantiate qualifier serviceQualifier", (Throwable)e);
            }
        }
        if (dependencyModel.rawInjectionType().equals(Iterable.class)) {
            Type iterableType = ((ParameterizedType)dependencyModel.injectionType()).getActualTypeArguments()[0];
            if (((Class)Classes.RAW_CLASS.map((Object)iterableType)).equals(ServiceReference.class)) {
                Type serviceType = ((ParameterizedType)iterableType).getActualTypeArguments()[0];
                return new IterableServiceReferenceProvider(serviceType, serviceQualifier);
            }
            return new IterableServiceProvider(iterableType, serviceQualifier);
        }
        if (dependencyModel.rawInjectionType().equals(ServiceReference.class)) {
            Type referencedType = ((ParameterizedType)dependencyModel.injectionType()).getActualTypeArguments()[0];
            return new ServiceReferenceProvider(referencedType, serviceQualifier);
        }
        return new ServiceProvider(dependencyModel.injectionType(), serviceQualifier);
    }

    private static abstract class ServiceInjectionProvider
    implements InjectionProvider {
        private final Type serviceType;
        private final Specification<ServiceReference<?>> serviceQualifier;

        private ServiceInjectionProvider(Type serviceType, Specification<ServiceReference<?>> serviceQualifier) {
            this.serviceType = serviceType;
            this.serviceQualifier = serviceQualifier;
        }

        protected ServiceReference<Object> getServiceReference(InjectionContext context) {
            try {
                if (this.serviceQualifier == null) {
                    return context.module().findService(this.serviceType);
                }
                return (ServiceReference)Iterables.first((Iterable)Iterables.filter(this.serviceQualifier, (Iterable)context.module().findServices(this.serviceType)));
            }
            catch (NoSuchServiceException e) {
                return null;
            }
        }

        protected Iterable<ServiceReference<Object>> getServiceReferences(InjectionContext context) {
            if (this.serviceQualifier == null) {
                return context.module().findServices(this.serviceType);
            }
            return Iterables.filter(this.serviceQualifier, (Iterable)context.module().findServices(this.serviceType));
        }
    }

    private static class ServiceProvider
    extends ServiceInjectionProvider {
        ServiceProvider(Type serviceType, Specification<ServiceReference<?>> qualifier) {
            super(serviceType, qualifier);
        }

        @Override
        public synchronized Object provideInjection(InjectionContext context) throws InjectionProviderException {
            ServiceReference<Object> ref = this.getServiceReference(context);
            if (ref != null) {
                return ref.get();
            }
            return null;
        }
    }

    private static class ServiceReferenceProvider
    extends ServiceInjectionProvider {
        ServiceReferenceProvider(Type serviceType, Specification<ServiceReference<?>> qualifier) {
            super(serviceType, qualifier);
        }

        @Override
        public synchronized Object provideInjection(InjectionContext context) throws InjectionProviderException {
            return this.getServiceReference(context);
        }
    }

    private static class IterableServiceProvider
    extends ServiceInjectionProvider
    implements Function<ServiceReference<?>, Object> {
        private IterableServiceProvider(Type serviceType, Specification<ServiceReference<?>> serviceQualifier) {
            super(serviceType, serviceQualifier);
        }

        @Override
        public synchronized Object provideInjection(InjectionContext context) throws InjectionProviderException {
            return Iterables.map((Function)this, this.getServiceReferences(context));
        }

        public Object map(ServiceReference<?> objectServiceReference) {
            return objectServiceReference.get();
        }
    }

    private static class IterableServiceReferenceProvider
    extends ServiceInjectionProvider {
        private IterableServiceReferenceProvider(Type serviceType, Specification<ServiceReference<?>> serviceQualifier) {
            super(serviceType, serviceQualifier);
        }

        @Override
        public synchronized Object provideInjection(InjectionContext context) throws InjectionProviderException {
            return this.getServiceReferences(context);
        }
    }
}

