/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.runtime.injection.provider;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.qi4j.api.composite.CompositeDescriptor;
import org.qi4j.api.util.Classes;
import org.qi4j.bootstrap.InvalidInjectionException;
import org.qi4j.functional.Iterables;
import org.qi4j.runtime.composite.ProxyGenerator;
import org.qi4j.runtime.injection.DependencyModel;
import org.qi4j.runtime.injection.InjectionContext;
import org.qi4j.runtime.injection.InjectionProvider;
import org.qi4j.runtime.injection.InjectionProviderFactory;
import org.qi4j.runtime.injection.provider.InjectionProviderException;
import org.qi4j.runtime.model.Resolution;

public final class ThisInjectionProviderFactory
implements InjectionProviderFactory {
    @Override
    public InjectionProvider newInjectionProvider(Resolution bindingContext, DependencyModel dependencyModel) throws InvalidInjectionException {
        if (bindingContext.model() instanceof CompositeDescriptor) {
            Class<?> thisType = dependencyModel.rawInjectionType();
            Iterable injectionTypes = null;
            if (Classes.assignableTypeSpecification(thisType).satisfiedBy((Object)bindingContext.model())) {
                injectionTypes = bindingContext.model().types();
            } else {
                CompositeDescriptor acd = (CompositeDescriptor)bindingContext.model();
                for (Class mixinType : acd.mixinTypes()) {
                    Iterable iterable;
                    if (!thisType.isAssignableFrom(mixinType)) continue;
                    injectionTypes = iterable = Iterables.iterable((Object[])new Class[]{thisType});
                    break;
                }
                if (injectionTypes == null) {
                    throw new InvalidInjectionException("Composite " + bindingContext.model() + " does not implement @This type " + thisType.getName() + " in fragment " + dependencyModel.injectedClass().getName());
                }
            }
            return new ThisInjectionProvider(injectionTypes);
        }
        throw new InvalidInjectionException("Object " + dependencyModel.injectedClass() + " may not use @This");
    }

    private static class ThisInjectionProvider
    implements InjectionProvider {
        Constructor proxyConstructor;
        private Class[] interfaces;

        private ThisInjectionProvider(Iterable<Class<?>> types) {
            try {
                Class<?> proxyClass;
                if (Proxy.class.isAssignableFrom((Class)Iterables.first(types))) {
                    proxyClass = (Class<?>)Iterables.first(types);
                } else {
                    Class mainType = (Class)Iterables.first(types);
                    this.interfaces = (Class[])Iterables.toArray(Class.class, (Iterable)Iterables.cast(types));
                    proxyClass = ProxyGenerator.createProxyClass(mainType.getClassLoader(), this.interfaces);
                }
                this.proxyConstructor = proxyClass.getConstructor(InvocationHandler.class);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public Object provideInjection(InjectionContext context) {
            try {
                Object handler = context.compositeInstance();
                if (handler == null) {
                    handler = context.proxyHandler();
                }
                return this.proxyConstructor.newInstance(handler);
            }
            catch (Exception e) {
                throw new InjectionProviderException("Could not instantiate @This proxy", e);
            }
        }
    }
}

