/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.runtime.object;

import org.qi4j.api.common.ConstructionException;
import org.qi4j.api.common.MetaInfo;
import org.qi4j.api.common.Visibility;
import org.qi4j.api.mixin.Initializable;
import org.qi4j.api.mixin.InitializationException;
import org.qi4j.api.object.ObjectDescriptor;
import org.qi4j.functional.HierarchicalVisitor;
import org.qi4j.functional.Iterables;
import org.qi4j.functional.VisitableHierarchy;
import org.qi4j.runtime.composite.ConstructorsModel;
import org.qi4j.runtime.injection.InjectedFieldsModel;
import org.qi4j.runtime.injection.InjectedMethodsModel;
import org.qi4j.runtime.injection.InjectionContext;

public final class ObjectModel
implements ObjectDescriptor,
VisitableHierarchy<Object, Object> {
    private final Class<?> objectType;
    private final Visibility visibility;
    private final MetaInfo metaInfo;
    private final ConstructorsModel constructorsModel;
    private final InjectedFieldsModel injectedFieldsModel;
    private final InjectedMethodsModel injectedMethodsModel;

    public ObjectModel(Class<?> objectType, Visibility visibility, MetaInfo metaInfo) {
        this.objectType = objectType;
        this.visibility = visibility;
        this.metaInfo = metaInfo;
        this.constructorsModel = new ConstructorsModel(objectType);
        this.injectedFieldsModel = new InjectedFieldsModel(objectType);
        this.injectedMethodsModel = new InjectedMethodsModel(objectType);
    }

    public Iterable<Class<?>> types() {
        Iterable iterable = Iterables.iterable((Object[])new Class[]{this.objectType});
        return iterable;
    }

    public Visibility visibility() {
        return this.visibility;
    }

    public <T> T metaInfo(Class<T> infoType) {
        return (T)this.metaInfo.get(infoType);
    }

    public boolean isAssignableTo(Class<?> type) {
        return type.isAssignableFrom(this.objectType);
    }

    public <ThrowableType extends Throwable> boolean accept(HierarchicalVisitor<? super Object, ? super Object, ThrowableType> visitor) throws ThrowableType {
        if (visitor.visitEnter((Object)this) && this.constructorsModel.accept(visitor) && this.injectedFieldsModel.accept(visitor)) {
            this.injectedMethodsModel.accept(visitor);
        }
        return visitor.visitLeave((Object)this);
    }

    public Object newInstance(InjectionContext injectionContext) {
        Object instance;
        try {
            instance = this.constructorsModel.newInstance(injectionContext);
            injectionContext = new InjectionContext(injectionContext.module(), injectionContext.uses(), instance);
            this.injectedFieldsModel.inject(injectionContext, instance);
            this.injectedMethodsModel.inject(injectionContext, instance);
        }
        catch (Exception e) {
            throw new ConstructionException("Could not instantiate " + this.objectType.getName(), (Throwable)e);
        }
        if (instance instanceof Initializable) {
            try {
                ((Initializable)instance).initialize();
            }
            catch (InitializationException e) {
                throw new ConstructionException("Unable to initialize " + this.objectType, (Throwable)e);
            }
        }
        return instance;
    }

    public void inject(InjectionContext injectionContext, Object instance) {
        this.injectedFieldsModel.inject(injectionContext, instance);
        this.injectedMethodsModel.inject(injectionContext, instance);
    }

    public String toString() {
        return this.objectType.getName();
    }
}

