/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.runtime.property;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Member;
import java.util.LinkedHashMap;
import java.util.Map;
import org.qi4j.api.common.QualifiedName;
import org.qi4j.functional.HierarchicalVisitor;
import org.qi4j.functional.VisitableHierarchy;
import org.qi4j.runtime.property.PropertyModel;

public class PropertiesModel
implements VisitableHierarchy<Object, Object> {
    protected final Map<AccessibleObject, PropertyModel> mapAccessiblePropertyModel = new LinkedHashMap<AccessibleObject, PropertyModel>();

    public void addProperty(PropertyModel property) {
        this.mapAccessiblePropertyModel.put(property.accessor(), property);
    }

    public <ThrowableType extends Throwable> boolean accept(HierarchicalVisitor<? super Object, ? super Object, ThrowableType> visitor) throws ThrowableType {
        block1: {
            if (!visitor.visitEnter((Object)this)) break block1;
            for (PropertyModel propertyModel : this.mapAccessiblePropertyModel.values()) {
                if (!propertyModel.accept(visitor)) break;
            }
        }
        return visitor.visitLeave((Object)this);
    }

    public Iterable<PropertyModel> properties() {
        return this.mapAccessiblePropertyModel.values();
    }

    public PropertyModel getProperty(AccessibleObject accessor) {
        PropertyModel propertyModel = this.mapAccessiblePropertyModel.get(accessor);
        if (propertyModel == null) {
            throw new IllegalArgumentException("No property found with name: " + ((Member)((Object)accessor)).getName());
        }
        return propertyModel;
    }

    public PropertyModel getPropertyByName(String name) throws IllegalArgumentException {
        for (PropertyModel propertyModel : this.mapAccessiblePropertyModel.values()) {
            if (!propertyModel.qualifiedName().name().equals(name)) continue;
            return propertyModel;
        }
        throw new IllegalArgumentException("No property found with name: " + name);
    }

    public PropertyModel getPropertyByQualifiedName(QualifiedName name) throws IllegalArgumentException {
        for (PropertyModel propertyModel : this.mapAccessiblePropertyModel.values()) {
            if (!propertyModel.qualifiedName().equals((Object)name)) continue;
            return propertyModel;
        }
        throw new IllegalArgumentException("No property found with qualified name: " + name);
    }
}

