/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.runtime.query;

import org.qi4j.api.composite.Composite;
import org.qi4j.api.query.Query;
import org.qi4j.api.query.QueryBuilder;
import org.qi4j.api.query.QueryExpressions;
import org.qi4j.functional.Specification;
import org.qi4j.runtime.query.IterableQuerySource;
import org.qi4j.runtime.query.QueryImpl;
import org.qi4j.spi.query.EntityFinder;
import org.qi4j.spi.query.QueryBuilderSPI;
import org.qi4j.spi.query.QuerySource;

final class QueryBuilderImpl<T>
implements QueryBuilder<T>,
QueryBuilderSPI<T> {
    private final EntityFinder entityFinder;
    private final Class<T> resultType;
    private final Specification<Composite> whereClause;

    QueryBuilderImpl(EntityFinder entityFinder, Class<T> resultType, Specification<Composite> whereClause) {
        this.entityFinder = entityFinder;
        this.resultType = resultType;
        this.whereClause = whereClause;
    }

    public QueryBuilder<T> where(Specification<Composite> specification) {
        if (specification == null) {
            throw new IllegalArgumentException("Where clause cannot be null");
        }
        if (this.whereClause != null) {
            specification = QueryExpressions.and(this.whereClause, specification, (Specification[])new Specification[0]);
        }
        return new QueryBuilderImpl<T>(this.entityFinder, this.resultType, (Specification<Composite>)specification);
    }

    public Query<T> newQuery(Iterable<T> iterable) {
        return new QueryImpl<T>(this.resultType, this.whereClause, new IterableQuerySource(iterable));
    }

    public Query<T> newQuery(QuerySource querySource) {
        return new QueryImpl<T>(this.resultType, this.whereClause, querySource);
    }
}

