/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.runtime.query;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.qi4j.api.composite.Composite;
import org.qi4j.api.property.Property;
import org.qi4j.api.query.Query;
import org.qi4j.api.query.QueryExecutionException;
import org.qi4j.api.query.QueryExpressions;
import org.qi4j.api.query.grammar.OrderBy;
import org.qi4j.functional.Iterables;
import org.qi4j.functional.Specification;
import org.qi4j.spi.query.QuerySource;

class QueryImpl<T>
implements Query<T> {
    private static final long serialVersionUID = 1L;
    private final Class<T> resultType;
    private final Specification<Composite> whereClause;
    private QuerySource querySource;
    private Iterable<OrderBy> orderBySegments;
    private Integer firstResult;
    private Integer maxResults;
    private Map<String, Object> variables;

    QueryImpl(Class<T> resultType, Specification<Composite> whereClause, QuerySource querySource) {
        this.resultType = resultType;
        this.whereClause = whereClause;
        this.querySource = querySource;
    }

    public Query<T> orderBy(OrderBy ... segments) {
        this.orderBySegments = Iterables.iterable((Object[])segments);
        return this;
    }

    public Query<T> orderBy(Property<?> property, OrderBy.Order order) {
        this.orderBySegments = this.orderBySegments == null ? Iterables.iterable((Object[])new OrderBy[]{new OrderBy(QueryExpressions.property(property), order)}) : Iterables.append((Object)new OrderBy(QueryExpressions.property(property), order), this.orderBySegments);
        return this;
    }

    public Query<T> orderBy(Property<?> property) {
        this.orderBy(property, OrderBy.Order.ASCENDING);
        return this;
    }

    public Query<T> firstResult(int firstResult) {
        this.firstResult = firstResult;
        return this;
    }

    public Query<T> maxResults(int maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    public Query<T> setVariable(String name, Object value) {
        if (this.variables == null) {
            this.variables = new HashMap<String, Object>();
        }
        this.variables.put(name, value);
        return this;
    }

    public <V> V getVariable(String name) {
        if (this.variables == null) {
            return null;
        }
        return (V)this.variables.get(name);
    }

    public Class<T> resultType() {
        return this.resultType;
    }

    public T find() throws QueryExecutionException {
        return (T)this.querySource.find(this.resultType, this.whereClause, this.orderBySegments, this.firstResult, this.maxResults, this.variables);
    }

    public long count() throws QueryExecutionException {
        return this.querySource.count(this.resultType, this.whereClause, this.orderBySegments, this.firstResult, this.maxResults, this.variables);
    }

    public Iterator<T> iterator() {
        return this.querySource.iterator(this.resultType, this.whereClause, this.orderBySegments, this.firstResult, this.maxResults, this.variables);
    }

    public String toString() {
        return "Query{ FROM " + this.querySource + " WHERE " + this.whereClause + (this.orderBySegments != null ? " ORDER BY " + this.orderBySegments : "") + (this.firstResult != null ? " FIRST " + this.firstResult : "") + (this.maxResults != null ? " MAX " + this.maxResults : "") + " EXPECT " + this.resultType + (this.variables != null ? " WITH VARIABLES " + this.variables : "") + '}';
    }
}

