/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.runtime.service;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.HashMap;
import org.qi4j.api.common.MetaInfo;
import org.qi4j.api.common.Visibility;
import org.qi4j.api.configuration.Configuration;
import org.qi4j.api.entity.Identity;
import org.qi4j.api.injection.scope.This;
import org.qi4j.api.service.ServiceDescriptor;
import org.qi4j.api.structure.Module;
import org.qi4j.api.util.Classes;
import org.qi4j.functional.Function;
import org.qi4j.functional.HierarchicalVisitor;
import org.qi4j.functional.Iterables;
import org.qi4j.functional.Specification;
import org.qi4j.functional.Specifications;
import org.qi4j.runtime.activation.ActivatorsInstance;
import org.qi4j.runtime.activation.ActivatorsModel;
import org.qi4j.runtime.composite.CompositeMethodsModel;
import org.qi4j.runtime.composite.CompositeModel;
import org.qi4j.runtime.composite.MixinModel;
import org.qi4j.runtime.composite.MixinsModel;
import org.qi4j.runtime.composite.StateModel;
import org.qi4j.runtime.composite.TransientStateInstance;
import org.qi4j.runtime.composite.UsesInstance;
import org.qi4j.runtime.injection.DependencyModel;
import org.qi4j.runtime.injection.InjectionContext;
import org.qi4j.runtime.property.PropertyInstance;
import org.qi4j.runtime.property.PropertyModel;
import org.qi4j.runtime.service.ServiceInstance;
import org.qi4j.runtime.structure.ModuleInstance;

public final class ServiceModel
extends CompositeModel
implements ServiceDescriptor {
    private static Method identityMethod;
    private final String identity;
    private final boolean instantiateOnStartup;
    private final ActivatorsModel<?> activatorsModel;
    private final Class configurationType;

    public ServiceModel(Iterable<Class<?>> types, Visibility visibility, MetaInfo metaInfo, ActivatorsModel<?> activatorsModel, MixinsModel mixinsModel, StateModel stateModel, CompositeMethodsModel compositeMethodsModel, String identity, boolean instantiateOnStartup) {
        super(types, visibility, metaInfo, mixinsModel, stateModel, compositeMethodsModel);
        this.identity = identity;
        this.instantiateOnStartup = instantiateOnStartup;
        this.activatorsModel = activatorsModel;
        this.configurationType = this.calculateConfigurationType();
    }

    public boolean isInstantiateOnStartup() {
        return this.instantiateOnStartup;
    }

    public String identity() {
        return this.identity;
    }

    public ActivatorsInstance<?> newActivatorsInstance(Module module) throws Exception {
        return new ActivatorsInstance(this.activatorsModel.newInstances(module));
    }

    public <T> Class<T> configurationType() {
        return this.configurationType;
    }

    @Override
    public <ThrowableType extends Throwable> boolean accept(HierarchicalVisitor<? super Object, ? super Object, ThrowableType> visitor) throws ThrowableType {
        if (visitor.visitEnter((Object)this) && this.activatorsModel.accept(visitor) && this.compositeMethodsModel.accept(visitor) && this.stateModel.accept(visitor)) {
            this.mixinsModel.accept(visitor);
        }
        return visitor.visitLeave((Object)this);
    }

    public ServiceInstance newInstance(ModuleInstance module) {
        Object[] mixins = this.mixinsModel.newMixinHolder();
        HashMap properties = new HashMap();
        for (PropertyModel propertyModel : this.stateModel.properties()) {
            Object initialValue = propertyModel.initialValue(module);
            if (propertyModel.accessor().equals(identityMethod)) {
                initialValue = this.identity;
            }
            PropertyInstance<Object> property = new PropertyInstance<Object>(propertyModel, initialValue);
            properties.put(propertyModel.accessor(), property);
        }
        TransientStateInstance state = new TransientStateInstance(properties);
        ServiceInstance compositeInstance = new ServiceInstance(this, module, mixins, state);
        int i = 0;
        UsesInstance uses = UsesInstance.EMPTY_USES.use(this);
        InjectionContext injectionContext = new InjectionContext(compositeInstance, uses, state);
        for (MixinModel mixinModel : this.mixinsModel.mixinModels()) {
            mixins[i++] = mixinModel.newInstance(injectionContext);
        }
        return compositeInstance;
    }

    @Override
    public String toString() {
        return super.toString() + ":" + this.identity;
    }

    public Class calculateConfigurationType() {
        Class injectionClass = null;
        Iterable configurationThisDependencies = Iterables.filter((Specification)Specifications.and((Specification[])new Specification[]{Specifications.translate((Function)new DependencyModel.InjectionTypeFunction(), (Specification)Specifications.in((Object[])new Class[]{Configuration.class})), new DependencyModel.ScopeSpecification(This.class)}), this.dependencies());
        for (DependencyModel dependencyModel : configurationThisDependencies) {
            if (!dependencyModel.rawInjectionType().equals(Configuration.class) || !(dependencyModel.injectionType() instanceof ParameterizedType)) continue;
            Class type = (Class)Classes.RAW_CLASS.map((Object)((ParameterizedType)dependencyModel.injectionType()).getActualTypeArguments()[0]);
            if (injectionClass == null) {
                injectionClass = type;
                continue;
            }
            if (!injectionClass.isAssignableFrom(type)) continue;
            injectionClass = type;
        }
        return injectionClass;
    }

    static {
        try {
            identityMethod = Identity.class.getMethod("identity", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }
}

