/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.runtime.structure;

import java.util.ArrayList;
import java.util.List;
import org.qi4j.api.activation.ActivationEventListener;
import org.qi4j.api.activation.ActivationException;
import org.qi4j.api.activation.PassivationException;
import org.qi4j.api.common.Visibility;
import org.qi4j.api.composite.TransientDescriptor;
import org.qi4j.api.entity.EntityDescriptor;
import org.qi4j.api.object.ObjectDescriptor;
import org.qi4j.api.service.ServiceReference;
import org.qi4j.api.structure.Layer;
import org.qi4j.api.value.ValueDescriptor;
import org.qi4j.functional.Function;
import org.qi4j.functional.Iterables;
import org.qi4j.runtime.activation.ActivationDelegate;
import org.qi4j.runtime.structure.ApplicationInstance;
import org.qi4j.runtime.structure.LayerModel;
import org.qi4j.runtime.structure.ModuleInstance;
import org.qi4j.runtime.structure.UsedLayersInstance;
import org.qi4j.spi.module.ModelModule;

public class LayerInstance
implements Layer {
    private final LayerModel layerModel;
    private final ApplicationInstance applicationInstance;
    private final UsedLayersInstance usedLayersInstance;
    private final ActivationDelegate activation;
    private final List<ModuleInstance> moduleInstances;

    public LayerInstance(LayerModel model, ApplicationInstance applicationInstance, UsedLayersInstance usedLayersInstance) {
        this.layerModel = model;
        this.applicationInstance = applicationInstance;
        this.usedLayersInstance = usedLayersInstance;
        this.activation = new ActivationDelegate(this);
        this.moduleInstances = new ArrayList<ModuleInstance>();
    }

    public String toString() {
        return this.layerModel.toString();
    }

    public String name() {
        return this.layerModel.name();
    }

    public <T> T metaInfo(Class<T> infoType) {
        return this.layerModel.metaInfo(infoType);
    }

    public void activate() throws ActivationException {
        this.activation.activate(this.layerModel.newActivatorsInstance(), this.moduleInstances);
    }

    public void passivate() throws PassivationException {
        this.activation.passivate();
    }

    public void registerActivationEventListener(ActivationEventListener listener) {
        this.activation.registerActivationEventListener(listener);
    }

    public void deregisterActivationEventListener(ActivationEventListener listener) {
        this.activation.deregisterActivationEventListener(listener);
    }

    void addModule(ModuleInstance module) {
        module.registerActivationEventListener(this.activation);
        this.moduleInstances.add(module);
    }

    LayerModel model() {
        return this.layerModel;
    }

    public ApplicationInstance applicationInstance() {
        return this.applicationInstance;
    }

    UsedLayersInstance usedLayersInstance() {
        return this.usedLayersInstance;
    }

    Iterable<ModelModule<ObjectDescriptor>> visibleObjects(final Visibility visibility) {
        return Iterables.flattenIterables((Iterable)Iterables.map((Function)new Function<ModuleInstance, Iterable<ModelModule<ObjectDescriptor>>>(){

            public Iterable<ModelModule<ObjectDescriptor>> map(ModuleInstance moduleInstance) {
                return moduleInstance.visibleObjects(visibility);
            }
        }, this.moduleInstances));
    }

    Iterable<ModelModule<TransientDescriptor>> visibleTransients(final Visibility visibility) {
        return Iterables.flattenIterables((Iterable)Iterables.map((Function)new Function<ModuleInstance, Iterable<ModelModule<TransientDescriptor>>>(){

            public Iterable<ModelModule<TransientDescriptor>> map(ModuleInstance moduleInstance) {
                return moduleInstance.visibleTransients(visibility);
            }
        }, this.moduleInstances));
    }

    Iterable<ModelModule<EntityDescriptor>> visibleEntities(final Visibility visibility) {
        return Iterables.flattenIterables((Iterable)Iterables.map((Function)new Function<ModuleInstance, Iterable<ModelModule<EntityDescriptor>>>(){

            public Iterable<ModelModule<EntityDescriptor>> map(ModuleInstance moduleInstance) {
                return moduleInstance.visibleEntities(visibility);
            }
        }, this.moduleInstances));
    }

    Iterable<ModelModule<ValueDescriptor>> visibleValues(final Visibility visibility) {
        return Iterables.flattenIterables((Iterable)Iterables.map((Function)new Function<ModuleInstance, Iterable<ModelModule<ValueDescriptor>>>(){

            public Iterable<ModelModule<ValueDescriptor>> map(ModuleInstance moduleInstance) {
                return moduleInstance.visibleValues(visibility);
            }
        }, this.moduleInstances));
    }

    Iterable<ServiceReference<?>> visibleServices(final Visibility visibility) {
        return Iterables.flattenIterables((Iterable)Iterables.map((Function)new Function<ModuleInstance, Iterable<ServiceReference<?>>>(){

            public Iterable<ServiceReference<?>> map(ModuleInstance moduleInstance) {
                return moduleInstance.visibleServices(visibility);
            }
        }, this.moduleInstances));
    }

    ModuleInstance findModule(String moduleName) {
        for (ModuleInstance moduleInstance : this.moduleInstances) {
            if (!moduleInstance.model().name().equals(moduleName)) continue;
            return moduleInstance;
        }
        throw new IllegalArgumentException("No such module:" + moduleName);
    }
}

