/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.runtime.structure;

import java.util.List;
import org.qi4j.api.activation.ActivationException;
import org.qi4j.api.common.MetaInfo;
import org.qi4j.api.structure.Layer;
import org.qi4j.api.structure.LayerDescriptor;
import org.qi4j.functional.HierarchicalVisitor;
import org.qi4j.functional.VisitableHierarchy;
import org.qi4j.runtime.activation.ActivatorsInstance;
import org.qi4j.runtime.activation.ActivatorsModel;
import org.qi4j.runtime.structure.ApplicationInstance;
import org.qi4j.runtime.structure.LayerInstance;
import org.qi4j.runtime.structure.ModuleInstance;
import org.qi4j.runtime.structure.ModuleModel;
import org.qi4j.runtime.structure.UsedLayersInstance;
import org.qi4j.runtime.structure.UsedLayersModel;

public final class LayerModel
implements LayerDescriptor,
VisitableHierarchy<Object, Object> {
    private final String name;
    private final MetaInfo metaInfo;
    private final UsedLayersModel usedLayersModel;
    private final ActivatorsModel<Layer> activatorsModel;
    private final List<ModuleModel> modules;

    public LayerModel(String name, MetaInfo metaInfo, UsedLayersModel usedLayersModel, ActivatorsModel<Layer> activatorsModel, List<ModuleModel> modules) {
        this.name = name;
        this.metaInfo = metaInfo;
        this.usedLayersModel = usedLayersModel;
        this.activatorsModel = activatorsModel;
        this.modules = modules;
    }

    public String name() {
        return this.name;
    }

    public <T> T metaInfo(Class<T> infoType) {
        return (T)this.metaInfo.get(infoType);
    }

    public Iterable<ModuleModel> modules() {
        return this.modules;
    }

    public UsedLayersModel usedLayers() {
        return this.usedLayersModel;
    }

    public ActivatorsInstance<Layer> newActivatorsInstance() throws ActivationException {
        return new ActivatorsInstance<Layer>(this.activatorsModel.newInstances());
    }

    public <ThrowableType extends Throwable> boolean accept(HierarchicalVisitor<? super Object, ? super Object, ThrowableType> modelVisitor) throws ThrowableType {
        block1: {
            if (!modelVisitor.visitEnter((Object)this) || !this.activatorsModel.accept(modelVisitor)) break block1;
            for (ModuleModel module : this.modules) {
                if (!module.accept(modelVisitor)) break;
            }
        }
        return modelVisitor.visitLeave((Object)this);
    }

    public LayerInstance newInstance(ApplicationInstance applicationInstance, UsedLayersInstance usedLayerInstance) {
        LayerInstance layerInstance = new LayerInstance(this, applicationInstance, usedLayerInstance);
        for (ModuleModel module : this.modules) {
            ModuleInstance moduleInstance = module.newInstance(layerInstance);
            layerInstance.addModule(moduleInstance);
        }
        return layerInstance;
    }

    public String toString() {
        return this.name;
    }
}

