/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.runtime.structure;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import org.qi4j.api.activation.Activation;
import org.qi4j.api.activation.ActivationEventListener;
import org.qi4j.api.activation.ActivationEventListenerRegistration;
import org.qi4j.api.activation.ActivationException;
import org.qi4j.api.activation.PassivationException;
import org.qi4j.api.association.AssociationDescriptor;
import org.qi4j.api.common.ConstructionException;
import org.qi4j.api.common.Visibility;
import org.qi4j.api.composite.AmbiguousTypeException;
import org.qi4j.api.composite.NoSuchTransientException;
import org.qi4j.api.composite.TransientBuilder;
import org.qi4j.api.composite.TransientDescriptor;
import org.qi4j.api.entity.EntityComposite;
import org.qi4j.api.entity.EntityDescriptor;
import org.qi4j.api.entity.EntityReference;
import org.qi4j.api.entity.IdentityGenerator;
import org.qi4j.api.metrics.MetricsProvider;
import org.qi4j.api.object.NoSuchObjectException;
import org.qi4j.api.object.ObjectDescriptor;
import org.qi4j.api.property.PropertyDescriptor;
import org.qi4j.api.query.QueryBuilder;
import org.qi4j.api.query.QueryBuilderFactory;
import org.qi4j.api.service.NoSuchServiceException;
import org.qi4j.api.service.ServiceDescriptor;
import org.qi4j.api.service.ServiceFinder;
import org.qi4j.api.service.ServiceReference;
import org.qi4j.api.structure.Application;
import org.qi4j.api.structure.Module;
import org.qi4j.api.type.ValueType;
import org.qi4j.api.unitofwork.UnitOfWork;
import org.qi4j.api.unitofwork.UnitOfWorkException;
import org.qi4j.api.unitofwork.UnitOfWorkFactory;
import org.qi4j.api.usecase.Usecase;
import org.qi4j.api.util.Classes;
import org.qi4j.api.util.NullArgumentException;
import org.qi4j.api.value.NoSuchValueException;
import org.qi4j.api.value.ValueBuilder;
import org.qi4j.api.value.ValueComposite;
import org.qi4j.api.value.ValueDescriptor;
import org.qi4j.api.value.ValueSerialization;
import org.qi4j.api.value.ValueSerializationException;
import org.qi4j.functional.Function;
import org.qi4j.functional.Function2;
import org.qi4j.functional.Iterables;
import org.qi4j.functional.Specification;
import org.qi4j.functional.Specifications;
import org.qi4j.runtime.activation.ActivationDelegate;
import org.qi4j.runtime.composite.FunctionStateResolver;
import org.qi4j.runtime.composite.StateResolver;
import org.qi4j.runtime.composite.TransientBuilderInstance;
import org.qi4j.runtime.composite.TransientModel;
import org.qi4j.runtime.composite.TransientStateInstance;
import org.qi4j.runtime.composite.TransientsModel;
import org.qi4j.runtime.composite.UsesInstance;
import org.qi4j.runtime.entity.EntitiesModel;
import org.qi4j.runtime.entity.EntityInstance;
import org.qi4j.runtime.entity.EntityModel;
import org.qi4j.runtime.injection.InjectionContext;
import org.qi4j.runtime.object.ObjectModel;
import org.qi4j.runtime.object.ObjectsModel;
import org.qi4j.runtime.property.PropertyInstance;
import org.qi4j.runtime.property.PropertyModel;
import org.qi4j.runtime.query.QueryBuilderFactoryImpl;
import org.qi4j.runtime.service.ImportedServicesInstance;
import org.qi4j.runtime.service.ImportedServicesModel;
import org.qi4j.runtime.service.ServicesInstance;
import org.qi4j.runtime.service.ServicesModel;
import org.qi4j.runtime.structure.LayerInstance;
import org.qi4j.runtime.structure.ModuleModel;
import org.qi4j.runtime.structure.ModuleUnitOfWork;
import org.qi4j.runtime.structure.TypeLookup;
import org.qi4j.runtime.structure.VisibilitySpecification;
import org.qi4j.runtime.unitofwork.UnitOfWorkInstance;
import org.qi4j.runtime.value.ValueBuilderInstance;
import org.qi4j.runtime.value.ValueBuilderWithPrototype;
import org.qi4j.runtime.value.ValueBuilderWithState;
import org.qi4j.runtime.value.ValueInstance;
import org.qi4j.runtime.value.ValueModel;
import org.qi4j.runtime.value.ValuesModel;
import org.qi4j.spi.entitystore.EntityStore;
import org.qi4j.spi.metrics.MetricsProviderAdapter;
import org.qi4j.spi.module.ModelModule;
import org.qi4j.spi.module.ModuleSpi;
import org.qi4j.valueserialization.orgjson.OrgJsonValueSerialization;

public class ModuleInstance
implements Module,
ModuleSpi,
Activation {
    private final ModuleModel model;
    private final LayerInstance layer;
    private final TransientsModel transients;
    private final ValuesModel values;
    private final ObjectsModel objects;
    private final EntitiesModel entities;
    private final ServicesInstance services;
    private final ImportedServicesInstance importedServices;
    private final ActivationDelegate activation;
    private final TypeLookup typeLookup;
    private final QueryBuilderFactory queryBuilderFactory;
    private final ClassLoader classLoader;
    private final EntityFunction entityFunction;
    private EntityStore store;
    private IdentityGenerator generator;
    private ValueSerialization valueSerialization;
    private MetricsProvider metrics;

    public ModuleInstance(ModuleModel moduleModel, LayerInstance layerInstance, TransientsModel transientsModel, EntitiesModel entitiesModel, ObjectsModel objectsModel, ValuesModel valuesModel, ServicesModel servicesModel, ImportedServicesModel importedServicesModel) {
        this.model = moduleModel;
        this.layer = layerInstance;
        this.transients = transientsModel;
        this.values = valuesModel;
        this.objects = objectsModel;
        this.entities = entitiesModel;
        this.services = servicesModel.newInstance(this);
        this.importedServices = importedServicesModel.newInstance(this);
        this.activation = new ActivationDelegate(this);
        this.typeLookup = new TypeLookup(this);
        this.queryBuilderFactory = new QueryBuilderFactoryImpl((ServiceFinder)this);
        this.classLoader = new ModuleClassLoader(this, Thread.currentThread().getContextClassLoader());
        this.entityFunction = new EntityFunction((UnitOfWorkFactory)this);
        this.services.registerActivationEventListener(this.activation);
        this.importedServices.registerActivationEventListener(this.activation);
    }

    public String toString() {
        return this.model.toString();
    }

    public String name() {
        return this.model.name();
    }

    public ClassLoader classLoader() {
        return this.classLoader;
    }

    public EntityDescriptor entityDescriptor(String name) {
        try {
            Class<?> type = this.classLoader().loadClass(name);
            ModelModule<EntityModel> entityModel = this.typeLookup.lookupEntityModel(type);
            if (entityModel == null) {
                return null;
            }
            return (EntityDescriptor)entityModel.model();
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public ObjectDescriptor objectDescriptor(String typeName) {
        try {
            Class<?> type = this.classLoader().loadClass(typeName);
            ModelModule<ObjectModel> objectModel = this.typeLookup.lookupObjectModel(type);
            if (objectModel == null) {
                return null;
            }
            return (ObjectDescriptor)objectModel.model();
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public TransientDescriptor transientDescriptor(String name) {
        try {
            Class<?> type = this.classLoader().loadClass(name);
            ModelModule<TransientModel> transientModel = this.typeLookup.lookupTransientModel(type);
            if (transientModel == null) {
                return null;
            }
            return (TransientDescriptor)transientModel.model();
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public ValueDescriptor valueDescriptor(String name) {
        try {
            Class<?> type = this.classLoader().loadClass(name);
            ModelModule<ValueModel> valueModel = this.typeLookup.lookupValueModel(type);
            if (valueModel == null) {
                return null;
            }
            return (ValueDescriptor)valueModel.model();
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public <T> T metaInfo(Class<T> infoType) {
        return this.model.metaInfo(infoType);
    }

    public <T> T newObject(Class<T> mixinType, Object ... uses) throws NoSuchObjectException {
        NullArgumentException.validateNotNull((String)"mixinType", mixinType);
        ModelModule<ObjectModel> modelModule = this.typeLookup.lookupObjectModel(mixinType);
        if (modelModule == null) {
            throw new NoSuchObjectException(mixinType.getName(), this.name());
        }
        InjectionContext injectionContext = new InjectionContext(modelModule.module(), UsesInstance.EMPTY_USES.use(uses));
        return mixinType.cast(((ObjectModel)modelModule.model()).newInstance(injectionContext));
    }

    public void injectTo(Object instance, Object ... uses) throws ConstructionException {
        NullArgumentException.validateNotNull((String)"instance", (Object)instance);
        ModelModule<ObjectModel> modelModule = this.typeLookup.lookupObjectModel(instance.getClass());
        if (modelModule == null) {
            throw new NoSuchObjectException(instance.getClass().getName(), this.name());
        }
        InjectionContext injectionContext = new InjectionContext(modelModule.module(), UsesInstance.EMPTY_USES.use(uses));
        ((ObjectModel)modelModule.model()).inject(injectionContext, instance);
    }

    public <T> TransientBuilder<T> newTransientBuilder(Class<T> mixinType) throws NoSuchTransientException {
        NullArgumentException.validateNotNull((String)"mixinType", mixinType);
        ModelModule<TransientModel> modelModule = this.typeLookup.lookupTransientModel(mixinType);
        if (modelModule == null) {
            throw new NoSuchTransientException(mixinType.getName(), this.name());
        }
        HashMap properties = new HashMap();
        for (PropertyModel propertyModel : ((TransientModel)modelModule.model()).state().properties()) {
            PropertyInstance<Object> property = new PropertyInstance<Object>(propertyModel.getBuilderInfo(), propertyModel.initialValue((Module)modelModule.module()));
            properties.put(propertyModel.accessor(), property);
        }
        TransientStateInstance state = new TransientStateInstance(properties);
        return new TransientBuilderInstance(modelModule, state, UsesInstance.EMPTY_USES);
    }

    public <T> T newTransient(Class<T> mixinType, Object ... uses) throws NoSuchTransientException, ConstructionException {
        return (T)this.newTransientBuilder(mixinType).use(uses).newInstance();
    }

    public <T> T newValue(Class<T> mixinType) throws NoSuchValueException, ConstructionException {
        return (T)this.newValueBuilder(mixinType).newInstance();
    }

    public <T> ValueBuilder<T> newValueBuilder(Class<T> mixinType) throws NoSuchValueException {
        NullArgumentException.validateNotNull((String)"mixinType", mixinType);
        ModelModule<ValueModel> compositeModelModule = this.typeLookup.lookupValueModel(mixinType);
        if (compositeModelModule == null) {
            throw new NoSuchValueException(mixinType.getName(), this.name());
        }
        InitialStateResolver stateResolver = new InitialStateResolver((Module)compositeModelModule.module());
        return new ValueBuilderInstance(compositeModelModule, this, stateResolver);
    }

    public <T> ValueBuilder<T> newValueBuilderWithState(Class<T> mixinType, Function<PropertyDescriptor, Object> propertyFunction, Function<AssociationDescriptor, EntityReference> associationFunction, Function<AssociationDescriptor, Iterable<EntityReference>> manyAssociationFunction, Function<AssociationDescriptor, Map<String, EntityReference>> namedAssociationFunction) {
        NullArgumentException.validateNotNull((String)"propertyFunction", propertyFunction);
        NullArgumentException.validateNotNull((String)"associationFunction", associationFunction);
        NullArgumentException.validateNotNull((String)"manyAssociationFunction", manyAssociationFunction);
        NullArgumentException.validateNotNull((String)"namedAssociationFunction", namedAssociationFunction);
        ModelModule<ValueModel> compositeModelModule = this.typeLookup.lookupValueModel(mixinType);
        if (compositeModelModule == null) {
            throw new NoSuchValueException(mixinType.getName(), this.name());
        }
        FunctionStateResolver stateResolver = new FunctionStateResolver(propertyFunction, associationFunction, manyAssociationFunction, namedAssociationFunction);
        return new ValueBuilderWithState(compositeModelModule, this, stateResolver);
    }

    public <T> ValueBuilder<T> newValueBuilderWithPrototype(T prototype) {
        NullArgumentException.validateNotNull((String)"prototype", prototype);
        ValueInstance valueInstance = ValueInstance.valueInstanceOf((ValueComposite)prototype);
        Class valueType = (Class)Iterables.first(valueInstance.types());
        ModelModule<ValueModel> modelModule = this.typeLookup.lookupValueModel(valueType);
        if (modelModule == null) {
            throw new NoSuchValueException(valueType.getName(), this.name());
        }
        return new ValueBuilderWithPrototype<T>(modelModule, this, prototype);
    }

    public <T> T newValueFromSerializedState(Class<T> mixinType, String serializedState) throws NoSuchValueException, ConstructionException {
        NullArgumentException.validateNotNull((String)"mixinType", mixinType);
        ModelModule<ValueModel> modelModule = this.typeLookup.lookupValueModel(mixinType);
        if (modelModule == null) {
            throw new NoSuchValueException(mixinType.getName(), this.name());
        }
        try {
            return (T)this.valueSerialization().deserialize((ValueType)((ValueModel)modelModule.model()).valueType(), serializedState);
        }
        catch (ValueSerializationException ex) {
            throw new ConstructionException("Could not create value from serialized state", (Throwable)ex);
        }
    }

    public UnitOfWork newUnitOfWork() {
        return this.newUnitOfWork(Usecase.DEFAULT);
    }

    public UnitOfWork newUnitOfWork(long currentTime) {
        return this.newUnitOfWork(Usecase.DEFAULT, currentTime);
    }

    public UnitOfWork newUnitOfWork(Usecase usecase) {
        return this.newUnitOfWork(usecase == null ? Usecase.DEFAULT : usecase, System.currentTimeMillis());
    }

    public UnitOfWork newUnitOfWork(Usecase usecase, long currentTime) {
        UnitOfWorkInstance unitOfWorkInstance = new UnitOfWorkInstance(usecase, currentTime, this.metricsProvider());
        return new ModuleUnitOfWork(this, unitOfWorkInstance);
    }

    public boolean isUnitOfWorkActive() {
        Stack<UnitOfWorkInstance> stack = UnitOfWorkInstance.getCurrent();
        return !stack.isEmpty();
    }

    public UnitOfWork currentUnitOfWork() {
        Stack<UnitOfWorkInstance> stack = UnitOfWorkInstance.getCurrent();
        if (stack.size() == 0) {
            throw new IllegalStateException("No current UnitOfWork active");
        }
        return new ModuleUnitOfWork(this, stack.peek());
    }

    public UnitOfWork getUnitOfWork(EntityComposite entity) {
        EntityInstance instance = EntityInstance.entityInstanceOf(entity);
        return instance.unitOfWork();
    }

    public <T> QueryBuilder<T> newQueryBuilder(Class<T> resultType) {
        return this.queryBuilderFactory.newQueryBuilder(resultType);
    }

    public <T> ServiceReference<T> findService(Class<T> serviceType) {
        return this.typeLookup.lookupServiceReference(serviceType);
    }

    public <T> ServiceReference<T> findService(Type serviceType) {
        return this.typeLookup.lookupServiceReference(serviceType);
    }

    public <T> Iterable<ServiceReference<T>> findServices(Class<T> serviceType) {
        return this.typeLookup.lookupServiceReferences(serviceType);
    }

    public <T> Iterable<ServiceReference<T>> findServices(Type serviceType) {
        return this.typeLookup.lookupServiceReferences(serviceType);
    }

    public void activate() throws ActivationException {
        this.activation.activate(this.model.newActivatorsInstance(), Iterables.iterable((Object[])new ActivationEventListenerRegistration[]{this.services, this.importedServices}));
    }

    public void passivate() throws PassivationException {
        this.activation.passivate();
    }

    public void registerActivationEventListener(ActivationEventListener listener) {
        this.activation.registerActivationEventListener(listener);
    }

    public void deregisterActivationEventListener(ActivationEventListener listener) {
        this.activation.deregisterActivationEventListener(listener);
    }

    ModuleModel model() {
        return this.model;
    }

    public LayerInstance layerInstance() {
        return this.layer;
    }

    public TypeLookup typeLookup() {
        return this.typeLookup;
    }

    public Function2<EntityReference, Type, Object> getEntityFunction() {
        return this.entityFunction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityStore entityStore() {
        ModuleInstance moduleInstance = this;
        synchronized (moduleInstance) {
            if (this.store == null) {
                ServiceReference<EntityStore> service = this.findService(EntityStore.class);
                if (service == null) {
                    throw new UnitOfWorkException("No EntityStore service available in module " + this.name());
                }
                this.store = (EntityStore)service.get();
            }
        }
        return this.store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IdentityGenerator identityGenerator() {
        ModuleInstance moduleInstance = this;
        synchronized (moduleInstance) {
            if (this.generator == null) {
                ServiceReference<IdentityGenerator> service = this.findService(IdentityGenerator.class);
                this.generator = (IdentityGenerator)service.get();
            }
            return this.generator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValueSerialization valueSerialization() {
        ModuleInstance moduleInstance = this;
        synchronized (moduleInstance) {
            if (this.valueSerialization == null) {
                try {
                    ServiceReference<ValueSerialization> service = this.findService(ValueSerialization.class);
                    this.valueSerialization = (ValueSerialization)service.get();
                }
                catch (NoSuchServiceException e) {
                    this.valueSerialization = new OrgJsonValueSerialization((Application)this.layer.applicationInstance(), (Module)this, (Module)this);
                }
            }
        }
        return this.valueSerialization;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MetricsProvider metricsProvider() {
        ModuleInstance moduleInstance = this;
        synchronized (moduleInstance) {
            if (this.metrics == null) {
                try {
                    ServiceReference<MetricsProvider> service = this.findService(MetricsProvider.class);
                    this.metrics = (MetricsProvider)service.get();
                }
                catch (NoSuchServiceException e) {
                    this.metrics = new MetricsProviderAdapter();
                }
            }
        }
        return this.metrics;
    }

    public Iterable<ModelModule<ObjectDescriptor>> visibleObjects(Visibility visibility) {
        return Iterables.map((Function)ModelModule.modelModuleFunction((ModuleSpi)this), (Iterable)Iterables.filter((Specification)new VisibilitySpecification(visibility), this.objects.models()));
    }

    public Iterable<ModelModule<TransientDescriptor>> visibleTransients(Visibility visibility) {
        return Iterables.map((Function)ModelModule.modelModuleFunction((ModuleSpi)this), (Iterable)Iterables.filter((Specification)new VisibilitySpecification(visibility), this.transients.models()));
    }

    public Iterable<ModelModule<EntityDescriptor>> visibleEntities(Visibility visibility) {
        return Iterables.map((Function)ModelModule.modelModuleFunction((ModuleSpi)this), (Iterable)Iterables.filter((Specification)new VisibilitySpecification(visibility), this.entities.models()));
    }

    public Iterable<ModelModule<ValueDescriptor>> visibleValues(Visibility visibility) {
        return Iterables.map((Function)ModelModule.modelModuleFunction((ModuleSpi)this), (Iterable)Iterables.filter((Specification)new VisibilitySpecification(visibility), this.values.models()));
    }

    public Iterable<ServiceReference<?>> visibleServices(Visibility visibility) {
        return Iterables.flatten((Iterable[])new Iterable[]{this.services.visibleServices(visibility), this.importedServices.visibleServices(visibility)});
    }

    public Iterable<ModelModule<ValueDescriptor>> findVisibleValueTypes() {
        return Iterables.flatten((Iterable[])new Iterable[]{this.visibleValues(Visibility.module), this.layerInstance().visibleValues(Visibility.layer), this.layerInstance().visibleValues(Visibility.application), this.layerInstance().usedLayersInstance().visibleValues()});
    }

    public Iterable<ModelModule<EntityDescriptor>> findVisibleEntityTypes() {
        return Iterables.flatten((Iterable[])new Iterable[]{this.visibleEntities(Visibility.module), this.layerInstance().visibleEntities(Visibility.layer), this.layerInstance().visibleEntities(Visibility.application), this.layerInstance().usedLayersInstance().visibleEntities()});
    }

    public Iterable<ModelModule<TransientDescriptor>> findVisibleTransientTypes() {
        return Iterables.flatten((Iterable[])new Iterable[]{this.visibleTransients(Visibility.module), this.layerInstance().visibleTransients(Visibility.layer), this.layerInstance().visibleTransients(Visibility.application), this.layerInstance().usedLayersInstance().visibleTransients()});
    }

    public Iterable<ModelModule<ServiceDescriptor>> findVisibleServiceTypes() {
        return Iterables.flatten((Iterable[])new Iterable[]{this.visibleServices(Visibility.module), this.layerInstance().visibleServices(Visibility.layer), this.layerInstance().visibleServices(Visibility.application), this.layerInstance().usedLayersInstance().visibleServices()});
    }

    public Iterable<ModelModule<ObjectDescriptor>> findVisibleObjectTypes() {
        return Iterables.flatten((Iterable[])new Iterable[]{this.visibleObjects(Visibility.module), this.layerInstance().visibleObjects(Visibility.layer), this.layerInstance().visibleObjects(Visibility.application), this.layerInstance().usedLayersInstance().visibleObjects()});
    }

    private static class ModuleClassLoader
    extends ClassLoader {
        private final ModuleInstance moduleInstance;
        private final Map<String, Class<?>> classes = new ConcurrentHashMap();

        private ModuleClassLoader(ModuleInstance moduleInstance, ClassLoader classLoader) {
            super(classLoader);
            this.moduleInstance = moduleInstance;
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            Class clazz = this.classes.get(name);
            if (clazz == null) {
                Iterable usedLayersModels;
                Iterable flatten;
                Iterable layerModels;
                Iterable i;
                Specification modelTypeSpecification = Classes.modelTypeSpecification((String)name);
                Specification translate = Specifications.translate((Function)ModelModule.modelFunction(), (Specification)modelTypeSpecification);
                Iterable moduleModels = Iterables.filter((Specification)translate, (Iterable)(i = Iterables.cast((Iterable)Iterables.flatten((Iterable[])new Iterable[]{Iterables.cast(this.moduleInstance.visibleObjects(Visibility.module)), Iterables.cast(this.moduleInstance.visibleEntities(Visibility.module)), Iterables.cast(this.moduleInstance.visibleTransients(Visibility.module)), Iterables.cast(this.moduleInstance.visibleValues(Visibility.module))}))));
                Iterator iter = moduleModels.iterator();
                if (iter.hasNext()) {
                    clazz = (Class)Iterables.first((Iterable)((ModelModule)iter.next()).model().types());
                    if (iter.hasNext()) {
                        throw new ClassNotFoundException(name, (Throwable)new AmbiguousTypeException("More than one model matches the classname " + name + ":" + Iterables.toList((Iterable)moduleModels)));
                    }
                }
                if (clazz == null && (iter = (layerModels = Iterables.filter((Specification)translate, (Iterable)(flatten = Iterables.cast((Iterable)Iterables.flatten((Iterable[])new Iterable[]{Iterables.cast(this.moduleInstance.layerInstance().visibleObjects(Visibility.layer)), Iterables.cast(this.moduleInstance.layerInstance().visibleTransients(Visibility.layer)), Iterables.cast(this.moduleInstance.layerInstance().visibleEntities(Visibility.layer)), Iterables.cast(this.moduleInstance.layerInstance().visibleValues(Visibility.layer)), Iterables.cast(this.moduleInstance.layerInstance().visibleObjects(Visibility.application)), Iterables.cast(this.moduleInstance.layerInstance().visibleTransients(Visibility.application)), Iterables.cast(this.moduleInstance.layerInstance().visibleEntities(Visibility.application)), Iterables.cast(this.moduleInstance.layerInstance().visibleValues(Visibility.application))}))))).iterator()).hasNext()) {
                    clazz = (Class)Iterables.first((Iterable)((ModelModule)iter.next()).model().types());
                    if (iter.hasNext()) {
                        throw new ClassNotFoundException(name, (Throwable)new AmbiguousTypeException("More than one model matches the classname " + name + ":" + Iterables.toList((Iterable)layerModels)));
                    }
                }
                if (clazz == null && (iter = (usedLayersModels = Iterables.filter((Specification)translate, (Iterable)(flatten = Iterables.cast((Iterable)Iterables.flatten((Iterable[])new Iterable[]{Iterables.cast(this.moduleInstance.layerInstance().usedLayersInstance().visibleObjects()), Iterables.cast(this.moduleInstance.layerInstance().usedLayersInstance().visibleTransients()), Iterables.cast(this.moduleInstance.layerInstance().usedLayersInstance().visibleEntities()), Iterables.cast(this.moduleInstance.layerInstance().usedLayersInstance().visibleValues())}))))).iterator()).hasNext()) {
                    clazz = (Class)Iterables.first((Iterable)((ModelModule)iter.next()).model().types());
                    if (iter.hasNext()) {
                        throw new ClassNotFoundException(name, (Throwable)new AmbiguousTypeException("More than one model matches the classname " + name + ":" + Iterables.toList((Iterable)usedLayersModels)));
                    }
                }
                if (clazz == null) {
                    throw new ClassNotFoundException(name);
                }
                this.classes.put(name, clazz);
            }
            return clazz;
        }
    }

    private static class EntityFunction
    implements Function2<EntityReference, Type, Object> {
        private final UnitOfWorkFactory uowf;

        private EntityFunction(UnitOfWorkFactory uowf) {
            this.uowf = uowf;
        }

        public Object map(EntityReference entityReference, Type type) {
            return this.uowf.currentUnitOfWork().get((Class)Classes.RAW_CLASS.map((Object)type), entityReference.identity());
        }
    }

    private static class InitialStateResolver
    implements StateResolver {
        private final Module module;

        private InitialStateResolver(Module module) {
            this.module = module;
        }

        @Override
        public Object getPropertyState(PropertyDescriptor propertyDescriptor) {
            return propertyDescriptor.initialValue(this.module);
        }

        @Override
        public EntityReference getAssociationState(AssociationDescriptor associationDescriptor) {
            return null;
        }

        @Override
        public List<EntityReference> getManyAssociationState(AssociationDescriptor associationDescriptor) {
            return new ArrayList<EntityReference>();
        }

        @Override
        public Map<String, EntityReference> getNamedAssociationState(AssociationDescriptor associationDescriptor) {
            return new HashMap<String, EntityReference>();
        }
    }
}

