/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.runtime.types;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import org.qi4j.api.common.InvalidApplicationException;
import org.qi4j.api.common.MetaInfo;
import org.qi4j.api.common.Visibility;
import org.qi4j.api.type.CollectionType;
import org.qi4j.api.type.EnumType;
import org.qi4j.api.type.MapType;
import org.qi4j.api.type.Serialization;
import org.qi4j.api.type.ValueCompositeType;
import org.qi4j.api.type.ValueType;
import org.qi4j.api.util.Classes;
import org.qi4j.api.value.ValueComposite;
import org.qi4j.functional.HierarchicalVisitorAdapter;
import org.qi4j.functional.Iterables;
import org.qi4j.functional.Specifications;
import org.qi4j.runtime.association.AssociationsModel;
import org.qi4j.runtime.association.ManyAssociationsModel;
import org.qi4j.runtime.association.NamedAssociationsModel;
import org.qi4j.runtime.composite.CompositeMethodsModel;
import org.qi4j.runtime.composite.MixinsModel;
import org.qi4j.runtime.property.PropertiesModel;
import org.qi4j.runtime.structure.LayerModel;
import org.qi4j.runtime.structure.ModuleModel;
import org.qi4j.runtime.structure.UsedLayersModel;
import org.qi4j.runtime.value.ValueModel;
import org.qi4j.runtime.value.ValueStateModel;
import org.qi4j.runtime.value.ValuesModel;

public class ValueTypeFactory {
    private static final ValueTypeFactory instance = new ValueTypeFactory();

    public static ValueTypeFactory instance() {
        return instance;
    }

    public ValueType newValueType(Type type, Class declaringClass, Class compositeType, LayerModel layer, ModuleModel module, Serialization.Variant variant) {
        Object valueType = null;
        if (CollectionType.isCollection((Type)type)) {
            if (type instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)type;
                Type collectionType = pt.getActualTypeArguments()[0];
                if (collectionType instanceof TypeVariable) {
                    TypeVariable collectionTypeVariable = (TypeVariable)collectionType;
                    collectionType = Classes.resolveTypeVariable((TypeVariable)collectionTypeVariable, (Class)declaringClass, (Class)compositeType);
                }
                ValueType collectedType = this.newValueType(collectionType, declaringClass, compositeType, layer, module, variant);
                valueType = new CollectionType((Class)Classes.RAW_CLASS.map((Object)type), collectedType);
            } else {
                ValueType collectedType = this.newValueType((Type)((Object)Object.class), declaringClass, compositeType, layer, module, variant);
                valueType = new CollectionType((Class)Classes.RAW_CLASS.map((Object)type), collectedType);
            }
        } else if (MapType.isMap((Type)type)) {
            if (type instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)type;
                Type keyType = pt.getActualTypeArguments()[0];
                if (keyType instanceof TypeVariable) {
                    TypeVariable keyTypeVariable = (TypeVariable)keyType;
                    keyType = Classes.resolveTypeVariable((TypeVariable)keyTypeVariable, (Class)declaringClass, (Class)compositeType);
                }
                ValueType keyedType = this.newValueType(keyType, declaringClass, compositeType, layer, module, variant);
                Type valType = pt.getActualTypeArguments()[1];
                if (valType instanceof TypeVariable) {
                    TypeVariable valueTypeVariable = (TypeVariable)valType;
                    valType = Classes.resolveTypeVariable((TypeVariable)valueTypeVariable, (Class)declaringClass, (Class)compositeType);
                }
                ValueType valuedType = this.newValueType(valType, declaringClass, compositeType, layer, module, variant);
                valueType = new MapType((Class)Classes.RAW_CLASS.map((Object)type), keyedType, valuedType, variant);
            } else {
                ValueType keyType = this.newValueType((Type)((Object)Object.class), declaringClass, compositeType, layer, module, variant);
                ValueType valuesType = this.newValueType((Type)((Object)Object.class), declaringClass, compositeType, layer, module, variant);
                valueType = new MapType((Class)Classes.RAW_CLASS.map((Object)type), keyType, valuesType, variant);
            }
        } else {
            if (ValueCompositeType.isValueComposite((Type)type)) {
                ValueModel model = new ValueFinder(layer, module, (Class)Classes.RAW_CLASS.map((Object)type)).getFoundModel();
                if (model == null) {
                    if (type.equals(ValueComposite.class)) {
                        MixinsModel mixinsModel = new MixinsModel();
                        Iterable valueComposite = Iterables.iterable((Object[])new Class[]{ValueComposite.class});
                        ValueStateModel valueStateModel = new ValueStateModel(new PropertiesModel(), new AssociationsModel(), new ManyAssociationsModel(), new NamedAssociationsModel());
                        model = new ValueModel(valueComposite, Visibility.application, new MetaInfo(), mixinsModel, valueStateModel, new CompositeMethodsModel(mixinsModel));
                    } else {
                        throw new InvalidApplicationException("[" + module.name() + "] Could not find ValueComposite of type " + type);
                    }
                }
                return model.valueType();
            }
            valueType = EnumType.isEnum((Type)type) ? new EnumType((Class)Classes.RAW_CLASS.map((Object)type)) : new ValueType((Class)Classes.RAW_CLASS.map((Object)type));
        }
        return valueType;
    }

    private static class ValueFinder
    extends HierarchicalVisitorAdapter<Object, Object, RuntimeException> {
        private Class type;
        private ValueModel foundModel;
        private Visibility visibility;

        private ValueFinder(LayerModel layer, ModuleModel module, Class type) {
            this.type = type;
            this.visibility = Visibility.module;
            module.accept(this);
            if (this.foundModel == null) {
                this.visibility = Visibility.layer;
                layer.accept(this);
                if (this.foundModel == null) {
                    this.visibility = Visibility.application;
                    layer.usedLayers().accept(this);
                }
            }
        }

        public ValueModel getFoundModel() {
            return this.foundModel;
        }

        public boolean visitEnter(Object visited) throws RuntimeException {
            ValueModel valueModel;
            boolean typeEquality;
            if (visited instanceof ValuesModel) {
                return true;
            }
            if (visited instanceof ModuleModel) {
                return true;
            }
            if (visited instanceof LayerModel) {
                return true;
            }
            if (visited instanceof UsedLayersModel) {
                return true;
            }
            if (visited instanceof ValueModel && (typeEquality = Specifications.in((valueModel = (ValueModel)visited).types()).satisfiedBy((Object)this.type)) && valueModel.visibility().ordinal() >= this.visibility.ordinal()) {
                this.foundModel = valueModel;
            }
            return false;
        }

        public boolean visitLeave(Object visited) throws RuntimeException {
            return this.foundModel == null;
        }
    }
}

