/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.runtime.value;

import org.qi4j.api.association.AssociationStateHolder;
import org.qi4j.api.common.ConstructionException;
import org.qi4j.api.value.NoSuchValueException;
import org.qi4j.api.value.ValueBuilder;
import org.qi4j.functional.Iterables;
import org.qi4j.runtime.composite.StateResolver;
import org.qi4j.runtime.structure.ModuleInstance;
import org.qi4j.runtime.value.ValueBuilderWithPrototype;
import org.qi4j.runtime.value.ValueInstance;
import org.qi4j.runtime.value.ValueModel;
import org.qi4j.runtime.value.ValueStateInstance;
import org.qi4j.spi.module.ModelModule;

public final class ValueBuilderInstance<T>
implements ValueBuilder<T> {
    private final ModuleInstance currentModule;
    private final ValueInstance prototypeInstance;

    public ValueBuilderInstance(ModelModule<ValueModel> compositeModelModule, ModuleInstance currentModule, StateResolver stateResolver) {
        ValueStateInstance state = new ValueStateInstance(compositeModelModule, currentModule, stateResolver);
        this.prototypeInstance = ((ValueModel)compositeModelModule.model()).newValueInstance(compositeModelModule.module(), state);
        this.prototypeInstance.prepareToBuild();
        this.currentModule = currentModule;
    }

    public T prototype() {
        return this.prototypeInstance.proxy();
    }

    public AssociationStateHolder state() {
        return this.prototypeInstance.state();
    }

    public <K> K prototypeFor(Class<K> mixinType) {
        return this.prototypeInstance.newProxy(mixinType);
    }

    public T newInstance() throws ConstructionException {
        Class valueType = (Class)Iterables.first(this.prototypeInstance.types());
        ModelModule<ValueModel> valueModel = this.currentModule.typeLookup().lookupValueModel(valueType);
        if (valueModel == null) {
            throw new NoSuchValueException(valueType.getName(), this.currentModule.name());
        }
        return new ValueBuilderWithPrototype<T>(valueModel, this.currentModule, this.prototype()).newInstance();
    }
}

