/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.runtime.value;

import java.util.HashMap;
import java.util.Map;
import org.qi4j.api.association.AssociationDescriptor;
import org.qi4j.api.association.AssociationStateHolder;
import org.qi4j.api.association.NamedAssociation;
import org.qi4j.api.common.ConstructionException;
import org.qi4j.api.entity.EntityReference;
import org.qi4j.api.property.PropertyDescriptor;
import org.qi4j.api.property.StateHolder;
import org.qi4j.api.value.ValueBuilder;
import org.qi4j.api.value.ValueComposite;
import org.qi4j.functional.Function;
import org.qi4j.runtime.composite.FunctionStateResolver;
import org.qi4j.runtime.composite.MixinModel;
import org.qi4j.runtime.composite.MixinsModel;
import org.qi4j.runtime.composite.UsesInstance;
import org.qi4j.runtime.injection.InjectionContext;
import org.qi4j.runtime.structure.ModuleInstance;
import org.qi4j.runtime.value.ValueInstance;
import org.qi4j.runtime.value.ValueModel;
import org.qi4j.runtime.value.ValueStateInstance;
import org.qi4j.spi.module.ModelModule;
import org.qi4j.spi.module.ModuleSpi;

public class ValueBuilderWithPrototype<T>
implements ValueBuilder<T> {
    private ValueInstance prototypeInstance;
    private final ValueModel valueModel;

    public ValueBuilderWithPrototype(ModelModule<ValueModel> compositeModelModule, ModuleInstance currentModule, T prototype) {
        this.valueModel = (ValueModel)compositeModelModule.model();
        MixinsModel mixinsModel = this.valueModel.mixinsModel();
        Object[] mixins = mixinsModel.newMixinHolder();
        ValueStateInstance prototypeState = ValueInstance.valueInstanceOf((ValueComposite)prototype).state();
        FunctionStateResolver resolver = new FunctionStateResolver(new PropertyDescriptorFunction(prototypeState), new AssociationDescriptorEntityReferenceFunction(prototypeState), new AssociationDescriptorIterableFunction(prototypeState), new AssociationDescriptorMapFunction(prototypeState));
        ValueStateInstance state = new ValueStateInstance(compositeModelModule, currentModule, resolver);
        ValueInstance valueInstance = new ValueInstance(this.valueModel, (ModuleSpi)currentModule, mixins, state);
        int i = 0;
        InjectionContext injectionContext = new InjectionContext(valueInstance, UsesInstance.EMPTY_USES, (StateHolder)state);
        for (MixinModel mixinModel : mixinsModel.mixinModels()) {
            mixins[i++] = mixinModel.newInstance(injectionContext);
        }
        valueInstance.prepareToBuild();
        this.prototypeInstance = valueInstance;
    }

    public T prototype() {
        this.verifyUnderConstruction();
        return this.prototypeInstance.proxy();
    }

    public AssociationStateHolder state() {
        this.verifyUnderConstruction();
        return this.prototypeInstance.state();
    }

    public <K> K prototypeFor(Class<K> mixinType) {
        this.verifyUnderConstruction();
        return this.prototypeInstance.newProxy(mixinType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T newInstance() throws ConstructionException {
        this.verifyUnderConstruction();
        this.prototypeInstance.prepareBuilderState();
        this.valueModel.checkConstraints(this.prototypeInstance.state());
        try {
            Object t = this.prototypeInstance.proxy();
            return t;
        }
        finally {
            this.prototypeInstance = null;
        }
    }

    private void verifyUnderConstruction() {
        if (this.prototypeInstance == null) {
            throw new IllegalStateException("ValueBuilder instances cannot be reused");
        }
    }

    private static class AssociationDescriptorMapFunction
    implements Function<AssociationDescriptor, Map<String, EntityReference>> {
        private final ValueStateInstance prototypeState;

        public AssociationDescriptorMapFunction(ValueStateInstance prototypeState) {
            this.prototypeState = prototypeState;
        }

        public Map<String, EntityReference> map(AssociationDescriptor descriptor) {
            HashMap<String, EntityReference> result = new HashMap<String, EntityReference>();
            NamedAssociation namedAssociation = this.prototypeState.namedAssociationFor(descriptor.accessor());
            for (String name : namedAssociation) {
                result.put(name, namedAssociation.referenceOf(name));
            }
            return result;
        }
    }

    private static class AssociationDescriptorIterableFunction
    implements Function<AssociationDescriptor, Iterable<EntityReference>> {
        private final ValueStateInstance prototypeState;

        public AssociationDescriptorIterableFunction(ValueStateInstance prototypeState) {
            this.prototypeState = prototypeState;
        }

        public Iterable<EntityReference> map(AssociationDescriptor descriptor) {
            return this.prototypeState.manyAssociationFor(descriptor.accessor()).references();
        }
    }

    private static class AssociationDescriptorEntityReferenceFunction
    implements Function<AssociationDescriptor, EntityReference> {
        private final ValueStateInstance prototypeState;

        public AssociationDescriptorEntityReferenceFunction(ValueStateInstance prototypeState) {
            this.prototypeState = prototypeState;
        }

        public EntityReference map(AssociationDescriptor descriptor) {
            return this.prototypeState.associationFor(descriptor.accessor()).reference();
        }
    }

    private static class PropertyDescriptorFunction
    implements Function<PropertyDescriptor, Object> {
        private final ValueStateInstance prototypeState;

        public PropertyDescriptorFunction(ValueStateInstance prototypeState) {
            this.prototypeState = prototypeState;
        }

        public Object map(PropertyDescriptor descriptor) {
            return this.prototypeState.propertyFor(descriptor.accessor()).get();
        }
    }
}

