/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.runtime.value;

import java.lang.reflect.AccessibleObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.qi4j.api.association.AssociationDescriptor;
import org.qi4j.api.association.AssociationStateHolder;
import org.qi4j.api.entity.EntityReference;
import org.qi4j.api.property.PropertyDescriptor;
import org.qi4j.runtime.association.AbstractAssociationInstance;
import org.qi4j.runtime.association.AssociationInfo;
import org.qi4j.runtime.association.AssociationInstance;
import org.qi4j.runtime.association.AssociationModel;
import org.qi4j.runtime.association.ManyAssociationInstance;
import org.qi4j.runtime.association.ManyAssociationModel;
import org.qi4j.runtime.association.NamedAssociationInstance;
import org.qi4j.runtime.association.NamedAssociationModel;
import org.qi4j.runtime.composite.ConstraintsCheck;
import org.qi4j.runtime.composite.StateResolver;
import org.qi4j.runtime.property.PropertyInfo;
import org.qi4j.runtime.property.PropertyInstance;
import org.qi4j.runtime.property.PropertyModel;
import org.qi4j.runtime.structure.ModuleInstance;
import org.qi4j.runtime.value.ManyAssociationValueState;
import org.qi4j.runtime.value.NamedAssociationValueState;
import org.qi4j.runtime.value.ReferenceProperty;
import org.qi4j.runtime.value.ValueModel;
import org.qi4j.spi.module.ModelModule;

public final class ValueStateInstance
implements AssociationStateHolder {
    private final Map<AccessibleObject, PropertyInstance<?>> properties;
    private final Map<AccessibleObject, AssociationInstance<?>> associations;
    private final Map<AccessibleObject, ManyAssociationInstance<?>> manyAssociations;
    private final Map<AccessibleObject, NamedAssociationInstance<?>> namedAssociations;

    public ValueStateInstance(Map<AccessibleObject, PropertyInstance<?>> properties, Map<AccessibleObject, AssociationInstance<?>> associations, Map<AccessibleObject, ManyAssociationInstance<?>> manyAssociations, Map<AccessibleObject, NamedAssociationInstance<?>> namedAssociations) {
        this.properties = properties;
        this.associations = associations;
        this.manyAssociations = manyAssociations;
        this.namedAssociations = namedAssociations;
    }

    public ValueStateInstance(ModelModule<ValueModel> compositeModelModule, ModuleInstance currentModule, StateResolver stateResolver) {
        AbstractAssociationInstance associationInstance;
        Object value;
        ConstraintsCheck builderInfo;
        ValueModel valueModel = (ValueModel)compositeModelModule.model();
        this.properties = new LinkedHashMap();
        for (PropertyDescriptor propertyDescriptor : valueModel.state().properties()) {
            builderInfo = ((PropertyModel)propertyDescriptor).getBuilderInfo();
            value = stateResolver.getPropertyState(propertyDescriptor);
            PropertyInstance<Object> propertyInstance = new PropertyInstance<Object>((PropertyInfo)builderInfo, value);
            this.properties.put(propertyDescriptor.accessor(), propertyInstance);
        }
        this.associations = new LinkedHashMap();
        for (AssociationDescriptor associationDescriptor : valueModel.state().associations()) {
            builderInfo = ((AssociationModel)associationDescriptor).getBuilderInfo();
            value = stateResolver.getAssociationState(associationDescriptor);
            AssociationInstance associationInstance1 = new AssociationInstance((AssociationInfo)builderInfo, currentModule.getEntityFunction(), new ReferenceProperty((EntityReference)value));
            this.associations.put(associationDescriptor.accessor(), associationInstance1);
        }
        this.manyAssociations = new LinkedHashMap();
        for (AssociationDescriptor associationDescriptor : valueModel.state().manyAssociations()) {
            builderInfo = ((ManyAssociationModel)associationDescriptor).getBuilderInfo();
            value = stateResolver.getManyAssociationState(associationDescriptor);
            ManyAssociationValueState manyAssociationState = new ManyAssociationValueState((List<EntityReference>)value);
            associationInstance = new ManyAssociationInstance((AssociationInfo)builderInfo, currentModule.getEntityFunction(), manyAssociationState);
            this.manyAssociations.put(associationDescriptor.accessor(), (ManyAssociationInstance<?>)associationInstance);
        }
        this.namedAssociations = new LinkedHashMap();
        for (AssociationDescriptor associationDescriptor : valueModel.state().namedAssociations()) {
            builderInfo = ((NamedAssociationModel)associationDescriptor).getBuilderInfo();
            value = stateResolver.getNamedAssociationState(associationDescriptor);
            NamedAssociationValueState namedAssociationState = new NamedAssociationValueState((Map<String, EntityReference>)value);
            associationInstance = new NamedAssociationInstance((AssociationInfo)builderInfo, currentModule.getEntityFunction(), namedAssociationState);
            this.namedAssociations.put(associationDescriptor.accessor(), (NamedAssociationInstance<?>)associationInstance);
        }
    }

    public <T> PropertyInstance<T> propertyFor(AccessibleObject accessor) throws IllegalArgumentException {
        PropertyInstance<?> property = this.properties.get(accessor);
        if (property == null) {
            throw new IllegalArgumentException("No such property:" + accessor);
        }
        return property;
    }

    public Iterable<PropertyInstance<?>> properties() {
        return this.properties.values();
    }

    public <T> AssociationInstance<T> associationFor(AccessibleObject accessor) {
        AssociationInstance<?> association = this.associations.get(accessor);
        if (association == null) {
            throw new IllegalArgumentException("No such association:" + accessor);
        }
        return association;
    }

    public Iterable<AssociationInstance<?>> allAssociations() {
        return this.associations.values();
    }

    public <T> ManyAssociationInstance<T> manyAssociationFor(AccessibleObject accessor) {
        ManyAssociationInstance<?> manyAssociation = this.manyAssociations.get(accessor);
        if (manyAssociation == null) {
            throw new IllegalArgumentException("No such many-association:" + accessor);
        }
        return manyAssociation;
    }

    public Iterable<ManyAssociationInstance<?>> allManyAssociations() {
        return this.manyAssociations.values();
    }

    public <T> NamedAssociationInstance<T> namedAssociationFor(AccessibleObject accessor) {
        NamedAssociationInstance<?> namedAssociation = this.namedAssociations.get(accessor);
        if (namedAssociation == null) {
            throw new IllegalArgumentException("No such named-association:" + accessor);
        }
        return namedAssociation;
    }

    public Iterable<? extends NamedAssociationInstance<?>> allNamedAssociations() {
        return this.namedAssociations.values();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ValueStateInstance)) {
            return false;
        }
        ValueStateInstance state = (ValueStateInstance)obj;
        if (!this.properties.equals(state.properties)) {
            return false;
        }
        if (!this.associations.equals(state.associations)) {
            return false;
        }
        if (!this.manyAssociations.equals(state.manyAssociations)) {
            return false;
        }
        return this.namedAssociations.equals(state.namedAssociations);
    }

    public int hashCode() {
        int result = this.properties.hashCode();
        result = 31 * result + this.associations.hashCode();
        result = 31 * result + this.manyAssociations.hashCode();
        result = 31 * result + this.namedAssociations.hashCode();
        return result;
    }
}

