/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.test.cache;

import java.util.Collection;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;
import org.qi4j.api.constraint.ConstraintViolation;
import org.qi4j.api.constraint.ConstraintViolationException;
import org.qi4j.api.util.NullArgumentException;
import org.qi4j.spi.cache.Cache;
import org.qi4j.spi.cache.CachePool;
import org.qi4j.test.AbstractQi4jTest;

public abstract class AbstractCachePoolTest
extends AbstractQi4jTest {
    protected CachePool cachePool;
    protected Cache<String> cache;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.cachePool = (CachePool)this.module.findService(CachePool.class).get();
        this.cache = this.cachePool.fetchCache("1", String.class);
    }

    @Test
    public void givenInvalidCacheNameWhenFetchingCacheExpectNullArgumentException() {
        try {
            this.cache = this.cachePool.fetchCache("", String.class);
            Assert.fail((String)("Expected " + NullArgumentException.class.getSimpleName()));
        }
        catch (NullArgumentException e) {
            // empty catch block
        }
        try {
            this.cache = this.cachePool.fetchCache(null, String.class);
            Assert.fail((String)("Expected " + NullArgumentException.class.getSimpleName()));
        }
        catch (ConstraintViolationException e) {
            Collection violations = e.constraintViolations();
            Assert.assertEquals((long)1L, (long)violations.size());
            ConstraintViolation violation = (ConstraintViolation)violations.iterator().next();
            Assert.assertEquals((Object)"not optional", (Object)violation.constraint().toString());
            Assert.assertEquals((Object)"param1", (Object)violation.name());
        }
    }

    @Test
    public void givenLoooongCacheNameWhenFetchingCacheExpectOk() {
        Random random = new Random();
        StringBuilder longName = new StringBuilder();
        for (int i = 0; i < 10000; ++i) {
            longName.append((char)(random.nextInt(26) + 65));
        }
        this.cache = this.cachePool.fetchCache(longName.toString(), String.class);
    }

    @Test
    public void givenEmptyCacheWhenFetchingValueExpectNull() {
        Assert.assertNull((Object)this.cache.get("1"));
    }

    @Test
    public void givenCacheWithAValueWhenRequestingThatValueExpectItBack() {
        this.cache.put("Habba", (Object)"Zout");
        Assert.assertEquals((Object)"Zout", (Object)this.cache.get("Habba"));
    }

    @Test
    public void givenCacheWithAValueWhenReplacingValueExpectNewValue() {
        this.cache.put("Habba", (Object)"Zout");
        Assert.assertEquals((Object)"Zout", (Object)this.cache.get("Habba"));
        this.cache.put("Habba", (Object)"Zout2");
        Assert.assertEquals((Object)"Zout2", (Object)this.cache.get("Habba"));
    }

    @Test
    public void givenCacheWithValueWhenDroppingReferenceAndRequestNewCacheAndItsValueExpectItToBeGone() {
        this.cache.put("Habba", (Object)"Zout");
        Assert.assertEquals((Object)"Zout", (Object)this.cache.get("Habba"));
        this.cachePool.returnCache(this.cache);
        this.cache = this.cachePool.fetchCache("1", String.class);
        Assert.assertNull((String)"Value not missing", (Object)this.cache.get("Habba"));
    }
}

