/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.test.entity;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.qi4j.api.association.Association;
import org.qi4j.api.association.ManyAssociation;
import org.qi4j.api.association.NamedAssociation;
import org.qi4j.api.common.Optional;
import org.qi4j.api.common.UseDefaults;
import org.qi4j.api.entity.EntityBuilder;
import org.qi4j.api.entity.EntityComposite;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.property.Property;
import org.qi4j.api.unitofwork.ConcurrentEntityModificationException;
import org.qi4j.api.unitofwork.NoSuchEntityException;
import org.qi4j.api.unitofwork.UnitOfWork;
import org.qi4j.api.unitofwork.UnitOfWorkCompletionException;
import org.qi4j.api.value.ValueBuilder;
import org.qi4j.api.value.ValueComposite;
import org.qi4j.bootstrap.AssemblyException;
import org.qi4j.bootstrap.ModuleAssembly;
import org.qi4j.spi.entitystore.EntityStore;
import org.qi4j.spi.uuid.UuidIdentityGeneratorService;
import org.qi4j.test.AbstractQi4jTest;

public abstract class AbstractEntityStoreTest
extends AbstractQi4jTest {
    @Service
    private EntityStore store;

    public void assemble(ModuleAssembly module) throws AssemblyException {
        module.services(new Class[]{UuidIdentityGeneratorService.class});
        module.entities(new Class[]{TestEntity.class});
        module.values(new Class[]{TestValue.class, TestValue2.class, TjabbaValue.class});
        module.objects(new Class[]{this.getClass()});
    }

    @Before
    public void init() {
        this.module.injectTo((Object)this, new Object[0]);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    protected TestEntity createEntity(UnitOfWork unitOfWork) throws UnitOfWorkCompletionException {
        EntityBuilder builder = unitOfWork.newEntityBuilder(TestEntity.class);
        ((TestEntity)builder.instance()).dateValue().set((Object)new Date());
        TestEntity instance = (TestEntity)builder.newInstance();
        instance.name().set((Object)"Test");
        instance.intValue().set((Object)42);
        instance.longValue().set((Object)42L);
        instance.doubleValue().set((Object)42.0);
        instance.floatValue().set((Object)Float.valueOf(42.0f));
        instance.booleanValue().set((Object)Boolean.TRUE);
        instance.bigIntegerValue().set((Object)new BigInteger("42"));
        instance.bigDecimalValue().set((Object)new BigDecimal("42"));
        instance.dateValue().set((Object)new DateTime((Object)"2020-03-04T13:24:35", DateTimeZone.UTC).toDate());
        instance.dateTimeValue().set((Object)new DateTime((Object)"2020-03-04T13:24:35", DateTimeZone.UTC));
        instance.localDateTimeValue().set((Object)new LocalDateTime((Object)"2020-03-04T13:23:00"));
        instance.localDateValue().set((Object)new LocalDate((Object)"2020-03-04"));
        instance.association().set((Object)instance);
        ValueBuilder valueBuilder4 = this.module.newValueBuilder(Tjabba.class);
        Tjabba prototype4 = (Tjabba)valueBuilder4.prototype();
        prototype4.bling().set((Object)"BlinkLjus");
        ValueBuilder valueBuilder2 = this.module.newValueBuilder(TestValue2.class);
        TestValue2 prototype2 = (TestValue2)valueBuilder2.prototype();
        prototype2.stringValue().set((Object)"Bar");
        Tjabba newValue = (Tjabba)valueBuilder4.newInstance();
        prototype2.anotherValue().set((Object)newValue);
        prototype2.anotherValue().set((Object)newValue);
        ValueBuilder valueBuilder3 = this.module.newValueBuilder(Tjabba.class);
        Tjabba prototype3 = (Tjabba)valueBuilder3.prototype();
        prototype3.bling().set((Object)"Brakfis");
        ValueBuilder valueBuilder1 = this.module.newValueBuilder(TestValue.class);
        TestValue prototype = (TestValue)valueBuilder1.prototype();
        prototype.enumProperty().set((Object)TestEnum.VALUE3);
        ((List)prototype.listProperty().get()).add("Foo");
        prototype.valueProperty().set(valueBuilder2.newInstance());
        prototype.tjabbaProperty().set(valueBuilder3.newInstance());
        HashMap<String, String> mapValue = new HashMap<String, String>(1);
        mapValue.put("foo", "bar");
        prototype.mapStringStringProperty().set(mapValue);
        instance.valueProperty().set(valueBuilder1.newInstance());
        instance.manyAssociation().add(0, (Object)instance);
        instance.namedAssociation().put("foo", (Object)instance);
        instance.namedAssociation().put("bar", (Object)instance);
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void whenNewEntityThenCanFindEntityAndCorrectValues() throws Exception {
        UnitOfWork unitOfWork = this.module.newUnitOfWork();
        try {
            TestEntity instance = this.createEntity(unitOfWork);
            unitOfWork.complete();
            unitOfWork = this.module.newUnitOfWork();
            instance = (TestEntity)unitOfWork.get((Object)instance);
            Assert.assertThat((String)"property 'intValue' has correct value", (Object)instance.intValue().get(), (Matcher)CoreMatchers.equalTo((Object)42));
            Assert.assertThat((String)"property 'longValue' has correct value", (Object)instance.longValue().get(), (Matcher)CoreMatchers.equalTo((Object)42L));
            Assert.assertThat((String)"property 'doubleValue' has correct value", (Object)instance.doubleValue().get(), (Matcher)CoreMatchers.equalTo((Object)42.0));
            Assert.assertThat((String)"property 'floatValue' has correct value", (Object)instance.floatValue().get(), (Matcher)CoreMatchers.equalTo((Object)Float.valueOf(42.0f)));
            Assert.assertThat((String)"property 'booleanValue' has correct value", (Object)instance.booleanValue().get(), (Matcher)CoreMatchers.equalTo((Object)Boolean.TRUE));
            Assert.assertThat((String)"property 'bigInteger' has correct value", (Object)instance.bigIntegerValue().get(), (Matcher)CoreMatchers.equalTo((Object)new BigInteger("42")));
            Assert.assertThat((String)"property 'bigDecimal' has correct value", (Object)instance.bigDecimalValue().get(), (Matcher)CoreMatchers.equalTo((Object)new BigDecimal("42")));
            Assert.assertThat((String)"property 'dateValue' has correct value", (Object)instance.dateValue().get(), (Matcher)CoreMatchers.equalTo((Object)new DateTime((Object)"2020-03-04T13:24:35", DateTimeZone.UTC).toDate()));
            Assert.assertThat((String)"property 'dateTimeValue' has correct value", (Object)instance.dateTimeValue().get(), (Matcher)CoreMatchers.equalTo((Object)new DateTime((Object)"2020-03-04T13:24:35", DateTimeZone.UTC)));
            Assert.assertThat((String)"property 'localDateTimeValue' has correct value", (Object)instance.localDateTimeValue().get(), (Matcher)CoreMatchers.equalTo((Object)new LocalDateTime((Object)"2020-03-04T13:23:00", DateTimeZone.UTC)));
            Assert.assertThat((String)"property 'localDateValue' has correct value", (Object)instance.localDateValue().get(), (Matcher)CoreMatchers.equalTo((Object)new LocalDate((Object)"2020-03-04")));
            Assert.assertThat((String)"property 'name' has correct value", (Object)instance.name().get(), (Matcher)CoreMatchers.equalTo((Object)"Test"));
            Assert.assertThat((String)"property 'unsetName' has correct value", (Object)instance.unsetName().get(), (Matcher)CoreMatchers.equalTo(null));
            Assert.assertThat((String)"property 'emptyName' has correct value", (Object)instance.emptyName().get(), (Matcher)CoreMatchers.equalTo((Object)""));
            Assert.assertThat((String)"property 'valueProperty.stringValue' has correct value", (Object)((TestValue2)((TestValue)instance.valueProperty().get()).valueProperty().get()).stringValue().get(), (Matcher)CoreMatchers.equalTo((Object)"Bar"));
            Assert.assertThat((String)"property 'valueProperty.listProperty' has correct value", ((List)((TestValue)instance.valueProperty().get()).listProperty().get()).get(0), (Matcher)CoreMatchers.equalTo((Object)"Foo"));
            Assert.assertThat((String)"property 'valueProperty.enumProperty' has correct value", (Object)((TestValue)instance.valueProperty().get()).enumProperty().get(), (Matcher)CoreMatchers.equalTo((Object)((Object)TestEnum.VALUE3)));
            Assert.assertThat((String)"property 'valueProperty.anotherValue.bling' has correct value", (Object)((Tjabba)((TestValue2)((TestValue)instance.valueProperty().get()).valueProperty().get()).anotherValue().get()).bling().get(), (Matcher)CoreMatchers.equalTo((Object)"BlinkLjus"));
            Assert.assertThat((String)"property 'valueProperty.tjabbaProperty.bling' has correct value", (Object)((Tjabba)((TestValue)instance.valueProperty().get()).tjabbaProperty().get()).bling().get(), (Matcher)CoreMatchers.equalTo((Object)"Brakfis"));
            HashMap<String, String> mapValue = new HashMap<String, String>();
            mapValue.put("foo", "bar");
            Assert.assertThat((String)"property 'valueProperty.mapStringStringProperty' has correct value", (Object)((TestValue)instance.valueProperty().get()).mapStringStringProperty().get(), (Matcher)CoreMatchers.equalTo(mapValue));
            Assert.assertThat((String)"association has correct value", (Object)instance.association().get(), (Matcher)CoreMatchers.equalTo((Object)instance));
            Assert.assertThat((String)"manyAssociation has correct value", instance.manyAssociation().iterator().next(), (Matcher)CoreMatchers.equalTo((Object)instance));
            Assert.assertThat((String)"namedAssociation has correct 'foo' value", (Object)instance.namedAssociation().get("foo"), (Matcher)CoreMatchers.equalTo((Object)instance));
            Assert.assertThat((String)"namedAssociation has correct 'bar' value", (Object)instance.namedAssociation().get("bar"), (Matcher)CoreMatchers.equalTo((Object)instance));
            unitOfWork.discard();
        }
        finally {
            unitOfWork.discard();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void whenRemovedEntityThenCannotFindEntity() throws Exception {
        UnitOfWork unitOfWork = this.module.newUnitOfWork();
        TestEntity newInstance = this.createEntity(unitOfWork);
        String identity = (String)newInstance.identity().get();
        unitOfWork.complete();
        unitOfWork = this.module.newUnitOfWork();
        TestEntity instance = (TestEntity)unitOfWork.get((Object)newInstance);
        unitOfWork.remove((Object)instance);
        unitOfWork.complete();
        unitOfWork = this.module.newUnitOfWork();
        try {
            unitOfWork.get(TestEntity.class, identity);
            Assert.fail((String)"Should not be able to find entity");
        }
        catch (NoSuchEntityException e) {
        }
        finally {
            unitOfWork.discard();
        }
    }

    @Test
    public void givenEntityIsNotModifiedWhenUnitOfWorkCompletesThenDontStoreState() throws UnitOfWorkCompletionException {
        UnitOfWork unitOfWork = this.module.newUnitOfWork();
        EntityBuilder builder = unitOfWork.newEntityBuilder(TestEntity.class);
        TestEntity testEntity = (TestEntity)builder.newInstance();
        unitOfWork.complete();
        unitOfWork = this.module.newUnitOfWork();
        testEntity = (TestEntity)unitOfWork.get((Object)testEntity);
        String version = this.spi.entityStateOf((EntityComposite)testEntity).version();
        unitOfWork.complete();
        unitOfWork = this.module.newUnitOfWork();
        testEntity = (TestEntity)unitOfWork.get((Object)testEntity);
        String newVersion = this.spi.entityStateOf((EntityComposite)testEntity).version();
        Assert.assertThat((String)"version has not changed", (Object)newVersion, (Matcher)CoreMatchers.equalTo((Object)version));
        unitOfWork.complete();
    }

    @Test
    public void givenPropertyIsModifiedWhenUnitOfWorkCompletesThenStoreState() throws UnitOfWorkCompletionException {
        UnitOfWork unitOfWork = this.module.newUnitOfWork();
        EntityBuilder builder = unitOfWork.newEntityBuilder(TestEntity.class);
        TestEntity testEntity = (TestEntity)builder.newInstance();
        unitOfWork.complete();
        unitOfWork = this.module.newUnitOfWork();
        testEntity = (TestEntity)unitOfWork.get((Object)testEntity);
        testEntity.name().set((Object)"Rickard");
        String version = this.spi.entityStateOf((EntityComposite)testEntity).version();
        unitOfWork.complete();
        unitOfWork = this.module.newUnitOfWork();
        testEntity = (TestEntity)unitOfWork.get((Object)testEntity);
        String newVersion = this.spi.entityStateOf((EntityComposite)testEntity).version();
        Assert.assertThat((String)"version has changed", (Object)newVersion, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)version)));
        unitOfWork.complete();
    }

    @Test
    public void givenManyAssociationIsModifiedWhenUnitOfWorkCompletesThenStoreState() throws UnitOfWorkCompletionException {
        UnitOfWork unitOfWork = this.module.newUnitOfWork();
        EntityBuilder builder = unitOfWork.newEntityBuilder(TestEntity.class);
        TestEntity testEntity = (TestEntity)builder.newInstance();
        unitOfWork.complete();
        unitOfWork = this.module.newUnitOfWork();
        testEntity = (TestEntity)unitOfWork.get((Object)testEntity);
        testEntity.manyAssociation().add(0, (Object)testEntity);
        String version = this.spi.entityStateOf((EntityComposite)testEntity).version();
        unitOfWork.complete();
        unitOfWork = this.module.newUnitOfWork();
        testEntity = (TestEntity)unitOfWork.get((Object)testEntity);
        String newVersion = this.spi.entityStateOf((EntityComposite)testEntity).version();
        Assert.assertThat((String)"version has changed", (Object)newVersion, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)version)));
        unitOfWork.complete();
    }

    @Test
    public void givenConcurrentUnitOfWorksWhenUoWCompletesThenCheckConcurrentModification() throws UnitOfWorkCompletionException {
        UnitOfWork unitOfWork = this.module.newUnitOfWork();
        EntityBuilder builder = unitOfWork.newEntityBuilder(TestEntity.class);
        TestEntity testEntity = (TestEntity)builder.newInstance();
        unitOfWork.complete();
        UnitOfWork unitOfWork1 = this.module.newUnitOfWork();
        TestEntity testEntity1 = (TestEntity)unitOfWork1.get((Object)testEntity);
        String version = this.spi.entityStateOf((EntityComposite)testEntity1).version();
        if (version.isEmpty()) {
            unitOfWork1.discard();
            return;
        }
        testEntity1.name().set((Object)"A");
        testEntity1.unsetName().set((Object)"A");
        UnitOfWork unitOfWork2 = this.module.newUnitOfWork();
        TestEntity testEntity2 = (TestEntity)unitOfWork2.get((Object)testEntity);
        Assert.assertThat((String)"version is correct", (Object)this.spi.entityStateOf((EntityComposite)testEntity1).version(), (Matcher)CoreMatchers.equalTo((Object)version));
        testEntity2.name().set((Object)"B");
        unitOfWork2.complete();
        try {
            unitOfWork1.complete();
            Assert.fail((String)"Should have thrown concurrent modification exception");
        }
        catch (ConcurrentEntityModificationException e) {
            unitOfWork1.discard();
        }
        unitOfWork1 = this.module.newUnitOfWork();
        testEntity1 = (TestEntity)unitOfWork1.get((Object)testEntity);
        Assert.assertThat((String)"property name has not been set", (Object)testEntity1.name().get(), (Matcher)CoreMatchers.equalTo((Object)"B"));
        Assert.assertThat((String)"version is incorrect", (Object)this.spi.entityStateOf((EntityComposite)testEntity1).version(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)version)));
        unitOfWork1.discard();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void givenEntityStoredLoadedChangedWhenUnitOfWorkDiscardsThenDontStoreState() throws UnitOfWorkCompletionException {
        UnitOfWork unitOfWork = this.module.newUnitOfWork();
        try {
            String identity = (String)this.createEntity(unitOfWork).identity().get();
            unitOfWork.complete();
            unitOfWork = this.module.newUnitOfWork();
            TestEntity entity = (TestEntity)unitOfWork.get(TestEntity.class, identity);
            Assert.assertThat((Object)entity.intValue().get(), (Matcher)CoreMatchers.is((Object)42));
            entity.intValue().set((Object)23);
            unitOfWork.discard();
            unitOfWork = this.module.newUnitOfWork();
            entity = (TestEntity)unitOfWork.get(TestEntity.class, identity);
            Assert.assertThat((Object)entity.intValue().get(), (Matcher)CoreMatchers.is((Object)42));
        }
        finally {
            unitOfWork.discard();
        }
    }

    public static enum TestEnum {
        VALUE1,
        VALUE2,
        VALUE3;

    }

    public static interface TestValue2
    extends ValueComposite {
        public Property<String> stringValue();

        public Property<Tjabba> anotherValue();
    }

    public static interface TestValue
    extends ValueComposite {
        @UseDefaults
        public Property<String> stringProperty();

        @UseDefaults
        public Property<Integer> intProperty();

        @UseDefaults
        public Property<TestEnum> enumProperty();

        @UseDefaults
        public Property<List<String>> listProperty();

        @UseDefaults
        public Property<Map<String, Tjabba>> mapProperty();

        public Property<TestValue2> valueProperty();

        public Property<Tjabba> tjabbaProperty();

        public Property<Map<String, String>> mapStringStringProperty();
    }

    public static interface Tjabba {
        public Property<String> bling();
    }

    public static interface TjabbaValue
    extends Tjabba,
    ValueComposite {
    }

    public static interface TestEntity
    extends EntityComposite {
        @UseDefaults
        public Property<Integer> intValue();

        @UseDefaults
        public Property<Long> longValue();

        @UseDefaults
        public Property<Double> doubleValue();

        @UseDefaults
        public Property<Float> floatValue();

        @UseDefaults
        public Property<Boolean> booleanValue();

        @Optional
        public Property<BigInteger> bigIntegerValue();

        @Optional
        public Property<BigDecimal> bigDecimalValue();

        @Optional
        public Property<Date> dateValue();

        @Optional
        public Property<DateTime> dateTimeValue();

        @Optional
        public Property<LocalDateTime> localDateTimeValue();

        @Optional
        public Property<LocalDate> localDateValue();

        @Optional
        public Property<String> name();

        @Optional
        public Property<String> unsetName();

        @UseDefaults
        public Property<String> emptyName();

        @Optional
        public Property<TestValue> valueProperty();

        @Optional
        public Association<TestEntity> association();

        @Optional
        public Association<TestEntity> unsetAssociation();

        public ManyAssociation<TestEntity> manyAssociation();

        public NamedAssociation<TestEntity> namedAssociation();
    }
}

