/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.test.indexing;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Test;
import org.qi4j.api.composite.Composite;
import org.qi4j.api.query.Query;
import org.qi4j.api.query.QueryExpressions;
import org.qi4j.api.query.grammar.OrderBy;
import org.qi4j.bootstrap.AssemblyException;
import org.qi4j.bootstrap.ModuleAssembly;
import org.qi4j.functional.Specification;
import org.qi4j.spi.query.EntityFinderException;
import org.qi4j.spi.query.IndexExporter;
import org.qi4j.test.EntityTestAssembler;
import org.qi4j.test.indexing.AbstractAnyQueryTest;
import org.qi4j.test.indexing.NameableAssert;
import org.qi4j.test.indexing.model.City;
import org.qi4j.test.indexing.model.Domain;
import org.qi4j.test.indexing.model.Female;
import org.qi4j.test.indexing.model.Male;
import org.qi4j.test.indexing.model.Nameable;
import org.qi4j.test.indexing.model.Person;

public abstract class AbstractNamedQueryTest
extends AbstractAnyQueryTest {
    private final Map<String, Specification<Composite>> queries = new HashMap<String, Specification<Composite>>();

    @Override
    public void assemble(ModuleAssembly module) throws AssemblyException {
        super.assemble(module);
        new EntityTestAssembler().assemble(module);
        String[] query = this.queryStrings();
        for (int i = 0; i < query.length; ++i) {
            String queryName = String.format("script%02d", i + 1);
            if (query[i].length() == 0) continue;
            Specification<Composite> expression = this.createNamedQueryDescriptor(queryName, query[i]);
            this.queries.put(queryName, expression);
        }
    }

    protected abstract String[] queryStrings();

    protected abstract Specification<Composite> createNamedQueryDescriptor(String var1, String var2);

    @Test
    public void showNetwork() throws IOException {
        IndexExporter indexerExporter = (IndexExporter)this.module.findService(IndexExporter.class).get();
        indexerExporter.exportReadableToStream(System.out);
    }

    @Test
    public void script01() throws EntityFinderException {
        Query query = this.unitOfWork.newQuery(this.module.newQueryBuilder(Person.class).where(this.queries.get("script01")));
        System.out.println("*** script01: " + query);
        NameableAssert.verifyUnorderedResults((Iterable<? extends Nameable>)query, "Joe Doe", "Ann Doe", "Jack Doe");
    }

    @Test
    public void script02() throws EntityFinderException {
        Query query = this.unitOfWork.newQuery(this.module.newQueryBuilder(Domain.class).where(this.queries.get("script02")));
        System.out.println("*** script02: " + query);
        NameableAssert.verifyUnorderedResults((Iterable<? extends Nameable>)query, "Gaming");
    }

    @Test
    public void script03() throws EntityFinderException {
        Query query = this.unitOfWork.newQuery(this.module.newQueryBuilder(Nameable.class).where(this.queries.get("script03")));
        System.out.println("*** script03: " + query);
        NameableAssert.verifyUnorderedResults((Iterable<? extends Nameable>)query, "Joe Doe", "Ann Doe", "Jack Doe", "Penang", "Kuala Lumpur", "Cooking", "Gaming", "Programming", "Cars");
    }

    @Test
    public void script04() throws EntityFinderException {
        Query query = this.unitOfWork.newQuery(this.module.newQueryBuilder(Person.class).where(this.queries.get("script04")));
        System.out.println("*** script04: " + query);
        NameableAssert.verifyUnorderedResults((Iterable<? extends Nameable>)query, "Joe Doe", "Ann Doe");
    }

    @Test
    public void script05() throws EntityFinderException {
        Query query = this.unitOfWork.newQuery(this.module.newQueryBuilder(Person.class).where(this.queries.get("script05")));
        System.out.println("*** script05: " + query);
        NameableAssert.verifyUnorderedResults((Iterable<? extends Nameable>)query, "Joe Doe");
    }

    @Test
    public void script06() throws EntityFinderException {
        Query query = this.unitOfWork.newQuery(this.module.newQueryBuilder(Person.class).where(this.queries.get("script06")));
        System.out.println("*** script06: " + query);
        NameableAssert.verifyUnorderedResults((Iterable<? extends Nameable>)query, "Joe Doe", "Ann Doe");
    }

    @Test
    public void script07() throws EntityFinderException {
        Query query = this.unitOfWork.newQuery(this.module.newQueryBuilder(Nameable.class).where(this.queries.get("script07")));
        System.out.println("*** script07: " + query);
        NameableAssert.verifyUnorderedResults((Iterable<? extends Nameable>)query, "Jack Doe");
    }

    @Test
    public void script08() throws EntityFinderException {
        Query query = this.unitOfWork.newQuery(this.module.newQueryBuilder(Person.class).where(this.queries.get("script08")));
        System.out.println("*** script08: " + query);
        NameableAssert.verifyUnorderedResults((Iterable<? extends Nameable>)query, "Jack Doe", "Ann Doe");
    }

    @Test
    public void script09() throws EntityFinderException {
        Query query = this.unitOfWork.newQuery(this.module.newQueryBuilder(Female.class).where(this.queries.get("script09")));
        System.out.println("*** script09: " + query);
        NameableAssert.verifyUnorderedResults((Iterable<? extends Nameable>)query, "Ann Doe");
    }

    @Test
    public void script10() throws EntityFinderException {
        Query query = this.unitOfWork.newQuery(this.module.newQueryBuilder(Person.class).where(this.queries.get("script10")));
        System.out.println("*** script10: " + query);
        NameableAssert.verifyUnorderedResults((Iterable<? extends Nameable>)query, "Jack Doe", "Joe Doe");
    }

    @Test
    public void script11() throws EntityFinderException {
        Query query = this.unitOfWork.newQuery(this.module.newQueryBuilder(Person.class).where(this.queries.get("script11")));
        System.out.println("*** script11: " + query);
        NameableAssert.verifyUnorderedResults((Iterable<? extends Nameable>)query, "Joe Doe");
    }

    @Test
    public void script12() throws EntityFinderException {
        Query query = this.unitOfWork.newQuery(this.module.newQueryBuilder(Person.class).where(this.queries.get("script12")));
        System.out.println("*** script12: " + query);
        NameableAssert.verifyUnorderedResults((Iterable<? extends Nameable>)query, "Ann Doe", "Jack Doe");
    }

    @Test
    public void script13() throws EntityFinderException {
        Query query = this.unitOfWork.newQuery(this.module.newQueryBuilder(Person.class).where(this.queries.get("script13")));
        System.out.println("*** script13: " + query);
        NameableAssert.verifyUnorderedResults((Iterable<? extends Nameable>)query, "Jack Doe");
    }

    @Test
    public void script14() throws EntityFinderException {
        Query query = this.unitOfWork.newQuery(this.module.newQueryBuilder(Male.class).where(this.queries.get("script14")));
        System.out.println("*** script14: " + query);
        NameableAssert.verifyUnorderedResults((Iterable<? extends Nameable>)query, "Joe Doe");
    }

    @Test
    public void script15() throws EntityFinderException {
        Query query = this.unitOfWork.newQuery(this.module.newQueryBuilder(Person.class).where(this.queries.get("script15")));
        System.out.println("*** script15: " + query);
        NameableAssert.verifyUnorderedResults((Iterable<? extends Nameable>)query, "Joe Doe", "Ann Doe");
    }

    @Test
    public void script16() throws EntityFinderException {
        Nameable nameable = (Nameable)QueryExpressions.templateFor(Nameable.class);
        Query query = this.unitOfWork.newQuery(this.module.newQueryBuilder(Nameable.class).where(this.queries.get("script16")));
        query.orderBy(new OrderBy[]{QueryExpressions.orderBy(nameable.name())});
        query.maxResults(2);
        System.out.println("*** script16: " + query);
        NameableAssert.verifyOrderedResults((Iterable<? extends Nameable>)query, "Ann Doe", "Cars");
    }

    @Test
    public void script17() throws EntityFinderException {
        Nameable nameable = (Nameable)QueryExpressions.templateFor(Nameable.class);
        Query query = this.unitOfWork.newQuery(this.module.newQueryBuilder(Nameable.class).where(this.queries.get("script17")));
        query.orderBy(new OrderBy[]{QueryExpressions.orderBy(nameable.name())});
        query.firstResult(3);
        query.maxResults(3);
        System.out.println("*** script17: " + query);
        NameableAssert.verifyOrderedResults((Iterable<? extends Nameable>)query, "Gaming", "Jack Doe", "Joe Doe");
    }

    @Test
    public void script18() throws EntityFinderException {
        Nameable nameable = (Nameable)QueryExpressions.templateFor(Nameable.class);
        Query query = this.unitOfWork.newQuery(this.module.newQueryBuilder(Nameable.class).where(this.queries.get("script18")));
        query.orderBy(new OrderBy[]{QueryExpressions.orderBy(nameable.name())});
        System.out.println("*** script18: " + query);
        NameableAssert.verifyOrderedResults((Iterable<? extends Nameable>)query, "Ann Doe", "Cars", "Cooking", "Gaming", "Jack Doe", "Joe Doe", "Kuala Lumpur", "Penang", "Programming");
    }

    @Test
    public void script19() throws EntityFinderException {
        Nameable nameable = (Nameable)QueryExpressions.templateFor(Nameable.class);
        Query query = this.unitOfWork.newQuery(this.module.newQueryBuilder(Nameable.class).where(this.queries.get("script19")));
        query.orderBy(new OrderBy[]{QueryExpressions.orderBy(nameable.name())});
        System.out.println("*** script19: " + query);
        NameableAssert.verifyOrderedResults((Iterable<? extends Nameable>)query, "Gaming", "Jack Doe", "Joe Doe", "Kuala Lumpur", "Penang", "Programming");
    }

    @Test
    public void script20() throws EntityFinderException {
        Person person = (Person)QueryExpressions.templateFor(Person.class);
        Query query = this.unitOfWork.newQuery(this.module.newQueryBuilder(Person.class).where(this.queries.get("script20")));
        query.orderBy(new OrderBy[]{QueryExpressions.orderBy(person.name(), (OrderBy.Order)OrderBy.Order.DESCENDING)});
        System.out.println("*** script20: " + query);
        NameableAssert.verifyOrderedResults((Iterable<? extends Nameable>)query, "Joe Doe", "Ann Doe");
    }

    @Test
    public void script21() throws EntityFinderException {
        Person person = (Person)QueryExpressions.templateFor(Person.class);
        Query query = this.unitOfWork.newQuery(this.module.newQueryBuilder(Person.class).where(this.queries.get("script21")));
        query.orderBy(new OrderBy[]{QueryExpressions.orderBy(((City)person.placeOfBirth().get()).name()), QueryExpressions.orderBy(person.yearOfBirth())});
        System.out.println("*** script21: " + query);
        NameableAssert.verifyOrderedResults((Iterable<? extends Nameable>)query, "Ann Doe", "Joe Doe", "Jack Doe");
    }

    @Test
    public void script22() throws EntityFinderException {
        Query query = this.unitOfWork.newQuery(this.module.newQueryBuilder(Nameable.class).where(this.queries.get("script22")));
        System.out.println("*** script22: " + query);
        NameableAssert.verifyUnorderedResults((Iterable<? extends Nameable>)query, "Jack Doe", "Joe Doe");
    }

    @Test
    public void script24() throws EntityFinderException {
        Query query = this.unitOfWork.newQuery(this.module.newQueryBuilder(Domain.class).where(this.queries.get("script24")));
        query.setVariable("domain", (Object)"Gaming");
        System.out.println("*** script24: " + query);
        Assert.assertThat((Object)((Domain)query.find()).name().get(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)"Gaming")));
    }
}

