/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.test.indexing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.qi4j.api.entity.EntityReference;
import org.qi4j.api.entity.Identity;
import org.qi4j.functional.Iterables;
import org.qi4j.test.indexing.model.Nameable;

public class NameableAssert {
    private static final Map<String, String> world = new HashMap<String, String>();

    public static void clear() {
        world.clear();
    }

    public static void assertNames(Iterable<EntityReference> identitiesIterable, String ... expectedNames) {
        NameableAssert.assertNames(true, identitiesIterable, expectedNames);
    }

    public static void assertNames(boolean sort, Iterable<EntityReference> identitiesIterable, String ... expectedNames) {
        List references = Iterables.toList(identitiesIterable);
        Assert.assertThat((String)(expectedNames.length + " entries(" + expectedNames.length + ", got " + NameableAssert.getNames(references) + ")"), (Object)references.size(), (Matcher)IsEqual.equalTo((Object)expectedNames.length));
        List<String> sortedNames = NameableAssert.getNames(references);
        List<String> expectedSorted = Arrays.asList(expectedNames);
        if (sort) {
            Collections.sort(sortedNames);
            Collections.sort(expectedSorted);
        }
        Assert.assertThat((String)"names", sortedNames, (Matcher)IsEqual.equalTo(expectedSorted));
    }

    public static void trace(Nameable nameable) {
        world.put((String)((Identity)nameable).identity().get(), (String)nameable.name().get());
    }

    public static void assertName(String expectedName, EntityReference reference) {
        String existingName = NameableAssert.getName(reference);
        Assert.assertThat((String)("Name of " + reference), (Object)existingName, (Matcher)IsEqual.equalTo((Object)expectedName));
    }

    public static String getName(EntityReference reference) {
        return world.get(reference.identity());
    }

    public static List<String> getNames(List<EntityReference> references) {
        ArrayList<String> result = new ArrayList<String>(references.size());
        for (EntityReference reference : references) {
            String name = NameableAssert.getName(reference);
            Assert.assertThat((String)("Name of " + reference), (Object)name, (Matcher)IsNull.notNullValue());
            result.add(name);
        }
        return result;
    }

    public static String[] allNames() {
        return world.values().toArray(new String[world.size()]);
    }

    public static void verifyUnorderedResults(Iterable<? extends Nameable> results, String ... names) {
        ArrayList<String> expected = new ArrayList<String>(Arrays.asList(names));
        ArrayList<String> unexpected = new ArrayList<String>();
        for (Nameable nameable : results) {
            String name = (String)nameable.name().get();
            if (expected.remove(name)) continue;
            unexpected.add(name);
        }
        if (!unexpected.isEmpty() || !expected.isEmpty()) {
            String message = "";
            if (!unexpected.isEmpty()) {
                message = message + unexpected + " returned but not expected\n";
            }
            if (!expected.isEmpty()) {
                message = message + expected + " expected but not returned\n";
            }
            Assert.fail((String)message.substring(0, message.length() - 1));
        }
    }

    public static void verifyOrderedResults(Iterable<? extends Nameable> results, String ... names) {
        ArrayList<String> expected = new ArrayList<String>(Arrays.asList(names));
        ArrayList<Object> actual = new ArrayList<Object>();
        for (Nameable nameable : results) {
            actual.add(nameable.name().get());
        }
        Assert.assertThat((String)"Result is incorrect", actual, (Matcher)IsEqual.equalTo(expected));
    }

    private NameableAssert() {
    }
}

