/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.test.indexing;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.qi4j.api.entity.EntityBuilder;
import org.qi4j.api.structure.Module;
import org.qi4j.api.unitofwork.UnitOfWork;
import org.qi4j.api.unitofwork.UnitOfWorkCompletionException;
import org.qi4j.api.value.ValueBuilder;
import org.qi4j.test.indexing.NameableAssert;
import org.qi4j.test.indexing.model.Account;
import org.qi4j.test.indexing.model.Address;
import org.qi4j.test.indexing.model.Cat;
import org.qi4j.test.indexing.model.City;
import org.qi4j.test.indexing.model.Domain;
import org.qi4j.test.indexing.model.Female;
import org.qi4j.test.indexing.model.Male;
import org.qi4j.test.indexing.model.Person;
import org.qi4j.test.indexing.model.Protocol;
import org.qi4j.test.indexing.model.QueryParam;
import org.qi4j.test.indexing.model.URL;
import org.qi4j.test.indexing.model.entities.CatEntity;
import org.qi4j.test.indexing.model.entities.FemaleEntity;
import org.qi4j.test.indexing.model.entities.MaleEntity;

class TestData {
    static void populate(Module module) throws UnitOfWorkCompletionException {
        try (UnitOfWork unitOfWork = module.newUnitOfWork();){
            NameableAssert.clear();
            EntityBuilder domainBuilder = unitOfWork.newEntityBuilder(Domain.class, "Gaming");
            Domain gaming = (Domain)domainBuilder.instance();
            gaming.name().set((Object)"Gaming");
            gaming.description().set((Object)"Gaming domain");
            gaming = (Domain)domainBuilder.newInstance();
            NameableAssert.trace(gaming);
            EntityBuilder domainBuilder2 = unitOfWork.newEntityBuilder(Domain.class);
            Domain programming = (Domain)domainBuilder2.instance();
            programming.name().set((Object)"Programming");
            programming.description().set((Object)"Programing domain");
            programming = (Domain)domainBuilder2.newInstance();
            NameableAssert.trace(programming);
            EntityBuilder domainBuilder3 = unitOfWork.newEntityBuilder(Domain.class);
            Domain cooking = (Domain)domainBuilder3.instance();
            cooking.name().set((Object)"Cooking");
            cooking.description().set((Object)"Cooking domain");
            cooking = (Domain)domainBuilder3.newInstance();
            NameableAssert.trace(cooking);
            EntityBuilder domainBuilder4 = unitOfWork.newEntityBuilder(Domain.class);
            Domain cars = (Domain)domainBuilder4.instance();
            cars.name().set((Object)"Cars");
            cars.description().set((Object)"Cars");
            cars = (Domain)domainBuilder4.newInstance();
            NameableAssert.trace(cars);
            EntityBuilder cityBuilder = unitOfWork.newEntityBuilder(City.class);
            City kualaLumpur = (City)cityBuilder.instance();
            kualaLumpur.name().set((Object)"Kuala Lumpur");
            kualaLumpur.country().set((Object)"Malaysia");
            kualaLumpur.county().set((Object)"Some Jaya");
            kualaLumpur = (City)cityBuilder.newInstance();
            NameableAssert.trace(kualaLumpur);
            EntityBuilder cityBuilder2 = unitOfWork.newEntityBuilder(City.class);
            City penang = (City)cityBuilder2.instance();
            penang.name().set((Object)"Penang");
            penang.country().set((Object)"Malaysia");
            penang.county().set((Object)"Some Other Jaya");
            penang = (City)cityBuilder2.newInstance();
            NameableAssert.trace(penang);
            EntityBuilder accountBuilder = unitOfWork.newEntityBuilder(Account.class, "accountOfAnnDoe");
            Account annsAccount = (Account)accountBuilder.instance();
            annsAccount.number().set((Object)"accountOfAnnDoe");
            annsAccount = (Account)accountBuilder.newInstance();
            EntityBuilder accountBuilder2 = unitOfWork.newEntityBuilder(Account.class, "accountOfJackDoe");
            Account jacksAccount = (Account)accountBuilder2.instance();
            jacksAccount.number().set((Object)"accountOfJackDoe");
            jacksAccount = (Account)accountBuilder2.newInstance();
            ValueBuilder addressBuilder = module.newValueBuilder(Address.class);
            Address address = (Address)addressBuilder.prototype();
            address.line1().set((Object)"Qi Street 4j");
            address.line2().set((Object)"Off main Java Street");
            address.zipcode().set((Object)"12345");
            EntityBuilder femaleBuilder = unitOfWork.newEntityBuilder(FemaleEntity.class, "anndoe");
            Female annDoe = (Female)femaleBuilder.instance();
            annDoe.name().set((Object)"Ann Doe");
            annDoe.title().set((Object)Person.Title.MRS);
            annDoe.placeOfBirth().set((Object)kualaLumpur);
            annDoe.yearOfBirth().set((Object)1975);
            annDoe.interests().add(0, (Object)cooking);
            annDoe.password().set((Object)"passwordOfAnnDoe");
            annDoe.mainAccount().set((Object)annsAccount);
            annDoe.accounts().put("anns", (Object)annsAccount);
            annDoe.accounts().put("jacks", (Object)jacksAccount);
            annDoe.address().set(addressBuilder.newInstance());
            annDoe = (Female)femaleBuilder.newInstance();
            NameableAssert.trace(annDoe);
            EntityBuilder maleBuilder = unitOfWork.newEntityBuilder(MaleEntity.class);
            Male joeDoe = (Male)maleBuilder.instance();
            joeDoe.name().set((Object)"Joe Doe");
            joeDoe.title().set((Object)Person.Title.MR);
            joeDoe.placeOfBirth().set((Object)kualaLumpur);
            joeDoe.yearOfBirth().set((Object)1990);
            joeDoe.mother().set((Object)annDoe);
            joeDoe.interests().add(0, (Object)programming);
            joeDoe.interests().add(0, (Object)gaming);
            joeDoe.email().set((Object)"joe@thedoes.net");
            joeDoe.password().set((Object)"passwordOfJoeDoe");
            joeDoe = (Male)maleBuilder.newInstance();
            address = (Address)module.newValueBuilderWithPrototype((Object)address).prototype();
            address.line1().set((Object)"Qi Alley 4j");
            joeDoe.address().set((Object)address);
            joeDoe.bigInteger().set((Object)new BigInteger("23232323232323232323232323"));
            joeDoe.bigDecimal().set((Object)new BigDecimal("23.4276931348623157e+309"));
            joeDoe.dateValue().set((Object)new DateTime((Object)"2020-03-04T13:24:35", DateTimeZone.UTC).toDate());
            joeDoe.dateTimeValue().set((Object)new DateTime((Object)"2020-03-04T13:24:35", DateTimeZone.UTC));
            joeDoe.localDateTimeValue().set((Object)new LocalDateTime((Object)"2020-03-04T13:23:00"));
            joeDoe.localDateValue().set((Object)new LocalDate((Object)"2020-03-04"));
            NameableAssert.trace(joeDoe);
            maleBuilder = unitOfWork.newEntityBuilder(MaleEntity.class);
            Male jackDoe = (Male)maleBuilder.instance();
            jackDoe.name().set((Object)"Jack Doe");
            jackDoe.title().set((Object)Person.Title.DR);
            jackDoe.placeOfBirth().set((Object)penang);
            jackDoe.yearOfBirth().set((Object)1970);
            jackDoe.interests().add(0, (Object)cars);
            jackDoe.wife().set((Object)annDoe);
            jackDoe.password().set((Object)"passwordOfJohnDoe");
            jackDoe.mainAccount().set((Object)jacksAccount);
            jackDoe.accounts().put("anns", (Object)annsAccount);
            jackDoe.accounts().put("jacks", (Object)jacksAccount);
            address = (Address)module.newValueBuilderWithPrototype((Object)address).prototype();
            address.line1().set((Object)"Qi Avenue 4j");
            jackDoe.address().set((Object)address);
            jackDoe.bigInteger().set((Object)new BigInteger("42424242424242424242424242"));
            jackDoe.bigDecimal().set((Object)new BigDecimal("42.2376931348623157e+309"));
            jackDoe.dateValue().set((Object)new DateTime((Object)"2010-03-04T13:24:35", DateTimeZone.UTC).toDate());
            jackDoe.dateTimeValue().set((Object)new DateTime((Object)"2010-03-04T13:24:35", DateTimeZone.UTC));
            jackDoe.localDateTimeValue().set((Object)new LocalDateTime((Object)"2010-03-04T13:23:00"));
            jackDoe.localDateValue().set((Object)new LocalDate((Object)"2010-03-04"));
            ValueBuilder urlBuilder = module.newValueBuilder(URL.class);
            ValueBuilder protocolBuilder = module.newValueBuilder(Protocol.class);
            ValueBuilder queryParamBuilder = module.newValueBuilder(QueryParam.class);
            Protocol protocol = (Protocol)protocolBuilder.prototype();
            protocol.value().set((Object)"http");
            ArrayList<Object> queryParams = new ArrayList<Object>(2);
            QueryParam param = (QueryParam)queryParamBuilder.prototype();
            param.name().set((Object)"user");
            param.value().set((Object)"jackdoe");
            queryParams.add(queryParamBuilder.newInstance());
            queryParamBuilder = module.newValueBuilder(QueryParam.class);
            param = (QueryParam)queryParamBuilder.prototype();
            param.name().set((Object)"password");
            param.value().set((Object)"somepassword");
            queryParams.add(queryParamBuilder.newInstance());
            URL url = (URL)urlBuilder.prototype();
            url.protocol().set(protocolBuilder.newInstance());
            url.queryParams().set(queryParams);
            jackDoe.personalWebsite().set(urlBuilder.newInstance());
            jackDoe = (Male)maleBuilder.newInstance();
            NameableAssert.trace(jackDoe);
            EntityBuilder catBuilder = unitOfWork.newEntityBuilder(CatEntity.class);
            Cat felix = (Cat)catBuilder.instance();
            felix.name().set((Object)"Felix");
            catBuilder.newInstance();
            unitOfWork.complete();
        }
    }

    private TestData() {
    }
}

