/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.test.util;

import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.util.Enumeration;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;

public class Assume
extends org.junit.Assume {
    public static void assumeNoIbmJdk() {
        Assume.assumeFalse((boolean)System.getProperty("java.vendor").contains("IBM"));
    }

    public static void assumeDisplayPresent() {
        try {
            Assume.assumeFalse((boolean)GraphicsEnvironment.getLocalGraphicsEnvironment().isHeadlessInstance());
            String display = System.getenv("DISPLAY");
            Assume.assumeThat((Object)display, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
            Assume.assumeTrue((display.length() > 0 ? 1 : 0) != 0);
        }
        catch (UnsatisfiedLinkError e) {
            Assume.assumeNoException((String)"Grahics system is missing?", (Throwable)e);
        }
    }

    public static void assumeNetworking() {
        try {
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            Assume.assumeThat(ifaces, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
            Assume.assumeTrue((boolean)ifaces.hasMoreElements());
        }
        catch (SocketException ex) {
            Assume.assumeNoException((Throwable)ex);
        }
    }

    public static void assumeConnectivity() {
        Assume.assumeConnectivity("qi4j.org", 80);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assumeConnectivity(String host, int port) {
        try {
            Socket socket = new Socket(host, port);
            Throwable throwable = null;
            if (socket != null) {
                if (throwable != null) {
                    try {
                        socket.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                } else {
                    socket.close();
                }
            }
        }
        catch (IOException ex) {
            Assume.assumeNoException((Throwable)ex);
        }
    }

    public static String assumeSystemPropertyNotNull(String key) {
        String property = System.getProperty(key);
        Assume.assumeNotNull((Object[])new Object[]{property});
        return property;
    }
}

