/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.test.util;

import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.Assert;

public class JSONAssert
extends Assert {
    public static void jsonObjectsEquals(JSONObject o1, JSONObject o2) throws JSONException {
        if (o1 != o2) {
            if (o1.length() != o2.length()) {
                JSONAssert.fail((String)("JSONObjects length differ: " + o1.length() + " / " + o2.length()));
            }
            Iterator o1Keys = o1.keys();
            while (o1Keys.hasNext()) {
                Object o2Value;
                String key = (String)o1Keys.next();
                Object o1Value = o1.get(key);
                if (JSONAssert.jsonValueEquals(o1Value, o2Value = o2.get(key))) continue;
                JSONAssert.fail((String)("JSONObject '" + key + "' values differ: " + o1Value + " / " + o2Value));
            }
        }
    }

    public static void jsonArraysEquals(JSONArray a1, JSONArray a2) throws JSONException {
        if (a1 != a2) {
            if (a1.length() != a2.length()) {
                JSONAssert.fail((String)("JSONArrays length differ: " + a1.length() + " / " + a2.length()));
            }
            for (int idx = 0; idx < a1.length(); ++idx) {
                Object a2Value;
                Object a1Value = a1.get(idx);
                if (JSONAssert.jsonValueEquals(a1Value, a2Value = a2.get(idx))) continue;
                JSONAssert.fail((String)("JSONArray '" + idx + "' values differ: " + a1Value + " / " + a2Value));
            }
        }
    }

    private static boolean jsonValueEquals(Object o1Value, Object o2Value) throws JSONException {
        if (o1Value instanceof JSONObject) {
            if (!(o2Value instanceof JSONObject)) {
                return false;
            }
            JSONAssert.jsonObjectsEquals((JSONObject)o1Value, (JSONObject)o2Value);
        } else if (o1Value instanceof JSONArray) {
            if (!(o2Value instanceof JSONArray)) {
                return false;
            }
            JSONAssert.jsonArraysEquals((JSONArray)o1Value, (JSONArray)o2Value);
        } else if (!o1Value.equals(o2Value)) {
            return false;
        }
        return true;
    }

    private JSONAssert() {
    }
}

