/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.test.value;

import java.util.Date;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.type.CollectionType;
import org.qi4j.api.type.ValueType;
import org.qi4j.api.value.ValueDeserializer;
import org.qi4j.bootstrap.AssemblyException;
import org.qi4j.bootstrap.ModuleAssembly;
import org.qi4j.test.AbstractQi4jTest;

public class AbstractJsonDateFormatTest
extends AbstractQi4jTest {
    private final ValueType dateType = new ValueType(Date.class);
    @Service
    protected ValueDeserializer valueDeserializer;

    public void assemble(ModuleAssembly module) throws AssemblyException {
    }

    @Before
    public void before() {
        this.module.injectTo((Object)this, new Object[0]);
    }

    @Test
    public void givenISO6801DateFormatWhenConvertingFromSerializedStateExpectValidDate() throws Exception {
        CollectionType collectionType = new CollectionType(List.class, this.dateType);
        List value = (List)this.valueDeserializer.deserialize((ValueType)collectionType, "[\"2009-08-12T14:54:27.895+0800\"]");
        Assert.assertEquals((Object)new DateTime((Object)"2009-08-12T06:54:27.895Z", DateTimeZone.UTC).toDate(), value.get(0));
    }

    @Test
    public void givenAtDateFormatWhenConvertingFromSerializedStateExpectValidDate() throws Exception {
        long tstamp = System.currentTimeMillis();
        CollectionType collectionType = new CollectionType(List.class, this.dateType);
        List value = (List)this.valueDeserializer.deserialize((ValueType)collectionType, "[\"@" + tstamp + "@\"]");
        Assert.assertEquals((Object)new Date(tstamp), value.get(0));
    }

    @Test
    public void givenMicrosoftDateFormatWhenConvertingFromSerializedStateExpectValidDate() throws Exception {
        long tstamp = System.currentTimeMillis();
        CollectionType collectionType = new CollectionType(List.class, this.dateType);
        List value = (List)this.valueDeserializer.deserialize((ValueType)collectionType, "[\"/Date(" + tstamp + ")/\"]");
        Assert.assertEquals((Object)new Date(tstamp), value.get(0));
    }
}

