/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.lang.scala;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import org.qi4j.api.Qi4j;
import org.qi4j.api.common.AppliesTo;
import org.qi4j.api.common.AppliesToFilter;
import org.qi4j.api.composite.Composite;
import org.qi4j.api.composite.CompositeDescriptor;
import org.qi4j.api.composite.CompositeInstance;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.This;
import org.qi4j.api.service.ServiceReference;
import org.qi4j.api.util.Classes;
import org.qi4j.functional.Function;
import org.qi4j.functional.Iterables;

@AppliesTo(value={TraitFilter.class})
public class ScalaTraitMixin
implements InvocationHandler {
    private static Map<Class<?>, Map<Method, InvocationHandler>> methods = new HashMap();
    private Class<?> compositeType;

    public ScalaTraitMixin(@This Composite composite) {
        this.compositeType = ((CompositeDescriptor)Qi4j.FUNCTION_DESCRIPTOR_FOR.map((Object)composite)).primaryType();
    }

    @Override
    public Object invoke(Object composite, Method method, Object[] args) throws Throwable {
        InvocationHandler handler = methods.get(this.compositeType).get(method);
        return handler.invoke(composite, method, args);
    }

    public static class TraitFilter
    implements AppliesToFilter {
        public boolean appliesTo(Method method, Class<?> mixin, Class<?> compositeType, Class<?> fragmentClass) {
            if (this.isScalaTrait(method.getDeclaringClass())) {
                if (method.getAnnotation(Service.class) != null) {
                    if (method.getReturnType().equals(ServiceReference.class)) {
                        InvocationHandler handler = new InvocationHandler(){

                            @Override
                            public Object invoke(Object composite, Method method, Object[] objects) throws Throwable {
                                return ((CompositeInstance)Proxy.getInvocationHandler(composite)).module().findService(method.getReturnType());
                            }
                        };
                        this.getHandlers(compositeType).put(method, handler);
                    } else {
                        InvocationHandler handler = new InvocationHandler(){

                            @Override
                            public Object invoke(Object composite, Method method, Object[] objects) throws Throwable {
                                return ((CompositeInstance)Proxy.getInvocationHandler(composite)).module().findService(method.getReturnType()).get();
                            }
                        };
                        this.getHandlers(compositeType).put(method, handler);
                    }
                    return true;
                }
                final Class<?> declaringClass = method.getDeclaringClass();
                Class traitClass = (Class)Iterables.last((Iterable)Iterables.map((Function)new Function<Class, Class>(){
                    Class current;

                    public Class map(Class aClass) {
                        if (declaringClass.isAssignableFrom(aClass)) {
                            try {
                                aClass.getClassLoader().loadClass(aClass.getName() + "$class");
                                this.current = this.current == null ? aClass : (this.current.isAssignableFrom(aClass) ? aClass : this.current);
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                // empty catch block
                            }
                        }
                        return this.current;
                    }
                }, (Iterable)Iterables.map((Function)Classes.RAW_CLASS, (Iterable)Classes.interfacesOf(compositeType))));
                if (traitClass == null) {
                    return false;
                }
                try {
                    Class<?> traitMixin = traitClass.getClassLoader().loadClass(traitClass.getName() + "$class");
                    Class<?>[] methodParameterTypes = method.getParameterTypes();
                    Class[] parameterTypes = new Class[1 + methodParameterTypes.length];
                    parameterTypes[0] = traitClass;
                    System.arraycopy(methodParameterTypes, 0, parameterTypes, 1, methodParameterTypes.length);
                    final Method traitMethod = traitMixin.getMethod(method.getName(), parameterTypes);
                    Map<Method, InvocationHandler> handlers = this.getHandlers(compositeType);
                    handlers.put(method, new InvocationHandler(){

                        @Override
                        public Object invoke(Object composite, Method method, Object[] args) throws Throwable {
                            if (args != null) {
                                Object[] params = new Object[args.length + 1];
                                params[0] = composite;
                                System.arraycopy(args, 0, params, 1, args.length);
                                return traitMethod.invoke(null, params);
                            }
                            return traitMethod.invoke(null, composite);
                        }
                    });
                    return true;
                }
                catch (ClassNotFoundException e) {
                    return false;
                }
                catch (NoSuchMethodException e) {
                    return false;
                }
            }
            return false;
        }

        private boolean isScalaTrait(Class<?> declaringClass) {
            for (Annotation annotation : declaringClass.getAnnotations()) {
                if (!annotation.annotationType().getSimpleName().equals("ScalaSignature")) continue;
                return true;
            }
            return false;
        }

        private Map<Method, InvocationHandler> getHandlers(Class<?> compositeType) {
            HashMap handlerMap = (HashMap)methods.get(compositeType);
            if (handlerMap == null) {
                handlerMap = new HashMap();
                methods.put(compositeType, handlerMap);
            }
            return handlerMap;
        }
    }
}

